/************************************************************************/
/*									*/
/*  Manage text attributes while saving an RTF file.			*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>
#   include	<appDebugon.h>

#   include	<uniUtf8.h>
#   include	"docRtf.h"

/************************************************************************/
/*									*/
/*  Finish/Begin writing a destination.					*/
/*									*/
/************************************************************************/

int docRtfPopAttribute(		RtfWritingContext *	rwc )
    {
    PushedAttribute *	pa;

    pa= rwc->rwcPushedAttribute;
    if  ( ! pa )
	{ XDEB(pa); return -1;	}

    rwc->rwcTextAttribute= pa->paTextAttribute;
    rwc->rwcTextCharset= pa->paTextCharset;
    rwc->rwcPushedAttribute= pa->paNext;

    free( pa );

    return 0;
    }

int docRtfPushAttribute(		RtfWritingContext *	rwc )
    {
    PushedAttribute *		pa;

    pa= malloc( sizeof( PushedAttribute ) );
    if  ( ! pa )
	{ XDEB(pa); return- 1;	}
    pa->paNext= rwc->rwcPushedAttribute;
    rwc->rwcPushedAttribute= pa;
    pa->paTextAttribute= rwc->rwcTextAttribute;
    pa->paTextCharset= rwc->rwcTextCharset;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Reset the text attribute.						*/
/*									*/
/************************************************************************/

void docRtfWriteSwitchToPlain(		RtfWritingContext *	rwc )
    {
    /*  1  */
    docPlainTextAttribute( &(rwc->rwcTextAttribute), rwc->rwcBd );
    rwc->rwcTextCharset= FONTcharsetANSI;

    /*  2  */
    docRtfWriteTag( rwc, "\\plain" );
    }

/************************************************************************/
/*									*/
/*  Switch text attributes.						*/
/*									*/
/************************************************************************/

void docRtfWriteSwitchTextAttributes(	RtfWritingContext *	rwc,
					int			textAttrNr,
					const char *		first )
    {
    const BufferDocument *	bd= rwc->rwcBd;
    TextAttribute		ta;

    int				symbol= ' ';

    if  ( first )
	{
	unsigned short	uni;
	int		step= uniGetUtf8( &uni, (const unsigned char *)first );

	if  ( step > 1 )
	    { symbol= uni;	}
	}

    utilGetTextAttributeByNumber( &ta, &(bd->bdTextAttributeList), textAttrNr );

    if  ( ta.taFontNumber >= 0 )
	{
	const DocumentProperties *	dp= &(bd->bdProperties);
	const DocumentFontList *	dfl= &(dp->dpFontList);
	const DocumentFont *		df;

	PropertyMask	chgMask;
	PropertyMask	updMask;

	utilPropMaskClear( &chgMask );
	utilPropMaskFill( &chgMask, TAprop_COUNT );

	utilPropMaskClear( &updMask );
	utilUpdateTextAttribute( &updMask, &(rwc->rwcTextAttribute),
							    &ta, &chgMask );
	if  ( PROPmaskISSET( &updMask, TApropSHADING ) )
	    {
	    const NumberedPropertiesList *	isl= &(bd->bdItemShadingList);

	    if  ( ! docShadingNumberIsShading( isl, ta.taShadingNumber ) )
		{
		docRtfWriteTag( rwc, "\\plain" );
		utilInitTextAttribute( &(rwc->rwcTextAttribute) );
		utilPropMaskClear( &updMask );
		utilUpdateTextAttribute( &updMask, &(rwc->rwcTextAttribute),
							    &ta, &chgMask );
		}
	    }

	df= docFontListGetFontByNumber( dfl, ta.taFontNumber );
	if  ( df )
	    {
	    int			fileFontNumber;
	    int			charset= FONTcharsetDEFAULT;
	    const char *	encodingName= (const char *)0;

	    fileFontNumber= docRtfWriteGetCharset( rwc, &charset, df, symbol );
	    if  ( fileFontNumber < 0 )
		{ SLXDEB(df->dfName,fileFontNumber,symbol);	}
	    else{ ta.taFontNumber= fileFontNumber;		}

	    if  ( rwc->rwcTextCharset != charset )
		{
		rwc->rwcTextCharset= charset;
		PROPmaskADD( &updMask, TApropDOC_FONT_NUMBER );
		}

	    encodingName= utilGetEncodingName( df->dfName, charset );
	    docRtfWriteSetTextEncodingName( rwc, encodingName );
	    }

	if  ( ! utilPropMaskIsEmpty( &updMask ) )
	    {
	    docRtfSaveTextAttribute( rwc, &updMask, &ta );
	    }
	}

    return;
    }

