/************************************************************************/
/*									*/
/*  Read an RTF text file into a BufferDocument				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>
#   include	<bitmap.h>

#   include	<appDebugon.h>

#   include	"docRtf.h"

int docRtfObjectProperty(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    InsertedObject *	io;

    io= docGetObject( rrc->rrcBd, rrc->rrcInsertedObjectNr );
    if  ( ! io )
	{
	LSXDEB(rrc->rrcCurrentLine,rcw->rcwWord,rrc->rrcInsertedObjectNr);
	return 0;
	}

    switch( rcw->rcwID )
	{
	case IOpropRESULT_KIND:
	    io->ioRtfResultKind= arg;
	    break;

	case IOpropEMBED_KIND:
	    io->ioRtfEmbedKind= arg;
	    break;

	case IOpropOBJTWIPS_WIDE:
	    io->ioTwipsWide= arg;
	    break;
	case IOpropOBJTWIPS_HIGH:
	    io->ioTwipsHigh= arg;
	    break;

	case IOpropOBJSCALE_X:
	    if  ( arg < 1 )
		{ LDEB(arg); arg= 1;	}
	    io->ioScaleXSet= arg;
	    io->ioScaleXUsed= io->ioScaleXSet;
	    break;
	case IOpropOBJSCALE_Y:
	    if  ( arg < 1 )
		{ LDEB(arg); arg= 1;	}
	    io->ioScaleYSet= arg;
	    io->ioScaleYUsed= io->ioScaleYSet;
	    break;

	case IOpropOBJCROP_TOP:
	    io->ioTopCropTwips= arg;
	    break;
	case IOpropOBJCROP_BOTTOM:
	    io->ioBottomCropTwips= arg;
	    break;
	case IOpropOBJCROP_LEFT:
	    io->ioLeftCropTwips= arg;
	    break;
	case IOpropOBJCROP_RIGHT:
	    io->ioRightCropTwips= arg;
	    break;

	case IOprop_UNSUPPORTED:
	    break;

	default:
	    SLDEB(rcw->rcwWord,rcw->rcwID);
	    break;
	}

    return 0;
    }

int docRtfPictureProperty(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    PictureProperties *	pip= &(rrc->rrcPictureProperties);

    switch( rcw->rcwID )
	{
	case PIPpropTYPE:
	    /* Exception to cover \wmetafile8 */
	    pip->pipType= rcw->rcwEnumValue;

	    if  ( pip->pipType == DOCokPICTWMETAFILE )
		{ pip->pipMapMode= arg;	}

	    break;

	case PIPpropPICX_WIN_EXT:
	    pip->pip_xWinExt= arg;
	    break;
	case PIPpropPICY_WIN_EXT:
	    pip->pip_yWinExt= arg;
	    break;

	case PIPpropPICTWIPS_WIDE:
	    pip->pipTwipsWide= arg;
	    break;
	case PIPpropPICTWIPS_HIGH:
	    pip->pipTwipsHigh= arg;
	    break;

	case PIPpropPICSCALE_X:
	    pip->pipScaleXSet= arg;
	    pip->pipScaleXUsed= pip->pipScaleXSet;
	    break;
	case PIPpropPICSCALE_Y:
	    pip->pipScaleYSet= arg;
	    pip->pipScaleYUsed= pip->pipScaleYSet;
	    break;

	case PIPpropPICCROP_TOP:
	    pip->pipTopCropTwips= arg;
	    break;
	case PIPpropPICCROP_BOTTOM:
	    pip->pipBottomCropTwips= arg;
	    break;
	case PIPpropPICCROP_LEFT:
	    pip->pipLeftCropTwips= arg;
	    break;
	case PIPpropPICCROP_RIGHT:
	    pip->pipRightCropTwips= arg;
	    break;

	case PIPpropBLIPTAG:
	    pip->pipBliptag= arg;
	    break;

	case PIPpropPICBPP:
	    pip->pipMetafileBitmapBpp= arg;
	    break;
	case PIPpropBLIPUPI:
	    pip->pipBmUnitsPerInch= arg;
	    break;
	case PIPpropWBMBITSPIXEL:
	    pip->pipBmBitsPerPixel= arg;
	    break;
	case PIPpropWBMPLANES:
	    pip->pipBmPlanes= arg;
	    break;
	case PIPpropWBMWIDTHBYTES:
	    pip->pipBmBytesPerRow= arg;
	    break;

	case PIPpropDEFSHP:
	    pip->pipPictureIsWordArt= arg != 0;
	    break;
	case PIPpropPICBMP:
	    pip->pipMetafileIsBitmap= arg != 0;
	    break;
	case PIPpropPICSCALED:
	    pip->pipPictIsScaled= arg != 0;
	    break;

	default:
	    SLDEB(rcw->rcwWord,rcw->rcwID);
	    break;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Consume picture property tags.					*/
/*									*/
/*  In particular:							*/
/*	shplid:	The identification of the shape of the picture.		*/
/*	sp:	Various shape properties for the picture.		*/
/*  We make a drawing shape to receive the properties.			*/
/*									*/
/************************************************************************/

static RtfControlWord	docRtfPicpropGroups[]=
    {
	RTF_DEST_XX( "sp",	1,	docRtfShapeProperty ),

	{ (char *)0, 0, 0 }
    };

static int docRtfReadPicprop(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    int			rval;
    DrawingShape *	parent= rrc->rrcDrawingShape;
    DrawingShape *	ds;

    ds= docClaimDrawingShape( &(rrc->rrcBd->bdShapeList) );
    if  ( ! ds )
	{ XDEB(ds); return -1;	}

    ds->dsShapeType= rcw->rcwID;

    rrc->rrcDrawingShape= ds;

    rval= docRtfConsumeGroup( (const RtfControlWord *)0, 0, -1,
				rrc, docRtfPicpropGroups, docRtfIgnoreText );
    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    /* ?? */
    docDeleteDrawingShape( rrc->rrcBd, ds );

    rrc->rrcDrawingShape= parent;
    return rval;
    }

static RtfControlWord	docRtfPictGroups[]=
    {
	RTF_DEST_XX( "picprop",	SHPtyPICPROP,	docRtfReadPicprop ),

	{ (char *)0, 0, 0 }
    };

static int docRtfSaveObjectData(	RtfReadingContext *	rrc,
					const char *		text,
					int			len )
    {
    InsertedObject *	io;

    io= docGetObject( rrc->rrcBd, rrc->rrcInsertedObjectNr );
    if  ( ! io )
	{ LXDEB(rrc->rrcInsertedObjectNr,io); return -1;	}

    if  ( docObjectSetData( io, text, len ) )
	{ LDEB(len); return -1;	}

    return 0;
    }

static int docRtfSaveResultData(	RtfReadingContext *	rrc,
					const char *		text,
					int			len )
    {
    InsertedObject *	io;

    io= docGetObject( rrc->rrcBd, rrc->rrcInsertedObjectNr );
    if  ( ! io )
	{ LXDEB(rrc->rrcInsertedObjectNr,io); return -1;	}

    if  ( docSetResultData( io, text, len ) )
	{ LDEB(len); return -1;	}

    return 0;
    }

int docRtfReadPict(	const RtfControlWord *	rcw,
			int			arg,
			RtfReadingContext *	rrc )
    {
    int		rval;

    if  ( ! docRtfGetParaItem( rrc ) )
	{ SDEB(rcw->rcwWord); return -1; }

    rval= docRtfConsumePict( rrc );

    return rval;
    }

int docRtfConsumePict(	RtfReadingContext *	rrc )
    {
    RtfReadingState *		externRrs= rrc->rrcState;
    RtfReadingState		internRrs;

    int				rval;
    TextParticule *		tp;

    BufferItem *		paraBi;
    int				ioNrSave= rrc->rrcInsertedObjectNr;

    RtfAddTextParticule		addParticule;

    paraBi= docRtfGetParaItem( rrc );
    if  ( ! paraBi )
	{ XDEB(paraBi); return -1; }

    docInitPictureProperties( &(rrc->rrcPictureProperties) );

    if  ( rrc->rrcInIgnoredGroup )
	{ addParticule= docRtfIgnoreText;	}
    else{
	addParticule= docRtfSaveObjectData;

	if  ( externRrs->rrsTextShadingChanged )
	    { docRtfRefreshTextShading( rrc, externRrs );	}

	tp= docAppendObject( rrc->rrcBd, paraBi,
					    &(externRrs->rrsTextAttribute) );
	if  ( ! tp )
	    { LDEB(paraBi->biParaParticuleCount); return -1;	}

	rrc->rrcInsertedObjectNr= tp->tpObjectNumber;
	}

    docRtfPushReadingState( rrc, &internRrs );

    rval= docRtfConsumeGroup( (const RtfControlWord *)0, 0, -1,
					rrc, docRtfPictGroups, addParticule );

    if  ( rval )
	{ LDEB(rval);	}
    if  ( rrc->rrcInsertedObjectNr >= 0 )
	{
	InsertedObject *	io;
	PictureProperties *	pip;

	io= docGetObject( rrc->rrcBd, rrc->rrcInsertedObjectNr );
	if  ( ! io )
	    { LXDEB(rrc->rrcInsertedObjectNr,io); return -1;	}
	pip= &(rrc->rrcPictureProperties);

	io->ioKind= pip->pipType;
	io->ioPictureProperties= rrc->rrcPictureProperties;

	io->ioTwipsWide= pip->pipTwipsWide;
	io->ioTwipsHigh= pip->pipTwipsHigh;
	io->ioScaleXSet= pip->pipScaleXSet;
	io->ioScaleYSet= pip->pipScaleYSet;
	io->ioScaleXUsed= pip->pipScaleXUsed;
	io->ioScaleYUsed= pip->pipScaleYUsed;
	}

    rrc->rrcInsertedObjectNr= ioNrSave;
    docRtfPopReadingState( rrc );

    return rval;
    }

int docRtfReadShpXPict(		const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    int			rval;
    int			ignore= 0;

    if  ( ! docRtfGetParaItem( rrc ) )
	{ SDEB(rcw->rcwWord); return -1; }

    switch( rcw->rcwID )
	{
	case PICshpSHPPICT:
	    ignore= 0;
	    break;
	case PICshpNONSHPPICT:
	    ignore= 1;
	    break;
	default:
	    SLDEB(rcw->rcwWord,rcw->rcwID);
	    break;
	}

    rrc->rrcInIgnoredGroup += ignore;

    rval= docRtfConsumeGroup( (const RtfControlWord *)0, 0, -1,
			rrc, (const RtfControlWord *)0, docRtfIgnoreText );
    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    rrc->rrcInIgnoredGroup -= ignore;

    return rval;
    }

static int docRtfReadResultPict(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    int				rval;

    RtfAddTextParticule		addParticule;

    if  ( ! docRtfGetParaItem( rrc ) )
	{ SDEB(rcw->rcwWord); return -1; }

    if  ( rrc->rrcInIgnoredGroup )
	{ addParticule= docRtfIgnoreText;	}
    else{ addParticule= docRtfSaveResultData;	}

    rval= docRtfConsumeGroup( (const RtfControlWord *)0, 0, -1,
					rrc, docRtfPictGroups, addParticule );

    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    if  ( rrc->rrcInsertedObjectNr >= 0 )
	{
	InsertedObject *	io;
	PictureProperties *	pip;

	io= docGetObject( rrc->rrcBd, rrc->rrcInsertedObjectNr );
	if  ( ! io )
	    { LXDEB(rrc->rrcInsertedObjectNr,io); return -1;	}
	pip= &(rrc->rrcPictureProperties);

	io->ioResultKind= pip->pipType;
	io->ioPictureProperties= rrc->rrcPictureProperties;

	if  ( io->ioTwipsWide < 2 )
	    { io->ioTwipsWide= pip->pipTwipsWide;	}
	if  ( io->ioTwipsHigh < 2 )
	    { io->ioTwipsHigh= pip->pipTwipsHigh;	}
	if  ( io->ioScaleXSet == 100 )
	    {
	    io->ioScaleXSet= pip->pipScaleXSet;
	    io->ioScaleXUsed= pip->pipScaleXUsed;
	    }
	if  ( io->ioScaleYSet == 100 )
	    {
	    io->ioScaleYSet= pip->pipScaleYSet;
	    io->ioScaleYUsed= pip->pipScaleYUsed;
	    }
	}

    return rval;
    }

static RtfControlWord	docRtfReadResultXPpictGroups[]=
    {
	RTF_DEST_XX( "pict",	PICshpPICT,	docRtfReadResultPict ),

	{ (char *)0, 0, 0 }
    };

static int docRtfReadResultXPpict(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    int				rval;
    int				ignore= 0;

    if  ( ! docRtfGetParaItem( rrc ) )
	{ SDEB(rcw->rcwWord); return -1; }

    switch( rcw->rcwID )
	{
	case PICshpSHPPICT:
	    ignore= 0;
	    break;
	case PICshpNONSHPPICT:
	    ignore= 1;
	    break;
	default:
	    SLDEB(rcw->rcwWord,rcw->rcwID);
	    break;
	}

    rrc->rrcInIgnoredGroup += ignore;

    rval= docRtfConsumeGroup( (const RtfControlWord *)0, 0, -1,
			rrc, docRtfReadResultXPpictGroups, docRtfIgnoreText );

    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    rrc->rrcInIgnoredGroup -= ignore;

    return rval;
    }

static int docRtfSaveObjectClass(	RtfReadingContext *	rrc,
					const char *		text,
					int			len )
    {
    InsertedObject *	io;

    io= docGetObject( rrc->rrcBd, rrc->rrcInsertedObjectNr );
    if  ( ! io )
	{ LXDEB(rrc->rrcInsertedObjectNr,io); return -1;	}

    if  ( docSetObjectClass( io, text, len ) )
	{ LDEB(len); return -1;	}

    return 0;
    }

static int docRtfSaveObjectName(	RtfReadingContext *	rrc,
					const char *		text,
					int			len )
    {
    InsertedObject *	io;

    io= docGetObject( rrc->rrcBd, rrc->rrcInsertedObjectNr );
    if  ( ! io )
	{ LXDEB(rrc->rrcInsertedObjectNr,io); return -1;	}

    if  ( docSetObjectName( io, text, len ) )
	{ LDEB(len); return -1;	}

    return 0;
    }

static int docRtfObjectClass(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    int				rval;

    rval= docRtfConsumeGroup( (const RtfControlWord *)0, 0, -1,
			rrc, (RtfControlWord *)0, docRtfSaveObjectClass );

    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }

static int docRtfObjectName(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    int				rval;

    rval= docRtfConsumeGroup( (const RtfControlWord *)0, 0, -1,
			rrc, (RtfControlWord *)0, docRtfSaveObjectName );
    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }

static int docRtfObjectData(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    int				rval;

    rval= docRtfConsumeGroup( (const RtfControlWord *)0, 0, -1,
			rrc, (RtfControlWord *)0, docRtfSaveObjectData );
    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }

static RtfControlWord	docRtfResultGroups[]=
{
    RTF_DEST_XX( "pict",	PICshpPICT,	docRtfReadResultPict ),
    RTF_DEST_XX( "shppict",	PICshpSHPPICT,	docRtfReadResultXPpict ),
    RTF_DEST_XX( "nonshppict",	PICshpNONSHPPICT, docRtfReadResultXPpict ),

    { (char *)0, 0, 0 }
};

static int docRtfObjectResult(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    int				rval;

    rval= docRtfConsumeGroup( (const RtfControlWord *)0, 0, -1,
				rrc, docRtfResultGroups, docRtfIgnoreText );
    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }

static RtfControlWord	docRtfObjectGroups[]=
    {
	RTF_DEST_XX( "objname",	RTFidOBJNAME,	docRtfObjectName ),
	RTF_DEST_XX( "objclass",RTFidOBJCLASS,	docRtfObjectClass ),
	RTF_DEST_XX( "objdata",	RTFidOBJDATA,	docRtfObjectData ),
	RTF_DEST_XX( "result",	RTFidOBJDATA,	docRtfObjectResult ),

	{ (char *)0, 0, 0 }
    };

int docRtfReadObject(	const RtfControlWord *	rcw,
			int			arg,
			RtfReadingContext *	rrc )
    {
    RtfReadingState *		rrs= rrc->rrcState;
    int				rval;

    int				ioNrSave= rrc->rrcInsertedObjectNr;

    const TextParticule *	tp;
    InsertedObject *		io;

    if  ( ! docRtfGetParaItem( rrc ) )
	{ SDEB(rcw->rcwWord); return -1; }

    docInitPictureProperties( &(rrc->rrcPictureProperties) );

    if  ( rrs->rrsTextShadingChanged )
	{ docRtfRefreshTextShading( rrc, rrs );	}

    tp= docAppendObject( rrc->rrcBd, rrc->rrcBi, &(rrs->rrsTextAttribute) );
    if  ( ! tp )
	{ SPDEB(rcw->rcwWord,tp); return -1;	}

    rrc->rrcInsertedObjectNr= tp->tpObjectNumber;
    io= docGetObject( rrc->rrcBd, rrc->rrcInsertedObjectNr );
    if  ( ! io )
	{ LXDEB(rrc->rrcInsertedObjectNr,io); return -1;	}
    io->ioKind= DOCokOLEOBJECT;

    rval= docRtfConsumeGroup( (const RtfControlWord *)0, 0, -1,
			rrc, docRtfObjectGroups, docRtfSaveObjectData );

    rrc->rrcInsertedObjectNr= ioNrSave;

    if  ( rval )
	{ SLDEB(rcw->rcwWord,rval);	}

    return rval;
    }
