/************************************************************************/
/*									*/
/*  Read/Write paragraph properties to/from RTF.			*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docRtf.h"

/************************************************************************/

static const char * DOC_rtfParaShadingTags[]=
    {
    (const char *)0,	/*  solid	*/
    "\\bghoriz",
    "\\bgvert",
    "\\bgfdiag",
    "\\bgbdiag",
    "\\bgcross",
    "\\bgdcross",
    "\\bgdkhoriz",
    "\\bgdkvert",
    "\\bgdkfdiag",
    "\\bgdkbdiag",
    "\\bgdkcross",
    "\\bgdkdcross",
    };

/************************************************************************/

void docRtfSaveParaTableNesting(	RtfWritingContext *		rwc,
					int				nest )
    {
    switch( nest )
	{
	case 0:
	    docRtfWriteArgTag( rwc, "\\itap", nest );
	    break;
	case 1:
	default:
	    docRtfWriteArgTag( rwc, "\\intbl\\itap", nest );
	    break;
	}

    rwc->rwcTableNestingWritten= nest;

    return;
    }

/************************************************************************/
/*									*/
/*  Save Paragraph Properties.						*/
/*									*/
/************************************************************************/

void docRtfSaveParagraphProperties(
				RtfWritingContext *		rwc,
				const PropertyMask *		updMask,
				const ParagraphProperties *	pp )
    {
    const int			anyway= 1;

    if  ( PROPmaskISSET( updMask, PPpropSTYLE ) )
	{ docRtfWriteArgTag( rwc, "\\s", pp->ppStyle ); }

    if  ( PROPmaskISSET( updMask, PPpropLISTOVERRIDE ) )
	{ docRtfWriteArgTag( rwc, "\\ls", pp->ppListOverride ); }
    if  ( PROPmaskISSET( updMask, PPpropLISTLEVEL ) )
	{ docRtfWriteArgTag( rwc, "\\ilvl", pp->ppListLevel ); }

    if  ( PROPmaskISSET( updMask, PPpropHYPHPAR ) )
	{
	if  ( pp->ppHyphenateParagraph )
	    { docRtfWriteTag( rwc, "\\hyphpar" );		 }
	else{
	    docRtfWriteArgTag( rwc, "\\hyphpar", pp->ppHyphenateParagraph );
	    }
	}

    if  ( PROPmaskISSET( updMask, PPpropBREAKKIND ) )
	{
	if  ( pp->ppBreakKind == DOCibkPAGE )
	    { docRtfWriteTag( rwc, "\\pagebb" );		}
	else{ docRtfWriteArgTag( rwc, "\\pagebb", 0 );	}
	}

    if  ( PROPmaskISSET( updMask, PPpropWIDCTLPAR ) )
	{
	if  ( pp->ppWidowControl )
	    { docRtfWriteTag( rwc, "\\widctlpar" );	}
	else{ docRtfWriteTag( rwc, "\\nowidctlpar" );	}
	}

    if  ( PROPmaskISSET( updMask, PPpropKEEP ) )
	{
	if  ( pp->ppKeepOnPage )
	    { docRtfWriteTag( rwc, "\\keep" );		 }
	else{
	    docRtfWriteArgTag( rwc, "\\keep", pp->ppKeepOnPage );
	    }
	}

    if  ( PROPmaskISSET( updMask, PPpropKEEPN ) )
	{
	if  ( pp->ppKeepWithNext )
	    { docRtfWriteTag( rwc, "\\keepn" );		 }
	else{
	    docRtfWriteArgTag( rwc, "\\keepn", pp->ppKeepWithNext );
	    }
	}

    if  ( PROPmaskISSET( updMask, PPpropOUTLINELEVEL ) )
	{
	docRtfWriteArgTag( rwc, "\\outlinelevel", pp->ppOutlineLevel );
	}

    if  ( PROPmaskISSET( updMask, PPpropFIRST_INDENT ) )
	{ docRtfWriteArgTag( rwc, "\\fi", pp->ppFirstIndentTwips ); }

    if  ( PROPmaskISSET( updMask, PPpropLEFT_INDENT ) )
	{ docRtfWriteArgTag( rwc, "\\li", pp->ppLeftIndentTwips ); }

    if  ( PROPmaskISSET( updMask, PPpropRIGHT_INDENT ) )
	{ docRtfWriteArgTag( rwc, "\\ri", pp->ppRightIndentTwips ); }

    if  ( PROPmaskISSET( updMask, PPpropSPACE_BEFORE ) )
	{ docRtfWriteArgTag( rwc, "\\sb", pp->ppSpaceBeforeTwips ); }

    if  ( PROPmaskISSET( updMask, PPpropSPACE_AFTER ) )
	{ docRtfWriteArgTag( rwc, "\\sa", pp->ppSpaceAfterTwips ); }

    if  ( PROPmaskISSET( updMask, PPpropLINE_SPACING_DIST ) ||
	  PROPmaskISSET( updMask, PPpropLINE_SPACING_MULT ) )
	{
	docRtfWriteArgTag( rwc, "\\sl", pp->ppLineSpacingTwips );
	docRtfWriteArgTag( rwc, "\\slmult", pp->ppLineSpacingIsMultiple );
	}

    if  ( PROPmaskISSET( updMask, PPpropALIGNMENT ) )
	{
	switch( pp->ppAlignment )
	    {
	    case DOCiaLEFT:	docRtfWriteTag( rwc, "\\ql" ); break;
	    case DOCiaRIGHT:	docRtfWriteTag( rwc, "\\qr" ); break;
	    case DOCiaCENTERED:	docRtfWriteTag( rwc, "\\qc" ); break;
	    case DOCiaJUSTIFIED:docRtfWriteTag( rwc, "\\qj" ); break;
	    default:
		LDEB(pp->ppAlignment); break;
	    }
	}

    if  ( PROPmaskISSET( updMask, PPpropTAB_STOPS ) )
	{ docRtfSaveTabStopList( rwc, &(pp->ppTabStopList) ); }

    if  ( PROPmaskISSET( updMask, PPpropTOP_BORDER ) )
	{
	docRtfSaveBorderByNumber( rwc, "\\brdrt",
					pp->ppTopBorderNumber, anyway );
	}

    if  ( PROPmaskISSET( updMask, PPpropBOTTOM_BORDER ) )
	{
	docRtfSaveBorderByNumber( rwc, "\\brdrb",
					pp->ppBottomBorderNumber, anyway );
	}

    if  ( PROPmaskISSET( updMask, PPpropLEFT_BORDER ) )
	{
	docRtfSaveBorderByNumber( rwc, "\\brdrl",
					pp->ppLeftBorderNumber, anyway );
	}

    if  ( PROPmaskISSET( updMask, PPpropRIGHT_BORDER ) )
	{
	docRtfSaveBorderByNumber( rwc, "\\brdrr",
					pp->ppRightBorderNumber, anyway );
	}

    if  ( PROPmaskISSET( updMask, PPpropBETWEEN_BORDER ) )
	{
	docRtfSaveBorderByNumber( rwc, "\\brdrbtw",
					pp->ppBetweenBorderNumber, anyway );
	}

    if  ( PROPmaskISSET( updMask, PPpropBAR_BORDER ) )
	{
	docRtfSaveBorderByNumber( rwc, "\\brdrbar",
					pp->ppBarNumber, anyway );
	}

    if  ( PROPmaskISSET( updMask, PPpropFRAME ) )
	{
	FrameProperties		fp;

	docGetFramePropertiesByNumber( &fp,
				&(rwc->rwcBd->bdFramePropertyList),
				pp->ppFrameNumber );

	if  ( DOCisFRAME( &fp ) )
	    { docRtfSaveParaFrameProperties( rwc, &fp );	}
	}

    if  ( PROPmaskISSET( updMask, PPpropSHADING ) )
	{
	docRtfSaveShadingByNumber( rwc, pp->ppShadingNumber,
		DOC_rtfParaShadingTags, "\\cfpat", "\\cbpat", "\\shading" );
	}

    if  ( pp->ppBreakKind == DOCibkCOL )
	{ docRtfWriteTag( rwc, "\\column" );	}

    return;
    }

/************************************************************************/
/*									*/
/*  Handle a paragraph property when reading RTF.			*/
/*									*/
/************************************************************************/

int docRtfRememberParaShadingProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    RtfReadingState *		rrs= rrc->rrcState;

    if  ( docSetShadingProperty( &(rrs->rrsParagraphShading),
						    rcw->rcwID, arg ) < 0 )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    /*
    PROPmaskADD( &(rrs->rrsParaPropertyMask), PPpropSHADING );
    */

    return 0;
    }

int docRtfRememberParagraphProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    RtfReadingState *		rrs= rrc->rrcState;
    ParagraphProperties *	pp= &(rrs->rrsParagraphProperties);

    switch( rcw->rcwID )
	{
	case PPprop_NONE:
	    docRtfResetParagraphProperties( rrs );
	    return 0;

	case PPpropSTYLE:
	    rrc->rrcDocumentStyle.dsLevel= DOClevPARA;
	    break;

	case PPpropLISTOVERRIDE:
	    rrc->rrcListOverride.loIndex= arg;
	    break;

	case PPprop_IN_TABLE:  /* intbl */
	    if  ( rrc->rrcBd && pp->ppTableNesting > 0 )
		{ rrc->rrcBd->bdProperties.dpContainsTables= 1;	}
	    break;
	case PPpropTABLE_NESTING:  /* itap */
	    if  ( rrc->rrcBd && pp->ppTableNesting > 0 )
		{ rrc->rrcBd->bdProperties.dpContainsTables= 1;	}
	    break;

	case PPpropTOP_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;

	case PPpropBOTTOM_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;

	case PPpropLEFT_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;

	case PPpropRIGHT_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;

	case PPprop_BOX_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;

	case PPpropBETWEEN_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;

	case PPpropBAR_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;
	}

    if  ( docSetParaProperty( pp, rcw->rcwID, arg ) < 0 )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    PROPmaskADD( &(rrc->rrcDocumentStyle.dsParaMask), rcw->rcwID );

    return 0;
    }

int docRtfSetParaProperties(	ParagraphProperties *	pp,
				BufferDocument *	bd,
				int			mindTable,
				RtfReadingState *	rrs )
    {
    PropertyMask		ppDoneMask;
    PropertyMask		ppUpdMask;

    rrs->rrsParagraphProperties.ppShadingNumber= docItemShadingNumber(
				&(bd->bdItemShadingList),
				&(rrs->rrsParagraphShading) );

    rrs->rrsParagraphProperties.ppFrameNumber= docFramePropertiesNumber(
			    &(bd->bdFramePropertyList),
			    &(rrs->rrsParaFrameProperties) );

    utilPropMaskClear( &ppDoneMask );

    utilPropMaskClear( &ppUpdMask );
    utilPropMaskFill( &ppUpdMask, PPprop_FULL_COUNT );
    if  ( ! mindTable )
	{ PROPmaskUNSET( &ppUpdMask, PPpropTABLE_NESTING );	}

    /*  3  */
    if  ( docUpdParaProperties( &ppDoneMask, pp,
			&ppUpdMask, &(rrs->rrsParagraphProperties),
			(const DocumentAttributeMap *)0 ) )
	{ LDEB(1); return -1;	}

    if  ( rrs->rrsParagraphBreakOverride >= 0 )
	{ pp->ppBreakKind= rrs->rrsParagraphBreakOverride;	}

    return 0;
    }

void docRtfResetParagraphProperties(	RtfReadingState *	rrs )
    {
    docCleanParagraphProperties( &(rrs->rrsParagraphProperties) );
    docInitParagraphProperties( &(rrs->rrsParagraphProperties) );
    rrs->rrsParagraphBreakOverride= -1;
    docInitItemShading( &(rrs->rrsParagraphShading) );
    docInitFrameProperties( &(rrs->rrsParaFrameProperties) );

    return;
    }

