/************************************************************************/
/*									*/
/*  Read/Write paragraph cell to/from RTF.				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docRtf.h"

/************************************************************************/

static const char * DOC_rtfCellShadingTags[]=
    {
    (const char *)0,	/*  solid	*/
    "\\clbghoriz",
    "\\clbgvert",
    "\\clbgfdiag",
    "\\clbgbdiag",
    "\\clbgcross",
    "\\clbgdcross",
    "\\clbgdkhor",
    "\\clbgdkvert",
    "\\clbgdkfdiag",
    "\\clbgdkbdiag",
    "\\clbgdkcross",
    "\\clbgdkdcross",
    };

/************************************************************************/
/*									*/
/*  Save Cell Properties.						*/
/*									*/
/************************************************************************/

void docRtfSaveCellProperties(		RtfWritingContext *	rwc,
					const CellProperties *	cp,
					int			shiftLeft )
    {
    const int			anyway= 0;

    switch( cp->cpValign )
	{
	case DOCtvaTOP:
	    /*
	    docRtfWriteTag( rwc, "\\clvertalt" );
	    */
	    break;
	    
	case DOCtvaCENTERED:
	    docRtfWriteTag( rwc, "\\clvertalc" );
	    break;
	    
	case DOCtvaBOTTOM:
	    docRtfWriteTag( rwc, "\\clvertalb" );
	    break;
	    
	default:
	    LDEB(cp->cpValign);
	    break;
	}

    if  ( cp->cpLeftInMergedRow )
	{ docRtfWriteTag( rwc, "\\clmgf" );	}
    if  ( cp->cpMergedWithLeft )
	{ docRtfWriteTag( rwc, "\\clmrg" );	}
    if  ( cp->cpTopInMergedColumn )
	{ docRtfWriteTag( rwc, "\\clvmgf" );	}
    if  ( cp->cpMergedWithAbove )
	{ docRtfWriteTag( rwc, "\\clvmrg" );	}

    docRtfWriteNextLine( rwc );

    docRtfSaveBorderByNumber( rwc, "\\clbrdrt",
					cp->cpTopBorderNumber, anyway );
    docRtfSaveBorderByNumber( rwc, "\\clbrdrl",
					cp->cpLeftBorderNumber, anyway );
    docRtfSaveBorderByNumber( rwc, "\\clbrdrr",
					cp->cpRightBorderNumber, anyway );
    docRtfSaveBorderByNumber( rwc, "\\clbrdrb",
					cp->cpBottomBorderNumber, anyway );

    /*  NOTE: Word 2003 swaps left and top  */
    docRtfSaveAutoSpace(  rwc,
			    "\\clpadft", cp->cpLeftPaddingUnit,
			    "\\clpadt", cp->cpLeftPadding );  /* !!!  */
    docRtfSaveAutoSpace(  rwc,
			    "\\clpadfl", cp->cpTopPaddingUnit,
			    "\\clpadl", cp->cpTopPadding );  /* !!!  */
    docRtfSaveAutoSpace(  rwc,
			    "\\clpadfr", cp->cpRightPaddingUnit,
			    "\\clpadr", cp->cpRightPadding );
    docRtfSaveAutoSpace(  rwc,
			    "\\clpadfb", cp->cpBottomPaddingUnit,
			    "\\clpadb", cp->cpBottomPadding );

    docRtfSaveShadingByNumber( rwc, cp->cpShadingNumber,
		DOC_rtfCellShadingTags, "\\clcfpat", "\\clcbpat", "\\clshdng" );

    /**/
    docRtfSaveAutoSpace( rwc,
			"\\clftsWidth", cp->cpPreferredWidthUnit,
			"\\clwWidth", cp->cpPreferredWidth );

    /**/
    switch( cp->cpTextFlow )
	{
	case TXflowTXLRTB:
	    /*docRtfWriteTag( rwc, "\\cltxlrtb" );*/
	    break;
	case TXflowTXTBRL:
	    docRtfWriteTag( rwc, "\\cltxtbrl" );
	    break;
	case TXflowTXBTLR:
	    docRtfWriteTag( rwc, "\\cltxbtlr" );
	    break;
	case TXflowTXLRTBV:
	    docRtfWriteTag( rwc, "\\cltxlrtbv" );
	    break;
	case TXflowTXTBRLV:
	    docRtfWriteTag( rwc, "\\cltxtbrlv" );
	    break;
	    
	default:
	    LDEB(cp->cpTextFlow);
	    break;
	}

    /*  LAST! */
    docRtfWriteArgTag( rwc, "\\cellx", cp->cpRightBoundaryTwips- shiftLeft );

    docRtfWriteNextLine( rwc );
    }

/************************************************************************/
/*									*/
/*  Handle a cell property when reading RTF.				*/
/*									*/
/************************************************************************/

int docRtfRememberCellShadingProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    if  ( docSetShadingProperty( &(rrc->rrcCellShading), rcw->rcwID, arg ) < 0 )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    PROPmaskADD( &(rrc->rrcCellPropertyMask), CLpropSHADING );

    return 0;
    }

int docRtfRememberCellProperty(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    CellProperties *	cp= &(rrc->rrcCellProperties);

    switch( rcw->rcwID )
	{
	case CLprop_NONE:
	    docCleanCellProperties( cp );
	    docInitCellProperties( cp );
	    docInitItemShading( &(rrc->rrcCellShading) );
	    return 0;

	case CLpropCELLX:
	    if  ( arg < 0 )
		{
		DocumentGeometry *	dg;

		SLDEB(rcw->rcwWord,arg);

		dg= &(rrc->rrcSectionProperties.spDocumentGeometry);

		arg= dg->dgPageWideTwips-
			    ( dg->dgRightMarginTwips+ dg->dgLeftMarginTwips );
		}

	    cp->cpRightBoundaryTwips= arg;

	    {
	    cp->cpShadingNumber= docItemShadingNumber(
					    &(rrc->rrcBd->bdItemShadingList),
					    &(rrc->rrcCellShading) );
	    if  ( cp->cpShadingNumber < 0 )
		{ LDEB(cp->cpShadingNumber);	}

	    if  ( docInsertRowColumn( &(rrc->rrcRowProperties), -1, cp,
					(const DocumentAttributeMap *)0 ) )
		{ LDEB(rrc->rrcRowProperties.rpCellCount); return -1; }

	    PROPmaskADD( &(rrc->rrcRowPropertyMask), RPpropCOLUMNS );
	    }

	    docInitCellProperties( cp );
	    docInitItemShading( &(rrc->rrcCellShading) );

	    return 0;

	/**/
	case CLpropTOP_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;
	case CLpropBOTTOM_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;
	case CLpropLEFT_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;
	case CLpropRIGHT_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;

	case RTFid_NOT_SUPPORTED:
	    return 0;
	}

    PROPmaskADD( &(rrc->rrcCellPropertyMask), rcw->rcwID );

    if  ( docSetCellProperty( cp, rcw->rcwID, arg ) < 0 )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Cell instance properties: How table styles are applied.		*/
/*									*/
/************************************************************************/

int docRtfRememberCellInstanceProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    return 0;
    }
