/************************************************************************/
/*									*/
/*  Read/Write border properties to/from RTF.				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docRtf.h"

/************************************************************************/
/*									*/
/*  Save border definition.						*/
/*									*/
/************************************************************************/

void docRtfSaveBorder(		RtfWritingContext *		rwc,
				const char *			tag,
				const BorderProperties *	bp )
    {
    docRtfWriteTag( rwc, tag );

    switch( bp->bpStyle )
	{
	case DOCbsNONE:
	    docRtfWriteTag( rwc, "\\brdrnone" ); break;
	case DOCbsS:
	    docRtfWriteTag( rwc, "\\brdrs" ); break;
	case DOCbsTH:
	    docRtfWriteTag( rwc, "\\brdrth" ); break;
	case DOCbsSH:
	    docRtfWriteTag( rwc, "\\brdrsh" ); break;

	case DOCbsDB:
	    docRtfWriteTag( rwc, "\\brdrdb" ); break;
	case DOCbsHAIR:	
	    docRtfWriteTag( rwc, "\\brdrhair" ); break;
	case DOCbsDOT:
	    docRtfWriteTag( rwc, "\\brdrdot" ); break;
	case DOCbsDASH:
	    docRtfWriteTag( rwc, "\\brdrdash" ); break;
	case DOCbsDASHD:
	    docRtfWriteTag( rwc, "\\brdrdashd" ); break;
	case DOCbsDASHDD:
	    docRtfWriteTag( rwc, "\\brdrdashdd" ); break;
	case DOCbsTRIPLE:
	    docRtfWriteTag( rwc, "\\brdrtriple" ); break;

	case DOCbsTNTHSG:
	    docRtfWriteTag( rwc, "\\brdrtnthsg" ); break;
	case DOCbsTHTNSG:
	    docRtfWriteTag( rwc, "\\brdrthtnsg" ); break;
	case DOCbsTNTHTNSG:
	    docRtfWriteTag( rwc, "\\brdrtnthtnsg" ); break;
	case DOCbsTNTHMG:
	    docRtfWriteTag( rwc, "\\brdrtnthmg" ); break;
	case DOCbsTHTNMG:
	    docRtfWriteTag( rwc, "\\brdrthtnmg" ); break;
	case DOCbsTNTHTNMG:
	    docRtfWriteTag( rwc, "\\brdrtnthtnmg" ); break;
	case DOCbsTNTHLG:
	    docRtfWriteTag( rwc, "\\brdrtnthlg" ); break;
	case DOCbsTHTNLG:
	    docRtfWriteTag( rwc, "\\brdrthtnlg" ); break;
	case DOCbsTNTHTNLG:
	    docRtfWriteTag( rwc, "\\brdrtnthtnlg" ); break;

	case DOCbsWAVY:	
	    docRtfWriteTag( rwc, "\\brdrwavy" ); break;
	case DOCbsWAVYDB:
	    docRtfWriteTag( rwc, "\\brdrwavydb" ); break;
	case DOCbsDASHSM:
	    docRtfWriteTag( rwc, "\\brdrdashsm" ); break;
	case DOCbsDASHDOTSTR:
	    docRtfWriteTag( rwc, "\\brdrdashdotstr" ); break;
	case DOCbsEMBOSS:
	    docRtfWriteTag( rwc, "\\brdremboss" ); break;
	case DOCbsENGRAVE:
	    docRtfWriteTag( rwc, "\\brdrengrave" ); break;
	case DOCbsFRAME:
	    docRtfWriteTag( rwc, "\\brdrframe" ); break;
	case DOCbsOUTSET:
	    docRtfWriteTag( rwc, "\\brdroutset" ); break;

	case DOCbsTBL:
	    docRtfWriteTag( rwc, "\\brdrtbl" ); break;
	case DOCbsNIL:
	    docRtfWriteTag( rwc, "\\brdrnil" ); break;

	default:
	    LDEB(bp->bpStyle);
	    break;
	}

    if  ( bp->bpArt != 0 )
	{ docRtfWriteArgTag( rwc, "\\brdrart", bp->bpColor );	}

    if  ( bp->bpColor != 0 )
	{ docRtfWriteArgTag( rwc, "\\brdrcf", bp->bpColor );	}

    if  ( bp->bpPenWideTwips != 0 )
	{ docRtfWriteArgTag( rwc, "\\brdrw", bp->bpPenWideTwips ); }

    if  ( bp->bpSpacingTwips != 0 )
	{ docRtfWriteArgTag( rwc, "\\brsp", bp->bpSpacingTwips );	}

    docRtfWriteNextLine( rwc );

    return;
    }

void docRtfSaveBorderByNumber(		RtfWritingContext *		rwc,
					const char *			tag,
					int				num,
					int				anyway )
    {
    const BufferDocument *	bd= rwc->rwcBd;
    const NumberedPropertiesList *	bpl= &(bd->bdBorderPropertyList);

    BorderProperties		bp;

    docGetBorderPropertiesByNumber( &bp, bpl, num );

    if  ( ! anyway && bp.bpStyle == DOCbsNONE )
	{ return;	}

    docRtfSaveBorder( rwc, tag, &bp );
    }

int docRtfBeginBorder(		const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    docInitBorderProperties( &(rrc->rrcBorderProperties) );
    rrc->rrcBorderProperties.bpStyle= DOCbsS;
    return 0;
    }

int docRtfReadGetBorderNumber(	RtfReadingContext *	rrc )
    {
    int rval= docBorderPropertiesNumber(
				    &(rrc->rrcBd->bdBorderPropertyList),
				    &(rrc->rrcBorderProperties) );

    docInitBorderProperties( &(rrc->rrcBorderProperties) );

    return rval;
    }

int docRtfBrdrProperty(		const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    if  ( docSetBorderProperty( &(rrc->rrcBorderProperties),
						    rcw->rcwID, arg ) < 0 )
	{ SLLDEB(rcw->rcwWord,rcw->rcwID,arg); return -1; }

    return 0;
    }

