/************************************************************************/
/*									*/
/*  Read/Write RTF files.						*/
/*									*/
/************************************************************************/

#   ifndef	DOC_RTF_H
#   define	DOC_RTF_H

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>
#   include	<time.h>

#   include	<appDebugon.h>

#   include	<sioGeneral.h>
#   include	<utilTextConverter.h>
#   include	<utilPagedList.h>

#   include	"docBuf.h"
#   include	<utilMatchFont.h>

#   include	"docRtfTagHash.h"
#   include	"docRtfTagEnum.h"
#   include	"docRtfControlWord.h"

/************************************************************************/
/*									*/
/*  Context for Reading RTF.						*/
/*									*/
/************************************************************************/

struct RtfFieldStackLevel;

typedef struct RtfReadingState
    {
    int				rrsBytesPerUnicode;
    int				rrsUnicodeBytesToSkip;

    TextAttribute		rrsTextAttribute;
				    /************************************/
				    /*  Font number is in buffer terms.	*/
				    /*  NOT in file terms.		*/
				    /************************************/
    int				rrsTextCharset;
    ItemShading			rrsTextShading;
    int				rrsTextShadingChanged;
    ParagraphProperties		rrsParagraphProperties;
    int				rrsParagraphBreakOverride;
    ItemShading			rrsParagraphShading;
    FrameProperties		rrsParaFrameProperties;

    MemoryBuffer		rrsSavedText;

    struct RtfReadingState *	rrsPrev;
    } RtfReadingState;

struct RtfReadingContext;

typedef int (*RtfAddTextParticule)(	struct RtfReadingContext *	rrc,
					const char *			text,
					int				len );

typedef struct RtfTextConverter
    {
				/*
				 * Used for RTF conversions. I.E where 
				 * no font applies
				 */
    TextConverter		rtcRtfConverter;
				/*
				 * Used for Text conversions. I.E where 
				 * a font applies
				 */
    TextConverter		rtcTextConverter;
    } RtfTextConverter;

typedef struct EncodedFont
    {
    int		ecFileFontNumber;
    int		ecBufFontNumber;
    int		ecCharset;
    int		ecCharsetIdx;
    int		ecCodepage;
    } EncodedFont;

typedef struct RtfReadingContext
    {
    RtfReadingState *		rrcState;
    RtfAddTextParticule		rrcAddParticule;
    SimpleInputStream *		rrcSis;

    int				rrcLevel;
    int				rrcInIgnoredGroup;
				/****************************************/
				/*  The depth in the document		*/
				/*  == Type of BufferItem.		*/
				/****************************************/
    int				rrcComplainUnknown;
				/****************************************/
				/*  Complain about unknown control	*/
				/****************************************/
    int				rrcCharacterAhead;
    int				rrcAfterNoteref;
				/****************************************/
				/*  Character that could not be unread	*/
				/*  using ungetc().			*/
				/****************************************/
    int				rrcCurrentLine;
    BufferDocument *		rrcBd;
    DocumentTree *		rrcEi;
    BufferItem *		rrcBi;
				/****************************************/
				/*  The current position in the input.	*/
				/****************************************/
				/****************************************/
				/*  Text attributes of the current pos.	*/
				/****************************************/
    FrameProperties		rrcRowFrameProperties;

    CellProperties		rrcCellProperties;
    PropertyMask		rrcCellPropertyMask;
    ItemShading			rrcCellShading;

    SectionProperties		rrcSectionProperties;
    PropertyMask		rrcSectionPropertyMask;
    int				rrcSectionColumn;

    RowProperties		rrcRowProperties;
    PropertyMask		rrcRowPropertyMask;
    ItemShading			rrcRowShading;

    BorderProperties		rrcBorderProperties;
    DrawingShape *		rrcDrawingShape;
    int				rrcNextObjectVertex;
    DocumentStyle		rrcDocumentStyle;
    TabStop			rrcTabStop;
    RGB8Color			rrcColor;
    int				rrcGotComponent;
    struct tm			rrcTm;
    unsigned char *		rrcInfoText;
    SelectionScope		rrcSelectionScope;

    ParagraphNumber		rrcParagraphNumber;
    ItemShading			rrcParagraphNumberTextShading;
    ParagraphNumber *		rrcParagraphNumbers;
    int				rrcParagraphNumberCount;

    DocumentList		rrcDocumentList;
    DocumentListLevel		rrcDocumentListLevel;
    MemoryBuffer		rrcListLevelText;
    MemoryBuffer		rrcListLevelNumbers;

    ListOverride		rrcListOverride;
    ListOverrideLevel		rrcListOverrideLevel;

				/****************************************/
				/*  Document properties.		*/
				/****************************************/
    DocumentFont		rrcCurrentFont;
    EncodedFont			rrcCurrentEncodedFont;
    PagedList			rrcEncodedFontList;

    int				rrcDefaultFont;
    int				rrcDefaultFontDbch;
    int				rrcDefaultFontLoch;
    int				rrcDefaultFontHich;
    int				rrcDefaultFontBi;

				/****************************************/
				/*  For reading the font table.		*/
				/*  Style sheet.			*/
				/****************************************/
    int				rrcInsertedObjectNr;
    PictureProperties		rrcPictureProperties;
    MemoryBuffer		rrcBookmark;
    struct RtfFieldStackLevel *	rrcFieldStack;
    int				rrcLastFieldNumber;
				/****************************************/
				/*  For reading 'objects' and pictures.	*/
				/*  For reading 'fields'.		*/
				/****************************************/
    int				rrcAtParaHead;
    int				rrcGotDocGeometry;
				/****************************************/
				/*  For coping with the way word saves	*/
				/*  {\pntext ... }			*/
				/****************************************/

    const PostScriptFontList *	rrcPostScriptFontList;
    RtfTextConverter		rrcTextConverters;
    } RtfReadingContext;

# define docRtfReadSetRtfEncodingName( r, n ) \
	utilTextConverterSetNativeEncodingName( &((r)->rrcTextConverters.rtcRtfConverter), (n) )
# define docRtfReadSetTextEncodingName( r, n ) \
	utilTextConverterSetNativeEncodingName( &((r)->rrcTextConverters.rtcTextConverter), (n) )

# define docRtfReadGetRtfEncodingName( r ) \
				((r)->rrcTextConverters.rtcRtfConverter.tcNativeEncodingName+0)

/************************************************************************/
/*									*/
/*  What you can find in an RTF file.					*/
/*									*/
/************************************************************************/

#   define	RTFfiCTRLGROUP	1
#   define	RTFfiWORD	2
#   define	RTFfiCHAR	3
#   define	RTFfiTAB	4
#   define	RTFfiCLOSE	5
#   define	RTFfiSTARGROUP	6
#   define	RTFfiTEXTGROUP	7

/************************************************************************/
/*									*/
/*  Writing context.							*/
/*									*/
/************************************************************************/

typedef struct PushedAttribute
    {
    struct PushedAttribute *	paNext;
    TextAttribute		paTextAttribute;
    int				paTextCharset;
    } PushedAttribute;

typedef struct RtfWritingContext
    {
    BufferDocument *		rwcBd;
    TextAttribute		rwcTextAttribute;
    int				rwcTextCharset;
    ParagraphProperties		rwcParagraphProperties;
    RowProperties		rwcRowProperties;

    ParagraphProperties		rwcOutsideTableParagraphProperties;

    PagedList			rwcEncodedFontList;

    PushedAttribute *		rwcPushedAttribute;
    int				rwcInFldrslt;
    int				rwcTableNesting;
    int				rwcTableNestingWritten;

    int				rwcAfter;
#				define RTFafterTAG	'T'
#				define RTFafterARG	'0'
#				define RTFafterTEXT	'*'

    int				rwcSaveFlags;

    int				rwcCol;
    SimpleOutputStream *	rwcSosOut;
    RtfTextConverter		rwcTextConverters;
    } RtfWritingContext;

# define docRtfWriteSetRtfEncodingName( r, n ) \
	utilTextConverterSetNativeEncodingName( &((r)->rwcTextConverters.rtcRtfConverter), (n) )
# define docRtfWriteSetTextEncodingName( r, n ) \
	utilTextConverterSetNativeEncodingName( &((r)->rwcTextConverters.rtcTextConverter), (n) )

# define docRtfWriteGetRtfEncodingName( r ) \
				((r)->rwcTextConverters.rtcRtfConverter.tcNativeEncodingName+0)

/************************************************************************/
/*									*/
/*  Shortcuts in the definition of property tables.			*/
/*									*/
/************************************************************************/

#   define RTF_TEXT_GROUP( s, id, co ) \
		RTF_DEST_CO( s, id, docRtfApplyDocEncodedTextGroup, co )

#   define RTF_BYTE_GROUP( s, id, co ) \
		RTF_DEST_CO( s, id, docRtfApplyRawBytesGroup, co )

/************************************************************************/

typedef enum RtfLookupId
    {
    RTFlookupXEF,
    RTFlookupBXE,
    RTFlookupIXE,

    RTFlookupTC,
    RTFlookupTCN,
    RTFlookupTCF,
    RTFlookupTCL,

    RTFlookup_COUNT
    } RtfLookupId;

/************************************************************************/
/*									*/
/*  Common data.							*/
/*									*/
/************************************************************************/

extern RtfControlWord	docRtfDocumentGroups[];

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docRtfInitReadingContext(	RtfReadingContext *		rrc );
extern void docRtfCleanReadingContext(	RtfReadingContext *		rrc );

extern const RtfControlWord * docRtfFindWord(
					const char *		controlWord,
					const RtfControlWord *	controlWords );

extern int docRtfApplyControlWord(	const RtfControlWord *	rcw,
					int			gotArg,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfReadGroup(	const RtfControlWord *	rcw,
				int			gotArg,
				int			arg,
				RtfReadingContext *	rrc,
				const RtfControlWord *	groupWords,
				RtfAddTextParticule	addParticule,
				RtfCommitGroup		commitGroup );

extern int docRtfReadGroupX(	const RtfControlWord *	rcw,
				const RtfControlWord *	applyFirst,
				int			gotArg,
				int			arg,
				RtfReadingContext *	rrc,
				const RtfControlWord *	groupWords,
				RtfAddTextParticule	addParticule,
				RtfCommitGroup		commitGroup );

extern int docRtfFindControl(	RtfReadingContext *	rrc,
				int *			pC,
				char *			controlWord,
				int *			pGotArg,
				int *			pArg );

extern int docRtfIgnoreWord(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfIgnoreText(	RtfReadingContext *	rrc,
				const char *		text,
				int			len );

extern int docRtfRefuseText(	RtfReadingContext *	rrc,
				const char *		text,
				int			len );

extern int docRtfSaveDocEncodedText(
				RtfReadingContext *	rrc,
				const char *		text,
				int			len );

extern int docRtfSaveFontEncodedText(
				RtfReadingContext *	rrc,
				const char *		text,
				int			len );

extern int docRtfSaveRawBytes(	RtfReadingContext *	rrc,
				const char *		text,
				int			len );

extern int docRtfStoreSavedText(char **			pTarget,
				int *			pSize,
				RtfReadingContext *	rrc,
				int			removeSemicolon );

extern int docRtfSkipGroup(	const RtfControlWord *	groupRcw,
				int			textLevel,
				RtfReadingContext *	rrc );

extern int docRtfConsumeGroup(	const RtfControlWord *	applyFirst,
				int			gotArg,
				int			arg,
				RtfReadingContext *	rrc,
				const RtfControlWord *	groupWords,
				RtfAddTextParticule	addParticule );

extern int docRtfConsumePict(	RtfReadingContext *	rrc );

extern int docRtfReadPict(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadShpXPict(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadObject(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadDrawingObject(
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadShape(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfTextParticule(	RtfReadingContext *	rrc,
				const char *		text,
				int			len );

extern int docRtfReadField(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadTextField(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfLookupEntry(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadExtIt(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadFootnote(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfBkmkStart(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfBkmkEnd(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern DocumentField * docRtfSpecialField(
				int			fieldKind,
				const char *		fieldinst,
				int			fieldsize,
				const char *		fieldRslt,
				RtfReadingContext *	rrc );

extern int docRtfTextSpecialToField(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRememberProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfPopScopeFromFieldStack( RtfReadingContext *	rrc );
extern int docRtfPopParaFromFieldStack( RtfReadingContext *	rrc,
					int			paraNr );

extern int docRtfFontTable(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfColorTable(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRevisionTable(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfStylesheet(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfListTable(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfReadInfo(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRememberDocProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern void docRtfWriteArgTag(		RtfWritingContext *	rwc,
					const char *		tag,
					int			arg );

extern void docRtfWriteTag(		RtfWritingContext *	rwc,
					const char *		tag );

extern void docRtfWriteDocEncodedString(RtfWritingContext *	rwc,
					const char *		s,
					int			n );

extern void docRtfWriteFontEncodedString( RtfWritingContext *	rwc,
					const char *		s,
					int			n );

extern void docRtfWriteRawBytes(	RtfWritingContext *	rwc,
					const char *		s,
					int			n );

extern void docRtfWriteDocEncodedStringDestination(
					RtfWritingContext *	rwc,
					const char *		tag,
					const char *		s,
					int			n,
					int			addSemicolon );

extern void docRtfWriteRawBytesDestination(
					RtfWritingContext *	rwc,
					const char *		tag,
					const char *		s,
					int			n );

extern void docRtfWriteNextLine(	RtfWritingContext *	rwc );

extern void docRtfSaveBorder(		RtfWritingContext *		rwc,
					const char *			tag,
					const BorderProperties *	bp );

extern void docRtfSaveBorderByNumber(	RtfWritingContext *		rwc,
					const char *			tag,
					int				num,
					int				anywy );

extern void docRtfSaveTextAttribute(	RtfWritingContext *	rwc,
					const PropertyMask *	updMask,
					const TextAttribute *	ta );

extern void docRtfSaveParagraphProperties(
				RtfWritingContext *		rwc,
				const PropertyMask *		updMask,
				const ParagraphProperties *	pp );

extern void docRtfWriteDestinationBegin( RtfWritingContext *	rwc,
					const char *		tag );

extern void docRtfWriteDestinationEnd(	RtfWritingContext *	rwc );

extern int docRtfSavePictureTags(	RtfWritingContext *		rwc,
					const PictureProperties *	pip );

extern int docRtfWriteMemoryBuffer(	RtfWritingContext *		rwc,
					const MemoryBuffer *		mb );

extern int docRtfReadUnknownGroup(	RtfReadingContext *	rrc );

extern void docRtfSaveSectionProperties( RtfWritingContext *	rwc,
				const PropertyMask *		updMask,
				const SectionProperties *	sp );

extern void docRtfWriteFontTable( RtfWritingContext *		rwc,
				const DocumentFontList *	dfl );

extern void docRtfWriteColorTable( RtfWritingContext *		rwc,
				const DocumentProperties *	dp );

extern void docRtfWriteRevisorTable( RtfWritingContext *	sos,
				const DocumentProperties *	dp );

extern void docRtfWriteStyleSheet(
				RtfWritingContext *		rwc,
				const DocumentStyleSheet *	dss );

extern int docRtfRememberParagraphProperty( 
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfBeginBorder(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfBrdrProperty(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfRememberSectionProperty( 
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRememberTextProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRememberPntextProperty( const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern void docRtfWriteArgDestinationBegin( RtfWritingContext *	rwc,
					const char *		tag,
					int			arg );

extern int docRtfSaveDocumentProperties( RtfWritingContext *		rwc,
					const DocumentProperties *	dp );

extern void docRtfSaveParaFrameProperties(
				RtfWritingContext *		rwc,
				const FrameProperties *		fp );
extern void docRtfSaveRowFrameProperties(
				RtfWritingContext *		rwc,
				const FrameProperties *		fp );

extern int docRtfRememberParaFrameProperty(
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRememberRowFrameProperty(
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfSaveSectHeadersFooters( RtfWritingContext *	rwc,
					const BufferItem *	bi );

extern int docRtfSaveExternalItem(	RtfWritingContext *	rwc,
					const char *		tag,
					BufferItem *		sectBi,
					int			evenIfAbsent,
					int			forcePar );

extern int docRtfSaveDocNotesSeparators( RtfWritingContext *	rwc,
					const BufferDocument *	bd );

extern void docRtfSaveCellProperties(	RtfWritingContext *	rwc,
					const CellProperties *	cp,
					int			shiftLeft );

extern int docRtfRememberCellProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRememberCellInstanceProperty(
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern void docRtfSaveRowProperties(	RtfWritingContext *	rwc,
					const RowProperties *	rp,
					int			col0,
					int			col1 );

extern int docRtfRememberRowProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern void docRtfSaveAutoSpace(	RtfWritingContext *	rwc,
					const char *		unitTag,
					int			unit,
					const char *		numberTag,
					int			number );

extern int docRtfRememberStyleProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRememberListLevelProperty(
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRememberListProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern void docRtfWriteListTable(
				RtfWritingContext *		rwc,
				const DocumentListTable *	dlt );

extern void docRtfPushReadingState(	RtfReadingContext *	rrc,
					RtfReadingState *	rrs );

extern void docRtfPopReadingState(	RtfReadingContext *	rrc );

extern int docRtfRememberListOverrideLevelProperty(
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRememberListOverrideProperty(
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfListOverrideTable(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern void docRtfWriteListOverrideTable(
				RtfWritingContext *		rwc,
				const ListOverrideTable *	lot );

extern void docRtfWriteListLevel(
				RtfWritingContext *		rwc,
				const DocumentListLevel *	dll );

extern int docRtfRememberTabStopProperty(
				const RtfControlWord *		rcw,
				int				arg,
				RtfReadingContext *		rrc );

extern void docRtfSaveTabStopList(
				RtfWritingContext *		rwc,
				const TabStopList *		tsl );

extern int docRtfFontProperty(	const RtfControlWord *		rcw,
				int				arg,
				RtfReadingContext *		rrc );

extern const RtfControlWord * docRtfFindPropertyWord(
					const char *		controlWord );

extern const RtfControlWord * docRtfFindShapePropertyWord(
					const char *		controlWord );

extern int docRtfObjectProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfPictureProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfTextSpecialChar(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfTextUnicode(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfTextSpecialParticule(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfDrawingObjectProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfDrawingObjectCoordinate(
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpProperty(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfPnProperty(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpArray(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpString(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpPicture(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpNumber(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpPositionNumber(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpTypeNumber(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpLockNumber(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpFillNumber(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpLineNumber(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpGroupedNumber(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpConnectNumber(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpTxboxNumber(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpShadowNumber(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpColor(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfHierarchy(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfReadExternalItem(	const RtfControlWord *	rcw,
					DocumentTree *		ei,
					int *			pExtItKind,
					RtfReadingContext *	rrc,
					int			ignoreEmpty,
					const SelectionScope *	ss );

extern int docRtfShapeProperty(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfReadRow(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfLookupWord(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfShpGeometryNumber(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfColorComp(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfColorIgnored(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfCommitTitleText(	const RtfControlWord *	rcw,
					RtfReadingContext *	rrc );
extern int docRtfCommitAuthorText(	const RtfControlWord *	rcw,
					RtfReadingContext *	rrc );
extern int docRtfCommitCompanyText(	const RtfControlWord *	rcw,
					RtfReadingContext *	rrc );
extern int docRtfCommitSubjectText(	const RtfControlWord *	rcw,
					RtfReadingContext *	rrc );
extern int docRtfCommitKeywordsText(	const RtfControlWord *	rcw,
					RtfReadingContext *	rrc );
extern int docRtfCommitDoccommText(	const RtfControlWord *	rcw,
					RtfReadingContext *	rrc );
extern int docRtfCommitHlinkbaseText(	const RtfControlWord *	rcw,
					RtfReadingContext *	rrc );

extern int docRtfDocTimeGroup(		const RtfControlWord *  rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern void docRtfRefreshTextShading(	RtfReadingContext *	rrc,
					RtfReadingState *	rrs );

extern void docRtfSaveShading(		RtfWritingContext *	rwc,
					const ItemShading *	is,
					const char ** const 	patTags,
					const char *		foreTag,
					const char *		backTag,
					const char *		levelTag );

extern void docRtfSaveShadingByNumber(	RtfWritingContext *	rwc,
					int			num,
					const char ** const	patTags,
					const char *		foreTag,
					const char *		backTag,
					const char *		levelTag );

extern void docRtfReserveColumns(	RtfWritingContext *	rwc,
					int			cols );

extern int docRtfSaveParaItem(		RtfWritingContext *		rwc,
					const BufferItem *		bi,
					const DocumentSelection *	ds );

extern int docRtfPopTable(		RtfWritingContext *		rwc );

extern int docRtfSetParaProperties(	ParagraphProperties *	pp,
					BufferDocument *	bd,
					int			mindTable,
					RtfReadingState *	rrs );

extern void docRtfResetParagraphProperties(
					RtfReadingState *	rrs );

extern void docRtfResetTextAttribute(	RtfReadingState *	rrs,
					BufferDocument *	bd );

extern int docRtfSkipPn(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfReadPnseclvl(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern int docRtfRememberFieldProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfApplyDocEncodedTextGroup(
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfApplyRawBytesGroup(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfCommitGeneratorText(	const RtfControlWord *	rcw,
					RtfReadingContext *	rrc );

extern void docRtfInitWritingContext(	RtfWritingContext *	rwc );
extern void docRtfCleanWritingContext(	RtfWritingContext *	rwc );

extern void docRtfWriteSemicolon(	RtfWritingContext *	rwc );

extern int docRtfReadTimeField(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc );

extern BufferItem *	docRtfGetParaItem(	RtfReadingContext *	rrc );
extern BufferItem *	docRtfGetSectItem(	RtfReadingContext *	rrc );

extern int docRtfFinishCurrentItem(	const RtfControlWord *	rcw,
					RtfReadingContext *	rrc );

extern void docRtfSaveParaTableNesting(	RtfWritingContext *		rwc,
					int				nest );

extern void docRtfInitTextConverters( RtfTextConverter * rtc );
extern void docRtfCleanTextConverters( RtfTextConverter * rtc );

extern int docRtfPushAttribute(		RtfWritingContext *	rwc );
extern int docRtfPopAttribute(		RtfWritingContext *	rwc );

extern void docRtfWriteSwitchTextAttributes(
					RtfWritingContext *	rwc,
					int			textAttrNr,
					const char *		first );

extern void docRtfWriteSwitchToPlain(		RtfWritingContext *	rwc );

extern void docRtfRestartFont(			RtfReadingContext *	rrc );

extern void docRtfInitEncodedFont(		EncodedFont *		ef );

extern int docRtfWriteBuildFontAdmin(	RtfWritingContext *		rwc );

extern int docRtfWriteGetCharset(
				RtfWritingContext *		rwc,
				int *				pCharset,
				const DocumentFont *		df,
				int				symbol );

extern int docRtfReadMapFont(	const RtfReadingContext *	rrc,
				int *				pDocFontNum,
				int *				pCharset,
				int				fileFontNum );

extern int docRtfRememberTextShadingProperty(
				const RtfControlWord *		rcw,
				int				arg,
				RtfReadingContext *		rrc );

extern int docRtfRememberParaShadingProperty(
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRememberCellShadingProperty(
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfRememberRowShadingProperty(
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc );

extern int docRtfReadGetBorderNumber(	RtfReadingContext *	rrc );

extern int docRtfReadListLevelGroup(	const RtfControlWord *	rcw,
					RtfReadingContext *	rrc );

extern int docRtfMemoryBufferSetText(
				MemoryBuffer *		mb,
				RtfReadingContext *	rrc,
				int			removeSemicolon );

extern int docRtfMemoryBufferAppendText(
				MemoryBuffer *		mb,
				RtfReadingContext *	rrc );

#    endif	/*  DOC_RTF_H	*/
