/************************************************************************/
/*									*/
/*  Row Properties.							*/
/*									*/
/************************************************************************/

#   ifndef	DOC_ROW_PROPS_H
#   define	DOC_ROW_PROPS_H

#   include	"docPropVal.h"
#   include	"docCellProperties.h"
#   include	"docBorderProperties.h"
#   include	"docDocumentAttributeMap.h"

/************************************************************************/
/*									*/
/*  Row Properties.							*/
/*									*/
/************************************************************************/

typedef struct RowProperties
    {
    int			rpCellCount;
    CellProperties *	rpCells;

    int			rpHalfGapWidthTwips;
    int			rpLeftIndentTwips;
    int			rpHeightTwips;

    int			rpRowNumber;
    int			rpRowBandNumber;
    int			rpRowStyle;

			/************************************************/
			/*  Row borders are not stored in the word	*/
			/*  binary format, and seem to be irrelevant	*/
			/************************************************/
    int			rpTopBorderNumber;
    int			rpBottomBorderNumber;
    int			rpLeftBorderNumber;
    int			rpRightBorderNumber;
    int			rpHorizontalBorderNumber;
    int			rpVerticalBorderNumber;

    int			rpShadingNumber;
    int			rpFrameNumber;

    unsigned char	rpAlignment;

    unsigned char	rpIsTableHeader;
    unsigned char	rpKeepOnOnePage;
    unsigned char	rp_Keepfollow;	/*  derived property	*/
    unsigned char	rpAutofit;

    int			rpPreferredWidth;

    int			rpLeftDefaultCellSpacing;
    int			rpRightDefaultCellSpacing;
    int			rpTopDefaultCellSpacing;
    int			rpBottomDefaultCellSpacing;

    int			rpLeftCellPadding;
    int			rpRightCellPadding;
    int			rpTopCellPadding;
    int			rpBottomCellPadding;

    int			rpCellWidthBefore;
    int			rpCellWidthAfter;

    int			rpAuthor;

			/* TableAutoFormatUnit */
    unsigned char	rpPreferredWidthUnit;

			/* TableAutoFormatUnit */
    unsigned char	rpLeftDefaultCellSpacingUnit;
    unsigned char	rpRightDefaultCellSpacingUnit;
    unsigned char	rpTopDefaultCellSpacingUnit;
    unsigned char	rpBottomDefaultCellSpacingUnit;

			/* TableAutoFormatUnit */
    unsigned char	rpLeftCellPaddingUnit;
    unsigned char	rpRightCellPaddingUnit;
    unsigned char	rpTopCellPaddingUnit;
    unsigned char	rpBottomCellPaddingUnit;

			/* TableAutoFormatUnit */
    unsigned char	rpCellWidthBeforeUnit;
    unsigned char	rpCellWidthAfterUnit;

    unsigned char	rpAutoformatBorders;
    unsigned char	rpAutoformatShading;
    unsigned char	rpAutoformatFont;
    unsigned char	rpAutoformatColor;
    unsigned char	rpAutoformatApplyBestFit;
    unsigned char	rpAutoformatFirstRow;
    unsigned char	rpAutoformatLastRow;
    unsigned char	rpAutoformatFirstColumn;
    unsigned char	rpAutoformatLastColumn;

    unsigned char	rpIsLastRow;
    } RowProperties;

typedef enum RowProperty
    {
    RPprop_NONE= -1,

    RPpropCOLUMNS= 0,

    RPpropGAP_WIDTH,
    RPpropLEFT_INDENT,
    RPpropHEIGHT,

    RPpropTOP_BORDER,
    RPpropBOTTOM_BORDER,
    RPpropLEFT_BORDER,
    RPpropRIGHT_BORDER,
    RPpropHORIZ_BORDER,
    RPpropVERT_BORDER,

    RPpropSHADING,
    RPpropFRAME,

    RPpropALIGNMENT,
    RPpropIS_TABLE_HEADER,
    RPpropKEEP_ON_ONE_PAGE,
    RPpropAUTOFIT,

    /**/
    RPpropTRW_WIDTH,
    RPpropTRFTS_WIDTH,

    /**/
    RPpropTRSPDL,
    RPpropTRSPDR,
    RPpropTRSPDT,
    RPpropTRSPDB,

    RPpropTRPADDL,
    RPpropTRPADDR,
    RPpropTRPADDT,
    RPpropTRPADDB,

    /**/
    RPpropTRSPDFL,
    RPpropTRSPDFR,
    RPpropTRSPDFT,
    RPpropTRSPDFB,

    RPpropTRPADDFL,
    RPpropTRPADDFR,
    RPpropTRPADDFT,
    RPpropTRPADDFB,

    /**/
    RPpropTRW_WIDTHB,
    RPpropTRW_WIDTHA,

    RPpropTRFTS_WIDTHB,
    RPpropTRFTS_WIDTHA,

    /**/
    RPpropAUTOFORMAT_BORDERS,
    RPpropAUTOFORMAT_SHADING,
    RPpropAUTOFORMAT_FONT,
    RPpropAUTOFORMAT_COLOR,
    RPpropAUTOFORMAT_APPLY_BEST_FIT,
    RPpropAUTOFORMAT_FIRST_ROW,
    RPpropAUTOFORMAT_LAST_ROW,
    RPpropAUTOFORMAT_FIRST_COLUMN,
    RPpropAUTOFORMAT_LAST_COLUMN,

    RPpropROW_NUMBER,
    RPpropROW_BAND_NUMBER,
    RPpropROW_STYLE,

    RPpropIS_LAST_ROW,
    RPpropTRAUTH,

    RPprop_COUNT,

    RPprop_IGNORED,		/*  For read/write/tool only	*/
    RPprop_KEEPFOLLOW,		/*  For read/write/tool only	*/

    RPprop_FULL_COUNT
    } RowProperty;

# define RP_IS_ONE_PAGE( rp ) ( \
		    (rp)->rpKeepOnOnePage	|| \
		    (rp)->rp_Keepfollow		|| \
		    (rp)->rpHeightTwips != 0	|| \
		    (rp)->rpIsTableHeader	)

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitRowProperties(	RowProperties *		rp );
extern void docCleanRowProperties(	RowProperties *		rp );
extern void docCleanInitRowProperties(	RowProperties *		rp );

extern int docCopyRowProperties(	RowProperties *			to,
					const RowProperties *		from,
					const DocumentAttributeMap *	dam );

extern int docInsertRowColumn(	RowProperties *			rp,
				int				n,
				const CellProperties *		cp,
				const DocumentAttributeMap *	dam );

extern int docApproximatelyAlignedColumns(
				const RowProperties *	rp1,
				const RowProperties *	rp2 );

extern int docEqualRowBorders(	const RowProperties *	rp1,
				const RowProperties *	rp2 );

extern int docEqualRows(	const RowProperties *	rp1,
				const RowProperties *	rp2 );

extern int docUpdRowProperties(	PropertyMask *			pRpChgPask,
				RowProperties *			rp,
				const PropertyMask *		rpUpdMask,
				const RowProperties *		rpNew,
				const DocumentAttributeMap *	dam );

extern void docRowPropertyDifference(
				PropertyMask *			pRpChgPask,
				const RowProperties *		rp1,
				const RowProperties *		rp2,
				const PropertyMask *		rpUpdMask,
				const DocumentAttributeMap *	dam );

extern int docDeleteColumnsFromRow(
				RowProperties *			rp,
				int				col0,
				int				count );

extern void docRowPropertiesSetWidth(	RowProperties *		rp,
					int			col0,
					int			col1,
					int			wide,
					int			victim,
					int			victimWide );

extern int docSetRowProperty(		RowProperties *		rp,
					int			prop,
					int			arg );

extern int docGetRowProperty(		const RowProperties *	rp,
					int			prop );

#   endif	/*  DOC_ROW_PROPS_H  */
