/************************************************************************/
/*									*/
/*  Include a file from the file system in an object.			*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appSystem.h>
#   include	"docObject.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Read a bitmap/pixmap image file.					*/
/*  Read a windows metafile.						*/
/*									*/
/************************************************************************/

static int docReadIncludedBitmapFile(	const char *		fullName,
					int			fullNameLen,
					InsertedObject *	io )
    { return docReadBitmapObject( io, fullName );	}

static int docCollectIncludedWmfFile(	const char *		fullName,
					int			fullNameLen,
					InsertedObject *	io )
    { return docReadWmfObject( io, fullName );	}

static int docCollectIncludedEmfFile(	const char *		fullName,
					int			fullNameLen,
					InsertedObject *	io )
    { return docReadEmfObject( io, fullName );	}

/************************************************************************/
/*									*/
/*  Evaluate an 'INCLUDEPICTURE' field.					*/
/*									*/
/************************************************************************/

int docReadFileObject(		const char *		fullName,
				int			fullNameLen,
				InsertedObject *	io )
    {
    int				res;
    int				included= 0;
    const char *		extension;

    extension= appFileExtensionOfName( fullName );

    if  ( ! included					&&
	  extension					&&
	  ( ! strcmp( extension, "ps" )		||
	    ! strcmp( extension, "eps" )	||
	    ! strcmp( extension, "PS" )		||
	    ! strcmp( extension, "EPS" )	)	)
	{
	res= docReadEpsObject( fullName, fullNameLen, io );
	if  ( res )
	    { SDEB(fullName);	}
	else{ included= 1;	}
	}

    if  ( ! included					&&
	  extension					&&
	  ( ! strcmp( extension, "wmf" )	||
	    ! strcmp( extension, "WMF" ) 	)	)
	{
	res= docCollectIncludedWmfFile( fullName, fullNameLen, io );
	if  ( res )
	    { SDEB(fullName);	}
	else{ included= 1;	}
	}

    if  ( ! included					&&
	  extension					&&
	  ( ! strcmp( extension, "emf" )	||
	    ! strcmp( extension, "EMF" ) 	)	)
	{
	res= docCollectIncludedEmfFile( fullName, fullNameLen, io );
	if  ( res )
	    { SDEB(fullName);	}
	else{ included= 1;	}
	}

    if  ( ! included )
	{
	res= docReadIncludedBitmapFile( fullName, fullNameLen, io );
	if  ( res )
	    { SDEB(fullName);	}
	}

    return res;
    }

