/************************************************************************/
/*									*/
/*  Text Editor Buffer structure of the string buffer in a paragraph.	*/
/*									*/
/************************************************************************/

#   ifndef	DOC_PARA_STRING_H
#   define	DOC_PARA_STRING_H

#   include	<utilTextConverter.h>

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int docSaveParticules(	BufferDocument *	bd,
				BufferItem *		paraBi,
				const TextAttribute *	ta,
				TextConverter *		tc,
				const char *		text,
				int			len );

extern int docParaDivideAppendedText(
				BufferItem *		paraBi,
				int			textAttributeNumber,
				int			stroff,
				int			upto );

extern int docRedivideStringInParticules(
				BufferItem *		bi,
				int			strOff,
				int			strLen,
				int			part,
				int			partsFree,
				int			textAttributeNumber );

extern int docParaStringReplace(	int *			pStroffShift,
					BufferItem *		bi,
					int			stroffBegin,
					int			stroffTail,
					const char *		addedString,
					int			addedStrlen );

extern int docParaFixStroff(	const BufferItem *	paraBi,
				int			stroff );

extern int docParaNextStroff(	const BufferItem *	paraBi,
				int			stroff );

extern int docParaPrevStroff(	const BufferItem *	paraBi,
				int			stroff );

extern int docParaHeadStroff(	const BufferItem *	paraBi );

extern int docParaTailStroff(	const BufferItem *	paraBi );

#   endif
