/************************************************************************/
/*									*/
/*  Get/Move/Set Selections in paragraphs.				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"
#   include	"docParaString.h"

#   define DOCisADMINISTRATIVE(k) \
	    ( (k) == DOCkindFIELDSTART || (k) == DOCkindFIELDEND )

/*  Navigate to the next valid document position.			*/

/************************************************************************/
/*									*/
/*  Return the next valid string offset in the document.		*/
/*									*/
/*  Positions inside an UTF-8 sequence and positions between		*/
/*  administrative particules are invalid.				*/
/*  This means that hopping over an administrative particule is not a	*/
/*  step that counts.							*/
/*									*/
/************************************************************************/

int docNextPosition(	DocumentPosition *	dp )
    {
    BufferItem *	paraBi= dp->dpBi;
    int			stroff= dp->dpStroff;
    int			tail= docParaTailStroff( paraBi );

    if  ( stroff >= tail )
	{ stroff= -1;	}

    while( stroff >= 0 && stroff < tail )
	{
	DocumentPosition	dpNext;
	const int		lastOne= 0;
	int			part;

	stroff= docParaNextStroff( paraBi, stroff );
	if  ( stroff < 0 )
	    { break;	}

	docSetDocumentPosition( &dpNext, (BufferItem *)paraBi, stroff );
	if  ( docFindParticuleOfPosition( &part, &dpNext, lastOne ) )
	    { LDEB(1); return -1;	}

	if  ( ! DOCisADMINISTRATIVE( paraBi->biParaParticules[part].tpKind ) )
	    { break;	}
	}

    while( paraBi )
	{
	if  ( stroff >= 0 && stroff <= tail )
	    {
	    docSetDocumentPosition( dp, paraBi, stroff );
	    return 0;
	    }

	paraBi= docNextParagraph( paraBi );
	if  ( ! paraBi )
	    { break;	}

	stroff= docParaHeadStroff( paraBi );
	if  ( docParaStrlen( paraBi ) == 0 )
	    {
	    docSetDocumentPosition( dp, paraBi, stroff );
	    return 0;
	    }
	}

    return -1;
    }

/************************************************************************/
/*									*/
/*  Return the previous valid string offset in the paragraph.		*/
/*									*/
/*  Positions inside an UTF-8 sequence and positions between		*/
/*  administrative particules are invalid.				*/
/*  This means that hopping over an administrative particule is not a	*/
/*  step that counts.							*/
/*									*/
/************************************************************************/

int docPrevPosition(	DocumentPosition *	dp )
    {
    BufferItem *	paraBi= dp->dpBi;
    int			stroff= dp->dpStroff;

    int			head= docParaHeadStroff( paraBi );

    if  ( stroff <= head )
	{ stroff= -1;	}

    while( stroff > head )
	{
	DocumentPosition	dpPrev;
	const int		lastOne= 1;
	int			part;

	stroff= docParaPrevStroff( paraBi, stroff );
	if  ( stroff < 0 )
	    { break;	}

	docSetDocumentPosition( &dpPrev, (BufferItem *)paraBi, stroff );
	if  ( docFindParticuleOfPosition( &part, &dpPrev, lastOne ) )
	    { LDEB(1); return -1;	}

	if  ( ! DOCisADMINISTRATIVE( paraBi->biParaParticules[part].tpKind ) )
	    { break;	}
	}

    while( paraBi )
	{
	if  ( paraBi->biLevel == DOClevPARA	&&
	      stroff >= 0			)
	    {
	    docSetDocumentPosition( dp, paraBi, stroff );
	    return 0;
	    }

	paraBi= docPrevParagraph( paraBi );
	if  ( paraBi )
	    { stroff= docParaTailStroff( paraBi ); }
	}

    return -1;
    }

int docParaBegin(	DocumentPosition *	dp )
    {
    docSetDocumentPosition( dp, dp->dpBi, docParaHeadStroff( dp->dpBi ) );

    return 0;
    }

int docParaEnd(		DocumentPosition *	dp )
    {
    docSetDocumentPosition( dp, dp->dpBi, docParaTailStroff( dp->dpBi ) );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Return the first valid string offset in the paragraph.		*/
/*									*/
/*  Return 0, or the position after a series of administrative		*/
/*  particules.								*/
/*									*/
/************************************************************************/

int docParaHeadStroff(	const BufferItem *	paraBi )
    {
    int		stroff= 0;
    int		part= 0;

    while( part < paraBi->biParaParticuleCount				&&
	   DOCisADMINISTRATIVE(paraBi->biParaParticules[part].tpKind)	)
	{
	stroff= paraBi->biParaParticules[part].tpStroff+
				    paraBi->biParaParticules[part].tpStrlen;
	part++;
	}

    return stroff;
    }

/************************************************************************/
/*									*/
/*  Return the last valid string offset in the paragraph.		*/
/*									*/
/*  Return the last position in the paragraph or the position before	*/
/*  a series of administrative particules.				*/
/*									*/
/************************************************************************/

int docParaTailStroff(	const BufferItem *	paraBi )
    {
    int		stroff= docParaStrlen( paraBi );
    int		part= paraBi->biParaParticuleCount- 1;

    if  ( part < 0 )
	{ LDEB(part); docListItem(0,paraBi,0); return -1;	}

    while( part >= 0							&&
	   DOCisADMINISTRATIVE(paraBi->biParaParticules[part].tpKind)	)
	{
	stroff= paraBi->biParaParticules[part].tpStroff;
	part--;
	}

    return stroff;
    }

