/************************************************************************/
/*									*/
/*  Paragraph numbers.							*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	"docParaNumber.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Paragraph numbering.						*/
/*									*/
/************************************************************************/

void docCleanParagraphNumber(	ParagraphNumber*	pn )
    {
    if  ( pn->pnTextBefore )
	{ free( pn->pnTextBefore );	}
    if  ( pn->pnTextAfter )
	{ free( pn->pnTextAfter );	}

    return;
    }

void docInitParagraphNumber(	ParagraphNumber*	pn )
    {
    pn->pnLevel= -1;
    pn->pnNumberStyle= DOCpnDEC;
    pn->pnJustification= 0; /* left */
    pn->pnUsePrevText= 0;

    pn->pnUseHangingIndent= 0;

    pn->pnStartAt= 0;
    pn->pnIndent= 0;
    pn->pnSpace= 0;

    utilInitTextAttribute( &(pn->pnTextAttribute) );

    pn->pnTextBefore= (char *)0;
    pn->pnTextAfter= (char *)0;

    return;
    }

int docCopyParagraphNumber(	ParagraphNumber *	to,
				ParagraphNumber *	from )
    {
    int		rval= 0;
    char *	a= (char *)0;
    char *	b= (char *)0;

    if  ( from->pnTextAfter )
	{
	a= strdup( from->pnTextAfter );
	if  ( ! a )
	    { XDEB(a); rval= -1; goto ready;	}
	}

    if  ( from->pnTextBefore )
	{
	b= strdup( from->pnTextBefore );
	if  ( ! b )
	    { XDEB(b); rval= -1; goto ready;	}
	}

    *to= *from;
    to->pnTextAfter= a; a= (char *)0; /* steal */
    to->pnTextBefore= b; b= (char *)0; /* steal */

  ready:
    if  ( a )
	{ free( a );	}
    if  ( b )
	{ free( b );	}
    return rval;
    }
