/************************************************************************/
/*									*/
/*  Text Editor Buffer structure of a paragraph.			*/
/*									*/
/************************************************************************/

#   ifndef	DOC_PARA_ITEM_H
#   define	DOC_PARA_ITEM_H

#   include	"docParaProperties.h"
#   include	"docShapeProperties.h"
#   include	"docObject.h"
#   include	"docTextParticule.h"
#   include	"docTextLine.h"

/************************************************************************/
/*									*/
/*  A Paragraph.							*/
/*									*/
/************************************************************************/

typedef struct ParaItem
    {
    MemoryBuffer		btStringBuffer;

    int				btParticuleCount;
    TextParticule *		btParticules;

    int				btLineCount;
    TextLine *			btLines;

    ParagraphProperties		btProperties;

    int				btFontAscY0;
    int				btFontDescY1;
    int				btMajorityFontSize;
					/********************************/
					/*  Also used to find out	*/
					/*  whether the line extents	*/
					/*  must be recalculated.	*/
					/********************************/

    int				btBorderNrAbove;
    int				btBorderNrBelow;
    int				btTopInset;
    int				btBottomInset;

    unsigned char		btFlags;
#				define	PARAflagFILL_BEFORE	0x01
#				define	PARAflagFILL_AFTER	0x02
    } ParaItem;


/************************************************************************/
/*									*/
/*  Shortcut defines through the BufferItem union.			*/
/*									*/
/************************************************************************/

#	define	biParaString		BIU.biuPara.btStringBuffer.mbBytes
#	define	docParaStrlen( bi )	((bi)->BIU.biuPara.btStringBuffer.mbSize+0)
#	define	biParaStringBuffer      BIU.biuPara.btStringBuffer
#	define	docParaSetStrlen( bi, l ) \
	    utilSizeMemoryBuffer( &((bi)->BIU.biuPara.btStringBuffer), (l) );
#	define	docParaString( bi, fr )	((bi)->BIU.biuPara.btStringBuffer.mbBytes+(fr))

#	define	biParaParticuleCount	BIU.biuPara.btParticuleCount
#	define	biParaParticules	BIU.biuPara.btParticules
#	define	biParaLineCount		BIU.biuPara.btLineCount
#	define	biParaLines		BIU.biuPara.btLines

#	define	biParaFontAscY0		BIU.biuPara.btFontAscY0
#	define	biParaFontDescY1	BIU.biuPara.btFontDescY1
#	define	biParaMajorityFontSize	BIU.biuPara.btMajorityFontSize

#	define	biParaTopInset		BIU.biuPara.btTopInset
#	define	biParaBottomInset	BIU.biuPara.btBottomInset
#	define	biParaFlags		BIU.biuPara.btFlags
					/********************************/
					/*  Also used to find out	*/
					/*  whether the line extents	*/
					/*  must be recalculated.	*/
					/********************************/

#	define	biParaBorderNrAbove	BIU.biuPara.btBorderNrAbove
#	define	biParaBorderNrBelow	BIU.biuPara.btBorderNrBelow

#	define	biParaProperties	BIU.biuPara.btProperties

#	define	biParaTableNesting	biParaProperties.ppTableNesting
#	define	biParaLineSpacingIsMultiple \
					biParaProperties.ppLineSpacingIsMultiple
#	define	biParaBreakKind		biParaProperties.ppBreakKind
#	define	biParaFirstIndentTwips	biParaProperties.ppFirstIndentTwips
#	define	biParaLeftIndentTwips	biParaProperties.ppLeftIndentTwips
#	define	biParaRightIndentTwips	biParaProperties.ppRightIndentTwips
#	define	biParaSpaceBeforeTwips	biParaProperties.ppSpaceBeforeTwips
#	define	biParaSpaceAfterTwips	biParaProperties.ppSpaceAfterTwips
#	define	biParaLineSpacingTwips	biParaProperties.ppLineSpacingTwips
#	define	biParaAlignment		biParaProperties.ppAlignment
#	define	biParaTabStopList	biParaProperties.ppTabStopList
#	define	biParaKeepOnPage	biParaProperties.ppKeepOnPage
#	define	biParaKeepWithNext	biParaProperties.ppKeepWithNext
#	define	biParaShadingNumber	biParaProperties.ppShadingNumber
#	define	biParaFrameNumber	biParaProperties.ppFrameNumber
#	define	biParaOutlineLevel	biParaProperties.ppOutlineLevel
#	define	biParaListLevel		biParaProperties.ppListLevel
#	define	biParaTopBorderNumber	biParaProperties.ppTopBorderNumber
#	define	biParaBottomBorderNumber \
					biParaProperties.ppBottomBorderNumber
#	define	biParaLeftBorderNumber	biParaProperties.ppLeftBorderNumber
#	define	biParaRightBorderNumber	biParaProperties.ppRightBorderNumber
#	define	biParaBetweenBorderNumber \
					biParaProperties.ppBetweenBorderNumber
#	define	biParaBarNumber		biParaProperties.ppBarNumber
#	define	biParaStyle		biParaProperties.ppStyle
#	define	biParaListOverride	biParaProperties.ppListOverride
#	define	biParaWidowControl	biParaProperties.ppWidowControl

#	define	biParaTabStopCount	biParaTabStopList.tslTabStopCount
#	define	biParaTabStops		biParaTabStopList.tslTabStops

#   endif
