/************************************************************************/
/*									*/
/*  Layout of a document.						*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<limits.h>

#   include	"docBuf.h"
#   include	"docPageGrid.h"
#   include	"docBlockFrame.h"
#   include	"docStripFrame.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Administrative routines: manage a block frame.			*/
/*									*/
/************************************************************************/

void docLayoutInitBlockFrame(	BlockFrame *	bf )
    {
    bf->bfPage= -1;
    bf->bfColumn= -1;
    geoInitRectangle( &(bf->bfFlowRect) );
    geoInitRectangle( &(bf->bfContentRect) );

    utilInitDocumentGeometry( &(bf->bfPageGeometry) );

    bf->bfFootnotesPlaced= 0;
    docInitNotesReservation( &(bf->bfNotesReservation) );
    }

void docInitNotesReservation(	NotesReservation *	nr )
    {
    nr->nrDfFirstFootnote= (DocumentField *)0;
    nr->nrFootnoteCount= 0;
    nr->nrFootnoteSectBi= (const BufferItem *)0;

    nr->nrFtnsepHeight= 0;
    nr->nrFootnoteHeight= 0;
    }

/************************************************************************/
/*									*/
/*  Derive the frame for a paragraph from the page rectangle and the	*/
/*  paragraph properties.						*/
/*									*/
/*  For paragraphs inside a table cell, geometry is derived from the	*/
/*  table column.							*/
/*									*/
/*  1)  The block starts below what has been reserved for the page	*/
/*	header.								*/
/*  2)  The block starts above what has been reserved for the page	*/
/*	footer.								*/
/*									*/
/************************************************************************/

void docBlockFrameTwips(	BlockFrame *			bf,
				BufferItem *			bi,
				const BufferItem *		bodySectBi,
				const BufferDocument *		bd,
				int				page,
				int				column )
    {
    DocumentTree *		ei;
    int				inHeaderFooter;
    int				useColumns= 0;

    int				newFrame;
    int				prevY1;

    const SectionProperties *	sp;

    newFrame= page != bf->bfPage ||
	( bf->bfNotesReservation.nrFootnoteSectBi == bodySectBi &&
						    column != bf->bfColumn );

    bi= docGetSectItem( bi );
    if  ( ! bi )
	{ XDEB(bi); return;	}

    sp= &(bi->biSectProperties);

    if  ( bi->biInExternalItem != DOCinBODY && ! bodySectBi )
	{ SXDEB(docExternalKindStr(bi->biInExternalItem),bodySectBi);	}

    if  ( bi->biInExternalItem != DOCinBODY	&&
	  bi->biInExternalItem != DOCinSHPTXT	&&
	  bodySectBi				)
	{ sp= &(bodySectBi->biSectProperties);	}

    bf->bfPageGeometry= sp->spDocumentGeometry;

    bf->bfPage= page;
    bf->bfColumn= column;

    bf->bfContentRect.drX0= bf->bfPageGeometry.dgLeftMarginTwips;
    bf->bfContentRect.drX1= bf->bfPageGeometry.dgPageWideTwips-
					bf->bfPageGeometry.dgRightMarginTwips;

    if  ( bi->biInExternalItem != DOCinSHPTXT )
	{
	const DocumentProperties *	dp= &(bd->bdProperties);

	if  ( sp->spDocumentGeometry.dgMirrorMargins )
	    {
	    if  ( dp->dpHasFacingPages && page % 2 )
		{
		bf->bfPageGeometry.dgLeftMarginTwips=
				    sp->spDocumentGeometry.dgRightMarginTwips;
		bf->bfPageGeometry.dgRightMarginTwips=
				    sp->spDocumentGeometry.dgLeftMarginTwips;
		}
	    }
	else{
	    if  ( dp->dpHasFacingPages && page % 2 )
		{
		bf->bfPageGeometry.dgRightMarginTwips +=
					sp->spDocumentGeometry.dgGutterTwips;
		}
	    else{
		bf->bfPageGeometry.dgLeftMarginTwips +=
					sp->spDocumentGeometry.dgGutterTwips;
		}
	    }

	/*  Should be irrelevant: */
	bf->bfPageGeometry.dgMirrorMargins= 0;
	bf->bfPageGeometry.dgGutterTwips= 0;
	}

    useColumns= DOClayoutUSE_COLUMNS( bi->biInExternalItem );

    if  ( useColumns && sp->spColumnCount > 1 )
	{
	int	xLine;

	docSectGetColumnX( &xLine, &(bf->bfContentRect.drX0),
				    &(bf->bfContentRect.drX1),
				    sp, &(bf->bfPageGeometry), column );
	}

    if  ( bi->biInExternalItem != DOCinBODY || newFrame )
	{ docInitNotesReservation( &(bf->bfNotesReservation) );	}

    switch( bi->biInExternalItem )
	{
	int		isEmpty;

	case DOCinBODY:

	case DOCinFOOTNOTE:
	case DOCinENDNOTE:

	case DOCinFTNSEP:
	case DOCinFTNSEPC:
	case DOCinFTNCN:
	case DOCinAFTNSEP:
	case DOCinAFTNSEPC:
	case DOCinAFTNCN:

	    inHeaderFooter= docWhatPageHeader( &ei, &isEmpty, bi, page, bd );

	    /*  1 Reserved!!  */
	    if  ( ei && ei->eiRoot )
		{ bf->bfContentRect.drY0= ei->eiY1ReservedTwips;	}
	    else{
		bf->bfContentRect.drY0= bf->bfPageGeometry.dgTopMarginTwips;	
		}

	    inHeaderFooter= docWhatPageFooter( &ei, &isEmpty, bi, page, bd );

	    /*  2 Reserved!!  */
	    if  ( ei && ei->eiRoot )
		{
		bf->bfContentRect.drY1= ei->eiY0ReservedTwips;
		}
	    else{
		bf->bfContentRect.drY1=
			    bf->bfPageGeometry.dgPageHighTwips-
			    bf->bfPageGeometry.dgBottomMarginTwips;
		}

	    /*
	    appDebug( "PAGE %3d BLOCK Y: %5d..%5d %s\n",
			page, bf->bfContentRect.drY0, bf->bfContentRect.drY1,
			docExternalKindStr( bi->biInExternalItem ) );
	    */

	    break;

	case DOCinFIRST_HEADER:
	case DOCinLEFT_HEADER:
	case DOCinRIGHT_HEADER:

	case DOCinFIRST_FOOTER:
	case DOCinLEFT_FOOTER:
	case DOCinRIGHT_FOOTER:

	    if  ( column != 0 )
		{ LDEB(column);	}

	    /* const
	    ei= docSectionHeaderFooter( bodySectBi, bi->biInExternalItem );
	    */
	    ei= docSectionHeaderFooter(
		    bd->bdBody.eiRoot->biChildren[bodySectBi->biNumberInParent],
		    bi->biInExternalItem );
	    bf->bfContentRect.drY0= ei->eiY0ReservedTwips;
	    bf->bfContentRect.drY1= ei->eiY1ReservedTwips;
	    break;

	case DOCinSHPTXT:

	    bf->bfContentRect.drY0= bf->bfPageGeometry.dgTopMarginTwips;
	    bf->bfContentRect.drY1=
			    bf->bfPageGeometry.dgPageHighTwips-
			    bf->bfPageGeometry.dgBottomMarginTwips;
	    break;

	default:
	    LDEB(bi->biInExternalItem);
	}

    prevY1= bf->bfContentRect.drY1;

    bf->bfFlowRect= bf->bfContentRect;

    if  ( bi->biInExternalItem == DOCinBODY && ! newFrame )
	{ bf->bfFlowRect.drY1= prevY1;	}

    return;
    }

void docParaBlockFrameTwips(	BlockFrame *		bf,
				BufferItem *		paraBi,
				const BufferItem *	bodySectBi,
				const BufferDocument *	bd,
				int			page,
				int			column )
    {
    if  ( paraBi->biLevel != DOClevPARA )
	{ LDEB(paraBi->biLevel);	}
    else{
	FrameProperties	fp;

	docGetFramePropertiesByNumber( &fp, &(bd->bdFramePropertyList),
						paraBi->biParaFrameNumber );
	if  ( DOCisFRAME( &fp ) )
	    {
	    BlockFrame		bfPage;
	    LayoutPosition	lpScratch;

	    int			frameHigh= fp.fpHighTwips;

	    if  ( frameHigh < 0 )
		{ frameHigh= -frameHigh;	}

	    docInitLayoutPosition( &lpScratch );

	    docLayoutInitBlockFrame( bf );
	    docLayoutInitBlockFrame( &bfPage );

	    docBlockFrameTwips( &bfPage, paraBi, bodySectBi, bd, page, column );
	    docLayoutSetTextFrame( bf, &lpScratch, &bfPage, &fp, frameHigh );

	    return;
	    }
	}

    docBlockFrameTwips( bf, paraBi, bodySectBi, bd, page, column );
    }

void docParaBlockFrameRectangle( DocumentRectangle *	dr,
				BufferItem *		paraBi,
				const BufferItem *	bodySectBi,
				const BufferDocument *	bd,
				int			page,
				int			column )
    {
    BlockFrame	bf;

    docLayoutInitBlockFrame( &bf );
    docBlockFrameTwips( &bf, paraBi, bodySectBi, bd, page, column );

    *dr= bf.bfContentRect;
    }

/************************************************************************/
/*									*/
/*  Shift a cell frame for all cells that surround its table. In	*/
/*  practice, this code is only activated for nested tables.		*/
/*									*/
/************************************************************************/

static void docShiftCellFrame(	ParagraphFrame *	pf,
				const BufferItem *	rowBi )
    {
    int			nrInParent= rowBi->biNumberInParent;
    const BufferItem *	parentBi= rowBi->biParent;

    while( parentBi )
	{
	if  ( parentBi->biLevel == DOClevROW )
	    {
	    const RowProperties *	rp= &(parentBi->biRowProperties);
	    int				x0;

	    if  ( nrInParent == 0 )
		{ x0= rowBi->biRowLeftIndentTwips;			}
	    else{ x0= rp->rpCells[nrInParent-1].cpRightBoundaryTwips;	}

	    x0 += rp->rpHalfGapWidthTwips;

	    pf->pfParaContentRect.drX0 += x0;
	    pf->pfParaContentRect.drX1 += x0;
	    pf->pfCellContentRect.drX0 += x0;
	    pf->pfCellContentRect.drX1 += x0;
	    pf->pfCellRect.drX0 += x0;
	    pf->pfCellRect.drX1 += x0;
	    pf->pfRedrawX0Twips += x0;
	    pf->pfRedrawX1Twips += x0;
	    }

	nrInParent= parentBi->biNumberInParent;
	parentBi= parentBi->biParent;
	}
    }

/************************************************************************/
/*									*/
/*  Determine the frame for a table cell.				*/
/*									*/
/************************************************************************/

void docCellFrameTwips(		ParagraphFrame *	pf,
				const BlockFrame *	bf,
				const BufferItem *	cellBi )
    {
    int				col0;
    const BufferItem *		rowBi= cellBi->biParent;
    const RowProperties *	rp= &(rowBi->biRowProperties);
    const CellProperties *	cp0;

    int				leftMargin= rowBi->biRowHalfGapWidthTwips;
    int				rightMargin= rowBi->biRowHalfGapWidthTwips;

    pf->pfRedrawX0Twips= bf->bfContentRect.drX0;
    pf->pfRedrawX1Twips= bf->bfContentRect.drX1;

    pf->pfCellRect.drY0= INT_MIN;
    pf->pfCellRect.drY1= INT_MAX;
    pf->pfCellRect.drX0= bf->bfContentRect.drX0;
    pf->pfCellRect.drX1= bf->bfContentRect.drX1;

    if  ( ! docIsRowItem( rowBi ) )
	{ LDEB(rowBi->biRowCellCount); return;	}

    col0= cellBi->biNumberInParent;
    cp0= rp->rpCells+ col0;

    switch( rp->rpLeftCellPaddingUnit )
	{
	case TRautoNONE:
	    break;
	case TRautoTWIPS:
	    leftMargin= rp->rpLeftCellPadding;
	    break;
	default:
	    LDEB(rp->rpLeftCellPaddingUnit);
	    break;
	}

    switch( cp0->cpLeftPaddingUnit )
	{
	case TRautoNONE:
	    break;
	case TRautoTWIPS:
	    leftMargin= cp0->cpLeftPadding;
	    break;
	default:
	    LDEB(cp0->cpLeftPaddingUnit);
	    break;
	}

    switch( rp->rpRightCellPaddingUnit )
	{
	case TRautoNONE:
	    break;
	case TRautoTWIPS:
	    rightMargin= rp->rpRightCellPadding;
	    break;
	default:
	    LDEB(rp->rpRightCellPaddingUnit);
	    break;
	}

    switch( cp0->cpRightPaddingUnit )
	{
	case TRautoNONE:
	    break;
	case TRautoTWIPS:
	    rightMargin= cp0->cpRightPadding;
	    break;
	default:
	    LDEB(cp0->cpRightPaddingUnit);
	    break;
	}

    if  ( col0 == 0 )
	{ pf->pfCellRect.drX0 += rowBi->biRowLeftIndentTwips;	}
    else{ pf->pfCellRect.drX0 += cp0[-1].cpRightBoundaryTwips;	}

    pf->pfCellRect.drX1= bf->bfContentRect.drX0+ cp0->cpRightBoundaryTwips;
    if  ( cp0->cpLeftInMergedRow )
	{
	int		colspan= 1;
	int		x1= docGetCellRight( &colspan, rowBi, col0 );

	pf->pfCellRect.drX1= bf->bfContentRect.drX0+ x1;
	}

    if  ( rowBi->biRowCellCount < 1 )
	{ LDEB(rowBi->biRowCellCount);	}
    else{
	pf->pfRedrawX0Twips= -rowBi->biRowLeftIndentTwips;
	pf->pfRedrawX1Twips=
		rp->rpCells[rowBi->biRowCellCount-1].cpRightBoundaryTwips;
	}

    if  ( rowBi->biRowHeightTwips < 0 )
	{
	pf->pfCellRect.drY0= rowBi->biTopPosition.lpPageYTwips;
	pf->pfCellRect.drY1= pf->pfCellRect.drY0- rowBi->biRowHeightTwips;
	}

    pf->pfCellContentRect= pf->pfCellRect;
    pf->pfCellContentRect.drX0 += leftMargin;
    pf->pfCellContentRect.drX1 -= rightMargin;

    docShiftCellFrame( pf, rowBi );

    return;
    }

void docParagraphFrameTwips(	ParagraphFrame *	pf,
				const BlockFrame *	bf,
				const BufferItem *	paraBi )
    {
    if  ( paraBi->biLevel != DOClevPARA )
	{ SDEB(docLevelStr(paraBi->biLevel));	}

    if  ( paraBi->biParaTableNesting > 0 )
	{ docCellFrameTwips( pf, bf, paraBi->biParent );	}
    else{
	pf->pfRedrawX0Twips= bf->bfContentRect.drX0;
	pf->pfRedrawX1Twips= bf->bfContentRect.drX1;

	pf->pfCellRect.drY0= INT_MIN;
	pf->pfCellRect.drY1= INT_MAX;
	pf->pfCellRect.drX0= bf->bfContentRect.drX0;
	pf->pfCellRect.drX1= bf->bfContentRect.drX1;

	pf->pfCellContentRect= pf->pfCellRect;
	}

    pf->pfParaContentRect= pf->pfCellContentRect;
    pf->pfParaContentRect.drX0 += paraBi->biParaLeftIndentTwips;
    pf->pfParaContentRect.drX1 -= paraBi->biParaRightIndentTwips;

    return;
    }

/************************************************************************/
/*									*/
/*  Continue to lay out the text on a subsequent page.			*/
/*									*/
/*  1)  Continuous section wrap to the same position as where they	*/
/*	started on the page.						*/
/*									*/
/************************************************************************/

void docLayoutSectColumnTop(	LayoutPosition *	lpTop,
				BlockFrame *		bf,
				BufferItem *		bodySectBi,
				BufferDocument *	bd )
    {
    if  ( bodySectBi->biInExternalItem != DOCinBODY )
	{ SDEB(docExternalKindStr(bodySectBi->biInExternalItem));	}

    docBlockFrameTwips( bf, bodySectBi, bodySectBi,
					bd, lpTop->lpPage, lpTop->lpColumn );

    lpTop->lpPageYTwips= bf->bfContentRect.drY0;
    lpTop->lpAtTopOfColumn= 1;

    /*  1  */
    if  ( DOC_SECTitemBELOW_PREVIOUS( bodySectBi )		&&
	  lpTop->lpPage == bodySectBi->biTopPosition.lpPage	&&
	  bodySectBi->biSectColumnCount > 1			&&
	  lpTop->lpColumn > 0					)
	{
	lpTop->lpPageYTwips= bodySectBi->biTopPosition.lpPageYTwips;
	lpTop->lpAtTopOfColumn= 0;
	}

    return;
    }

