/************************************************************************/
/*									*/
/*  List the fonts in a document.					*/
/*  Manage resources for layout.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	<uniUtf8.h>
#   include	"docParticuleData.h"
#   include	"docListFonts.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Recursively retrieve the list of Document Fonts that is used in	*/
/*  a document.								*/
/*									*/
/************************************************************************/

typedef struct GetCharsUsed
    {
    DocumentFontList *			gcuDocumentFontList;
    } GetCharsUsed;

static int docCharsUsedGotSpan(	const BufferDocument *		bd,
				BufferItem *			paraBi,
				const TextAttribute *		ta,
				int				from,
				int				upto,
				void *				through )
    {
    GetCharsUsed *		gcu= (GetCharsUsed *)through;
    DocumentFontList *		dfl= gcu->gcuDocumentFontList;
    const unsigned char *	s;

    DocumentFont *		df;

    df= docFontListGetFontByNumber( dfl, ta->taFontNumber );
    if  ( ! df )
	{ LXDEB(ta->taFontNumber,df); return -1;	}

    if  ( from == upto )
	{
	if  ( utilIndexSetAdd( &(df->dfUnicodesUsed), 0x20 ) )
	    { XDEB(0x20); return -1;	}
	}

    s= docParaString( paraBi, from );
    while( from < upto )
	{
	unsigned short			symbol;
	int				step;

	step= uniGetUtf8( &symbol, (unsigned char *)s );
	if  ( step < 1 )
	    { LDEB(step); return -1;	}

	if  ( symbol == 0xa0 )
	    { symbol= 0x20;	}

	if  ( utilIndexSetAdd( &(df->dfUnicodesUsed), symbol ) )
	    { LDEB(symbol); return -1;	}

	s += step; from += step;
	}

    return 0;
    }

int docGetCharsUsed(	BufferDocument *		bd )
    {
    DocumentFontList *		dfl= &(bd->bdProperties.dpFontList);

    ScanDocumentFonts		sdf;
    GetCharsUsed		gcu;

    utilDocFontListClearCharsUsed( dfl );

    gcu.gcuDocumentFontList= dfl;

    sdf.sdfListObjectFonts= (DocListObjectFonts)0;
    sdf.sdfDocListSpanFont= docCharsUsedGotSpan;
    sdf.sdfThrough= &gcu;

    /*  a  */
    if  ( docListDocumentFonts( bd, &sdf ) )
	{ LDEB(1); return -1;;	}

    return 0;
    }

