#   ifndef	DOC_LIST_FONTS_H
#   define	DOC_LIST_FONTS_H

/************************************************************************/
/*									*/
/*  List the fonts in a document.					*/
/*									*/
/************************************************************************/

#   include	"docParticuleData.h"
#   include	"docFind.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Recursively retrieve the list of fonts that is used in a document.	*/
/*									*/
/************************************************************************/

typedef int (*DocListObjectFonts)(
				const InsertedObject *		io,
				const char *			prefix,
				void *				through );

typedef int (*DocListSpanFont)(
				const BufferDocument *		bd,
				BufferItem *			paraBi,
				const TextAttribute *		ta,
				int				from,
				int				upto,
				void *				through );

typedef struct ScanDocumentFonts
    {
    DocListObjectFonts	sdfListObjectFonts;
    DocListSpanFont	sdfDocListSpanFont;
    void *		sdfThrough;
    } ScanDocumentFonts;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int docListDocumentFonts(	BufferDocument *		bd,
					ScanDocumentFonts *		sdf );

#   endif	/*  DOC_LIST_FONTS_H	*/
