/************************************************************************/
/*									*/
/*  Manage fields.							*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<limits.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>
#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Find the inner most field for a particular position.		*/
/*									*/
/************************************************************************/

DocumentField * docFindFieldForPosition(
				BufferDocument *		bd,
				const DocumentPosition *	dp )
    {
    EditPosition	ep;
    DocumentTree *	ei;
    BufferItem *	bodySectBi;
    const int		lastOne= 0;

    docSetEditPosition( &ep, dp->dpBi, dp->dpStroff );

    if  ( docGetRootForItem( &ei, &bodySectBi, bd, dp->dpBi ) )
	{ LDEB(1); return (DocumentField *)0;	}

    return docFindChildField( &(ei->eiRootFields), &ep, lastOne );
    }

DocumentField * docFindTypedFieldForPosition(
				BufferDocument *		bd,
				const DocumentPosition *	dp,
				int				kind )
    {
    EditPosition	ep;
    DocumentTree *	ei;
    BufferItem *	bodySectBi;
    DocumentField *	dfInner;
    const int		lastOne= 0;

    docSetEditPosition( &ep, dp->dpBi, dp->dpStroff );

    if  ( docGetRootForItem( &ei, &bodySectBi, bd, dp->dpBi ) )
	{ LDEB(1); return (DocumentField *)0;	}

    dfInner= docFindChildField( &(ei->eiRootFields), &ep, lastOne );

    while( dfInner && docEditPositionInField( dfInner, &ep ) )
	{
	DocumentField *	df= dfInner;

	while( df )
	    {
	    if  ( df->dfKind == kind )
		{ return df;	}

	    df= df->dfParent;
	    }

	dfInner= docGetNextField( &(ei->eiRootFields), dfInner );
	}

    return (DocumentField *)0;
    }

/************************************************************************/
/*									*/
/*  Suggest a bookmark name that matches the text in a selection.	*/
/*									*/
/************************************************************************/

int docSuggestNewBookmarkName(	char *				markName,
				const BufferDocument *		bd,
				const DocumentSelection *	ds )
    {
    int			rval= 0;
    const BufferItem *	paraBi= ds->dsHead.dpBi;
    int			stroff= ds->dsHead.dpStroff;
    int			markSize= 0;

    markName[0]= '\0';

    if  ( paraBi )
	{
	unsigned char *	s= docParaString( paraBi, stroff );
	unsigned char *	e;
	unsigned char *	p;

	int		stroffTail;

	if  ( paraBi == ds->dsTail.dpBi )
	    { stroffTail= ds->dsTail.dpStroff;	}
	else{ stroffTail= docParaStrlen( paraBi );	}

	while( stroff < stroffTail	&&
	       ! isalnum( *s )		)
	    { s++; stroff++;	}

	p= e= s;
	while( stroff < stroffTail )
	    {
	    if  ( isalnum( *e ) )
		{ p= e+ 1;	}

	    e++; stroff++;
	    }

	if  ( p- s > DOCmaxBOOKMARK )
	    { p= s+ DOCmaxBOOKMARK;	}

	if  ( p- s > 3 )
	    { strncpy( markName, (char *)s, p- s )[p- s]= '\0';		}
	else{ strcpy( markName, "bkmk" ); p= s+ 4;		 	}

	docAdaptBookmarkName( &markSize, markName );

	if  ( docMakeBookmarkUnique( bd, markName, markSize ) )
	    { LDEB(1); return -1;	}

	rval= 1;
	}

    return rval;
    }

/************************************************************************/

int docMakeBookmarkUnique(	const BufferDocument *	bd,
				char *			markName,
				int			markSize )
    {
    DocumentField *	df;

    if  ( docGetBookmarkField( &df, &(bd->bdFieldList),
						markName, markSize ) >= 0 )
	{
	int		i;

	if  ( markSize+ 8 > DOCmaxBOOKMARK )
	    { markSize= DOCmaxBOOKMARK- 8;	}

	markSize += 8;

	for ( i= 0; i < 100000000; i++ )
	    {
	    sprintf( markName+ markSize- 8, "%08d", i );

	    if  ( docGetBookmarkField( &df, &(bd->bdFieldList),
					    markName, markSize ) < 0 )
		{ return 0;	}
	    }

	LDEB(i); return -1;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Derive field kind from field instructions.				*/
/*									*/
/************************************************************************/

int docFieldKindFromInstructions(	const DocumentField *	df )
    {
    unsigned char *			s= df->dfInstructions.mbBytes;
    int					n= df->dfInstructions.mbSize;

    unsigned char *			p;
    int					i;
    const FieldKindInformation *	fki;

    i= 0;
    while( i < n && isspace( *s ) )
	{ i++; s++;	}
    /* Cope with OpenOffice that inserts backslashes before the instructions */
    while( i < n && *s == '\\' )
	{ i++; s++;	}

    p= s;
    while( i < n && isalpha( *p ) )
	{
	if  ( islower( *p ) )
	    { *p= toupper( *p );	}
	i++; p++;
	}

    if  ( DOC_FieldKindCount != DOCfk_COUNT )
	{ LLDEB(DOC_FieldKindCount,DOCfk_COUNT); return -1;	}

    /* LSDEB(p-s,(char *)s); */

    fki= DOC_FieldKinds;
    for ( i= 0; i < DOC_FieldKindCount; fki++, i++ )
	{
	if  ( ! fki->fkiIsFieldInRtf )
	    { continue;	}

	if  ( ! strncmp( (const char *)s, fki->fkiLabel, p- s )	&&
	      ! fki->fkiLabel[p- s]				)
	    { break;	}
	}

    if  ( i < DOC_FieldKindCount )
	{ return i;	}
    
    return -1;
    }

/************************************************************************/
/*									*/
/*  Shift fields in an edit operation.					*/
/*  NOTE that we depend on the paragraph number only for shiftin the	*/
/*  section number: Only the body has more than one section and there	*/
/*  is a colose relationship in that case.				*/
/*									*/
/************************************************************************/

static void docShiftFieldStart(		DocumentField *		df,
					int			sectFrom,
					int			paraFrom,
					int			stroffFrom,
					int			sectShift,
					int			paraShift,
					int			stroffShift )
    {
    /*  earlier paragraph  */
    if  ( df->dfHeadPosition.epParaNr < paraFrom )
	{ return;	}

    /*  later paragraph  */
    if  ( df->dfHeadPosition.epParaNr > paraFrom )
	{
	df->dfHeadPosition.epParaNr += paraShift;
	if  ( df->dfSelectionScope.ssInExternalItem == DOCinBODY )
	    { df->dfSelectionScope.ssSectNr += sectShift;	}

	return;
	}

    /* Same paragraph */
    if  ( df->dfHeadPosition.epStroff < stroffFrom )
	{ return;	}
    if  ( df->dfHeadPosition.epStroff > stroffFrom )
	{
	df->dfHeadPosition.epParaNr += paraShift;
	df->dfHeadPosition.epStroff += stroffShift;
	if  ( df->dfSelectionScope.ssInExternalItem == DOCinBODY )
	    { df->dfSelectionScope.ssSectNr += sectShift;	}

	return;
	}

    return;
    }

static void docShiftFieldEnd(		DocumentField *		df,
					int			sectFrom,
					int			paraFrom,
					int			stroffFrom,
					int			sectShift,
					int			paraShift,
					int			stroffShift )
    {
    /*  earlier paragraph  */
    if  ( df->dfTailPosition.epParaNr < paraFrom )
	{ return;	}

    /*  later paragraph  */
    if  ( df->dfTailPosition.epParaNr > paraFrom )
	{
	df->dfTailPosition.epParaNr += paraShift;
	if  ( df->dfSelectionScope.ssInExternalItem == DOCinBODY )
	    { df->dfSelectionScope.ssSectNr += sectShift;	}

	return;
	}

    /* Same paragraph */
    if  ( df->dfTailPosition.epStroff < stroffFrom )
	{ return;	}
    if  ( df->dfTailPosition.epStroff > stroffFrom )
	{
	df->dfTailPosition.epParaNr += paraShift;
	df->dfTailPosition.epStroff += stroffShift;
	if  ( df->dfSelectionScope.ssInExternalItem == DOCinBODY )
	    { df->dfSelectionScope.ssSectNr += sectShift;	}

	return;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Shift fields.							*/
/*									*/
/************************************************************************/

static void docShiftChildFieldReferences(
					const ChildFields *	cf,
					int			sectFrom,
					int			paraFrom,
					int			stroffFrom,
					int			sectShift,
					int			paraShift,
					int			stroffShift )
    {
    int			l;
    int			r;
    int			m;

    DocumentField *	df;

    if  ( cf->cfChildCount == 0 )
	{ return;	}

    l= 0; r= cf->cfChildCount; m= ( l+ r )/ 2;
    while( l < m )
	{
	df= cf->cfChildren[m];

	if  ( df->dfTailPosition.epParaNr < paraFrom )
	    { l= m;	}
	else{ r= m;	}

	m= ( l+ r )/ 2;
	}

    df= cf->cfChildren[m];
    if  ( df->dfTailPosition.epParaNr < paraFrom )
	{ m++;	}

    for ( m= m; m < cf->cfChildCount; m++ )
	{
	DocumentField *	dfc= cf->cfChildren[m];

	if  ( dfc->dfFieldNumber < 0 )
	    { LDEB(dfc->dfFieldNumber); continue;	}

	if  ( dfc->dfSelectionScope.ssInExternalItem == DOCinBODY	&&
	      dfc->dfSelectionScope.ssOwnerSectNr >= 0			&&
	      dfc->dfSelectionScope.ssOwnerSectNr > sectFrom		)
	    { dfc->dfSelectionScope.ssOwnerSectNr += sectShift;		}

	docShiftFieldStart( dfc, sectFrom, paraFrom, stroffFrom,
					sectShift, paraShift, stroffShift );
	docShiftFieldEnd( dfc, sectFrom, paraFrom, stroffFrom,
					sectShift, paraShift, stroffShift );

	if  ( dfc->dfChildFields.cfChildCount > 0 )
	    {
	    docShiftChildFieldReferences( &(dfc->dfChildFields),
					sectFrom, paraFrom, stroffFrom,
					sectShift, paraShift, stroffShift );
	    }
	}

    return;
    }

void docShiftFieldReferences(		DocumentTree *		ei,
					int			sectFrom,
					int			paraFrom,
					int			stroffFrom,
					int			sectShift,
					int			paraShift,
					int			stroffShift )
    {
    /*
    appDebug( "docShiftFieldReferences( ..,"
		" para:%d+%d, stroff:%d+%d )\n",
	    paraFrom, paraShift, stroffFrom, stroffShift );
    */

    /*  1  */
    if  ( paraFrom < 1 )
	{ LDEB(paraFrom); return;	}

    docShiftChildFieldReferences( &(ei->eiRootFields),
					sectFrom, paraFrom, stroffFrom,
					sectShift, paraShift, stroffShift );
    return;
    }

