/************************************************************************/
/*									*/
/*  Evaluate fields+ the list of kinds of fields.			*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"
#   include	"docEvalField.h"

/************************************************************************/
/*									*/
/*  The Kinds of Fields actively supported.				*/
/*									*/
/************************************************************************/

#   define	NOT_IN_RTF	0
#   define	FIELD_IN_RTF	1

#   define	NO_DEST		0
#   define	DEST_IN_RTF	1

#   define	RESULT_READONLY	0
#   define	RESULT_EDITABLE	1

const FieldKindInformation DOC_FieldKinds[]=
{
    {
	"-UNKNOWN",
		DOClevANY,
		NOT_IN_RTF,
		NO_DEST,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_READONLY,
    },
    {
	"HYPERLINK",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateHyperlinkField,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoDOC_COMPLETE, /* Must Be: FIELDdoNEVER, */
		RESULT_EDITABLE,
    },
    {
	"-XE",
		DOClevSPAN,
		NOT_IN_RTF,
		DEST_IN_RTF,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_READONLY,
		"\\xe",
    },
    {
	"-TC",
		DOClevSPAN,
		NOT_IN_RTF,
		NO_DEST,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_READONLY,
		"\\tc",
    },
    {
	"-TCN",
		DOClevSPAN,
		NOT_IN_RTF,
		NO_DEST,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_READONLY,
		"\\tcn",
    },
    {
	"-BOOKMARK",
		DOClevCELL,
		NOT_IN_RTF,
		NO_DEST,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_EDITABLE,
    },
    {
	"SECTION",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateSectionFieldString,
		FIELDdoDOC_FORMATTED,
		RESULT_READONLY,
    },
    {
	"SECTIONPAGES",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateSectionPagesFieldString,
		FIELDdoDOC_FORMATTED,
		RESULT_READONLY,
    },
    {
	"PAGE",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculatePageFieldString,
		FIELDdoPAGE_NUMBER,
		RESULT_READONLY,
    },
    {
	"PAGEREF",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculatePagerefFieldString,
		FIELDdoDOC_FORMATTED,
		RESULT_READONLY,
    },
    {
	"NUMPAGES",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateNumpagesFieldString,
		FIELDdoDOC_FORMATTED,
		RESULT_READONLY,
    },
    {
	"REF",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateRefFieldString,
		FIELDdoDOC_COMPLETE,
		RESULT_READONLY,
    },
    {
	"CREATEDATE",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocDateFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"SAVEDATE",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocDateFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"PRINTDATE",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocDateFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"DATE",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocDateFieldString,
		FIELDdoDOC_COMPLETE,
		RESULT_READONLY,
    },
    {
	"TIME",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocDateFieldString,
		FIELDdoDOC_COMPLETE,
		RESULT_READONLY,
    },
    {
	"AUTHOR",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocStringFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"COMMENTS",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocStringFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"DOCCOMM",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocStringFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"KEYWORDS",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocStringFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"SUBJECT",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocStringFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"TITLE",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocStringFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"FILENAME",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateFilenameFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"MERGEFIELD",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateMergefieldFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"FORMTEXT",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_EDITABLE,
    },
    {
	"FORMCHECKBOX",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_EDITABLE,
    },
    {
	"SYMBOL",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaSymbolTextParticules,
		docCalculateSymbolFieldString,
		FIELDdoDOC_COMPLETE,
		RESULT_READONLY,
    },
    {
	"-CHFTN",
		DOClevSPAN,
		NOT_IN_RTF,
		NO_DEST,
		docRecalculateParaChftnTextParticules,
		docCalculateChftnFieldString,
		FIELDdoDOC_COMPLETE|FIELDdoCHFTN,
		RESULT_READONLY,
    },
    {
	"-CHATN",
		DOClevSPAN,
		NOT_IN_RTF,
		NO_DEST,
		docRecalculateParaChftnTextParticules,
		docCalculateChftnFieldString,
		FIELDdoDOC_COMPLETE|FIELDdoCHFTN,
		RESULT_READONLY,
    },
    {
	"-LISTTEXT",
		DOClevSPAN,
		NOT_IN_RTF,
		NO_DEST,
		docRecalculateParaListtextTextParticules,
		docCalculateDocStringFieldString, /* as dummy */
		FIELDdoDOC_COMPLETE|FIELDdoLISTTEXT,
		RESULT_READONLY,
    },
    {
	"INCLUDEPICTURE",
		DOClevSPAN,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateIncludePictureField,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoDOC_COMPLETE,
		RESULT_READONLY,
    },
    {
	"TOC",
		DOClevCELL,
		FIELD_IN_RTF,
		NO_DEST,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_READONLY,
    },
};

const int DOC_FieldKindCount=
			sizeof(DOC_FieldKinds)/sizeof(FieldKindInformation);

