/************************************************************************/
/*									*/
/*  Buffer administration for 'ExternalItems' I.E. headers/footers and	*/
/*  foonotes/endnotes.							*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Kinds of Headers/Footers.						*/
/*									*/
/*  The arrays are a mapping from the options to the header/footer data	*/
/*  structure that is used in the implementation.			*/
/*									*/
/************************************************************************/

const int DOC_HeaderScopes[PAGES__COUNT]=
    {
    DOCinFIRST_HEADER,	/*  PAGES_FIRST_PAGE		*/
    DOCinRIGHT_HEADER,	/*  PAGES_SUBSEQUENT_PAGES	*/
    DOCinRIGHT_HEADER,	/*  PAGES_ALL_PAGES		*/
    DOCinRIGHT_HEADER,	/*  PAGES_ODD_PAGES		*/
    DOCinLEFT_HEADER,	/*  PAGES_EVEN_PAGES		*/
    };

const int DOC_FooterScopes[PAGES__COUNT]=
    {
    DOCinFIRST_FOOTER,	/*  PAGES_FIRST_PAGE		*/
    DOCinRIGHT_FOOTER,	/*  PAGES_SUBSEQUENT_PAGES	*/
    DOCinRIGHT_FOOTER,	/*  PAGES_ALL_PAGES		*/
    DOCinRIGHT_FOOTER,	/*  PAGES_ODD_PAGES		*/
    DOCinLEFT_FOOTER,	/*  PAGES_EVEN_PAGES		*/
    };

/************************************************************************/
/*									*/
/*  Initialise an DocumentTree.						*/
/*									*/
/************************************************************************/

void docInitExternalItem(	DocumentTree *	ei )
    {
    ei->eiRoot= (BufferItem *)0;
    ei->eiPageFormattedFor= -1;
    ei->eiColumnFormattedFor= -1;

    ei->eiY0UsedTwips= 0;
    ei->eiY1UsedTwips= 0;
    ei->eiY0ReservedTwips= 0;
    ei->eiY1ReservedTwips= 0;

    ei->eiPageSelectedUpon= -1;
    ei->eiColumnSelectedIn= -1;

    docInitListNumberTrees( &(ei->eiListNumberTrees) );
    docInitListNumberTreeNode( &(ei->eiOutlineTree) );

    docInitChildFields( &(ei->eiRootFields) );
    return;
    }

void docCleanExternalItem(	BufferDocument *	bd,
				DocumentTree *		ei )
    {
    int		bulletsDeleted= 0;
    int		notesDeleted= 0;

    if  ( ei->eiRoot )
	{ docDeleteExternalItem( bd, ei );	}

    docDeleteChildFields( &bulletsDeleted, &notesDeleted, bd,
							&(ei->eiRootFields) );

    docCleanListNumberTrees( &(ei->eiListNumberTrees) );
    docCleanListNumberTreeNode( &(ei->eiOutlineTree) );

    return;
    }

/************************************************************************/
/*  									*/
/*  Keep track of the hierarchy of fields in this tree.			*/
/*  									*/
/************************************************************************/

int docExternalItemAddRootField(	DocumentTree *		ei,
					DocumentField *		dfCh )
    {
    if  ( docInsertChildField( (DocumentField *)0,
					    &(ei->eiRootFields), dfCh ) )
	{ LDEB(1); return -1;	}

    dfCh->dfParent= (DocumentField *)0;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Make a new 'External Item' E.G. A section Header/Footer or a	*/
/*  Footnote/Endnote.							*/
/*									*/
/************************************************************************/

int docMakeExternalItem(	BufferDocument *		bd,
				DocumentTree *			ei,
				const SelectionScope *		ss,
				const SectionProperties *	sp )
    {
    BufferItem *	bi= (BufferItem *)0;
    const int		numberInParent= 0;

    bi= (BufferItem *)malloc( sizeof(BufferItem) );
    if  ( ! bi )
	{ XDEB(bi); return -1;	}

    docInitItem( bi, (BufferItem *)0, bd, numberInParent,
					DOClevSECT, ss->ssInExternalItem );

    if  ( docCopySectionProperties( &(bi->biSectProperties), sp ) )
	{ LDEB(1); docFreeItem( bd, ei, bi ); return -1; }

    bi->biSectBreakKind= DOCibkNONE;
    bi->biSectSelectionScope= *ss;
    ei->eiRoot= bi;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Make an external item and insert an empty paragraph into it.	*/
/*									*/
/************************************************************************/

BufferItem * docMakeExternalParagraph(
			BufferDocument *		bd,
			DocumentTree *			ei,
			const BufferItem *		bodyBi,
			int				textAttributeNumber,
			int				ownerNumber,
			int				inExtIt )
    {
    BufferItem *		paraBi= (BufferItem *)0;
    BufferItem *		sectBi= (BufferItem *)0;

    sectBi= docMakeExternalSection( bd, ei, bodyBi, ownerNumber, inExtIt );
    if  ( ! sectBi )
	{ XDEB(sectBi); return (BufferItem *)0;	}

    paraBi= docInsertEmptyParagraph( bd, ei->eiRoot, textAttributeNumber );
    if  ( ! paraBi )
	{
	XDEB(paraBi);
	docCleanExternalItem( bd, ei );
	docInitExternalItem( ei );
	}

    return paraBi;
    }

BufferItem * docMakeExternalSection(
			BufferDocument *		bd,
			DocumentTree *			ei,
			const BufferItem *		bodyBi,
			int				ownerNumber,
			int				inExtIt )
    {
    SectionProperties		spDef;

    int				numberInParent= -1;
    SelectionScope		ss;

    docInitSelectionScope( &ss );
    docInitSectionProperties( &spDef );

    switch( inExtIt )
	{
	case DOCinBODY:
	    LDEB(inExtIt); goto ready;

	case DOCinFIRST_HEADER:
	case DOCinLEFT_HEADER:
	case DOCinRIGHT_HEADER:
	case DOCinFIRST_FOOTER:
	case DOCinLEFT_FOOTER:
	case DOCinRIGHT_FOOTER:

	    bodyBi= docGetSectItem( (BufferItem *)bodyBi );
	    if  ( ! bodyBi )
		{ XDEB(bodyBi); goto ready;	}

	    numberInParent= bodyBi->biNumberInParent;
	    break;

	case DOCinFOOTNOTE:
	case DOCinENDNOTE:

	    bodyBi= docGetSectItem( (BufferItem *)bodyBi );
	    if  ( ! bodyBi )
		{ XDEB(bodyBi); goto ready;	}

	    numberInParent= bodyBi->biNumberInParent;
	    break;

	case DOCinFTNSEP:
	case DOCinFTNSEPC:
	case DOCinFTNCN:

	case DOCinAFTNSEP:
	case DOCinAFTNSEPC:
	case DOCinAFTNCN:

	    break;

	default:
	    LDEB(inExtIt); goto ready;
	}


    ss.ssInExternalItem= inExtIt;
    ss.ssSectNr= 0;
    ss.ssOwnerSectNr= numberInParent;
    ss.ssOwnerNumber= ownerNumber;

    if  ( docMakeExternalItem( bd, ei, &ss, &spDef ) )
	{ XDEB(ei->eiRoot); goto ready;	}

    ei->eiPageFormattedFor= -1;
    ei->eiColumnFormattedFor= -1;
    ei->eiPageSelectedUpon= -1;
    ei->eiColumnSelectedIn= -1;

  ready:

    docCleanSectionProperties( &spDef );

    return ei->eiRoot;
    }

