/************************************************************************/
/*									*/
/*  Declare field evaluation routines.					*/
/*									*/
/************************************************************************/

#   ifndef	DOC_EVAL_FIELD_H
#   define	DOC_EVAL_FIELD_H

#   include	"docBuf.h"
#   include	"docRecalculateFields.h"

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int docFormatChftnField(	MemoryBuffer *			mbResult,
				const DocumentProperties *	dp,
				const NoteProperties *		np,
				int				noteNumber );

extern int docCalculateChftnFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf );

extern int docCalculateSymbolFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf );

extern int docCalculatePagerefFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf );

extern int docCalculateSectionFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf );

extern int docCalculateSectionPagesFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf );

extern int docCalculatePageFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf );

extern int docCalculateNumpagesFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf );

extern int docCalculateDocDateFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf );

extern int docCalculateDocStringFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf );

extern int docCalculateFilenameFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf );

extern int docCalculateMergefieldFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf );

extern int docCalculateRefFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf );

extern int docRecalculateHyperlinkField(
				int *				pCalculated,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			paraBi,
				int				part,
				int				partCount,
				DocumentField *			df,
				const RecalculateFields *	rf );

extern int docRecalculateIncludePictureField(
				int *				pCalculated,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			paraBi,
				int				part,
				int				partCount,
				DocumentField *			df,
				const RecalculateFields *	rf );

extern int docRecalculateParaStringTextParticules(
				int *				pCalculated,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			paraBi,
				int				part,
				int				partCount,
				DocumentField *			df,
				const RecalculateFields *	rf );

extern int docRecalculateParaChftnTextParticules(
				int *				pCalculated,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			paraBi,
				int				part,
				int				partCount,
				DocumentField *			df,
				const RecalculateFields *	rf );

extern int docRecalculateParaListtextTextParticules(
				int *				pCalculated,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			paraBi,
				int				part,
				int				partCount,
				DocumentField *			df,
				const RecalculateFields *	rf );

extern int docRecalculateParaSymbolTextParticules(
				int *				pCalculated,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			paraBi,
				int				part,
				int				partCount,
				DocumentField *			df,
				const RecalculateFields *	rf );

extern int docFieldReplaceContents(
				int *				pStroff,
				int *				pStroffShift,
				int *				pTextAttrNr,
				BufferItem *			paraBi,
				int				part,
				int				partCount,
				int				stroffShift,
				const char *			addedString,
				int				addedStrlen,
				const RecalculateFields *	rf );

extern int docRecalculateTextLevelFields(	RecalculateFields *	rf,
						struct BufferItem *	bi );

extern int docRecalculateTextLevelFieldsInExternalItem(
				    RecalculateFields *		rf,
				    DocumentTree *		ei,
				    const struct BufferItem *	sectBi,
				    int				page );

#   endif	/*  DOC_EVAL_FIELD_H  */
