/************************************************************************/
/*									*/
/*  Buffer manipulation routines.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>

#   include	"docBuf.h"
#   include	"docEdit.h"

/************************************************************************/
/*									*/
/*  Update paragraph properties and do extra administration.		*/
/*									*/
/************************************************************************/

int docEditUpdParaProperties(	EditOperation *			eo,
				PropertyMask *			pPpDoneMask,
				BufferItem *			paraBi,
				const PropertyMask *		ppSetMask,
				const ParagraphProperties *	ppNew,
				const DocumentAttributeMap *	dam )
    {
    BufferDocument *		bd= eo->eoBd;

    int				wasInList= 0;
    int				isInList= 0;
    int				listChange= 0;

    int				ls= -1;
    int				ilvl= 0;

    int				olevel;

    PropertyMask		ppDoneMask;
    PropertyMask		ppSetMaskThisPara;

    DocumentField *		dfBullet= (DocumentField *)0;
    DocumentSelection		dsInsideBullet;
    DocumentSelection		dsAroundBullet;
    int				partBulletHead= -1;
    int				partBulletTail= -1;

    int				paraNr= -1;

    ppSetMaskThisPara= *ppSetMask;

    utilPropMaskClear( &ppDoneMask );

    /*  A  */
    if  ( paraBi->biParaListOverride > 0 )
	{
	wasInList= 1;
	ls= paraBi->biParaListOverride;
	ilvl= paraBi->biParaListLevel;

	if  ( docDelimitParaHeadField( &dfBullet,
			    &dsInsideBullet, &dsAroundBullet,
			    &partBulletHead, &partBulletTail, paraBi, bd ) )
	    { /* LDEB(paraBi->biParaListOverride); */	}

	PROPmaskUNSET( &ppSetMaskThisPara, PPpropLEFT_INDENT );
	PROPmaskUNSET( &ppSetMaskThisPara, PPpropFIRST_INDENT );
	}

    olevel= paraBi->biParaOutlineLevel;

    if  ( ! utilPropMaskIsEmpty( &ppSetMaskThisPara ) )
	{
	if  ( docUpdParaProperties( &ppDoneMask, &(paraBi->biParaProperties),
					&ppSetMaskThisPara, ppNew, dam ) )
	    { LDEB(1); return -1;	}
	}

    if  ( paraBi->biParaListOverride > 0 )
	{ isInList= 1;	}

    if  ( wasInList || isInList )
	{ paraNr= docNumberOfParagraph( paraBi );	}

    if  ( wasInList && ! isInList )
	{
	DocumentPosition	dpTail;
	int			partTail;

	if  ( docListNumberTreesDeleteParagraph(
				&(eo->eoEi->eiListNumberTrees), ls, paraNr ) )
	    { /*LLDEB(override,paraNr);*/	}

	if  ( dfBullet )
	    { docDeleteFieldFromDocument( bd, dfBullet );	}

	if  ( docParaDeleteText( eo, &dpTail, &partTail,
			    paraNr, &(dsAroundBullet.dsHead), partBulletHead,
			    dsAroundBullet.dsTail.dpStroff, partBulletTail ) )
	    { LDEB(1); return -1;	}

	eo->eoFieldUpdate |= FIELDdoLISTTEXT;
	eo->eoBulletsChanged++;
	}

    if  ( ! wasInList && isInList )
	{
	if  ( docInsertListtextField( &dfBullet,
					&dsInsideBullet, &dsAroundBullet,
					&partBulletHead, &partBulletTail,
					paraBi, eo->eoEi, bd ) )
	    { LDEB(1); return -1;	}

	listChange= 1;
	eo->eoFieldUpdate |= FIELDdoLISTTEXT;
	eo->eoBulletsChanged++;
	}

    if  ( wasInList					&&
	  isInList					&&
	  ( paraBi->biParaListOverride != ls	||
	    paraBi->biParaListLevel != ilvl	)	)
	{
	if  ( docListNumberTreesDeleteParagraph(
				&(eo->eoEi->eiListNumberTrees), ls, paraNr ) )
	    { LLDEB(ls,paraNr);	}

	ls= paraBi->biParaListOverride;
	ilvl= paraBi->biParaListLevel;

	if  ( docListNumberTreesInsertParagraph(
			&(eo->eoEi->eiListNumberTrees), ls, ilvl, paraNr ) )
	    { LLLDEB(ls,ilvl,paraNr);	}

	listChange= 1;
	eo->eoFieldUpdate |= FIELDdoLISTTEXT;
	eo->eoBulletsChanged++;
	}

    if  ( paraBi->biParaOutlineLevel != olevel )
	{
	if  ( olevel < PPoutlineBODYTEXT )
	    {
	    if  ( docListNumberTreeDeleteParagraph(
					&(eo->eoEi->eiOutlineTree), paraNr ) )
		{ LDEB(paraNr);	}
	    }

	if  ( paraBi->biParaOutlineLevel < PPoutlineBODYTEXT )
	    {
	    if  ( docListNumberTreeInsertParagraph(
					&(eo->eoEi->eiOutlineTree),
					paraBi->biParaOutlineLevel, paraNr ) )
		{ LDEB(paraNr);	}
	    }
	}

    if  ( listChange )
	{
	int		indentChanged= 0;

	if  ( docAdaptParagraphToListLevel( &indentChanged, paraBi, bd ) )
	    { LDEB(1);		}
	}

    if  ( paraBi->biParaTableNesting > 0	&&
	  paraBi->biNumberInParent == 0		)
	{ docEditAdaptRowPropertiesToFirstChild( eo, paraBi );	}

    *pPpDoneMask= ppDoneMask;
    return 0;
    }

void docEditAdaptRowPropertiesToFirstChild(	EditOperation *		eo,
						const BufferItem *	paraBi )
    {
    if  ( paraBi->biParaTableNesting > 0	&&
	  paraBi->biNumberInParent == 0		)
	{
	BufferItem *	cellBi= paraBi->biParent;

	if  ( cellBi->biNumberInParent == 0 )
	    {
	    BufferItem *	rowBi= cellBi->biParent;

	    if  ( rowBi->biRow_Keepfollow != paraBi->biParaKeepWithNext )
		{
		rowBi->biRow_Keepfollow= paraBi->biParaKeepWithNext;
		docEditIncludeItemInReformatRange( eo, rowBi );
		}
	    }
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Set the properties of a table row.					*/
/*									*/
/*  1)  Adapt to an explicit \trkeepfollow.				*/
/*  2)  Adapt to an implicit \trkeepfollow.				*/
/*									*/
/************************************************************************/

int docChangeRowProperties(	PropertyMask *			rpDoneMask,
				BufferItem *			rowBi,
				const PropertyMask *		rpSetMask,
				const RowProperties *		rpSet )
    {
    RowProperties *		rpTo= &(rowBi->biRowProperties);

    DocumentPosition		dp;

    if  ( docUpdRowProperties( rpDoneMask, rpTo, rpSetMask, rpSet,
					(const DocumentAttributeMap *)0 ) )
	{ LDEB(1);	}

    if  ( ! docFirstPosition( &dp, rowBi ) )
	{
	BufferItem *	paraBi= dp.dpBi;

	/*  1  */
	if  ( PROPmaskISSET( rpSetMask, RPprop_KEEPFOLLOW ) )
	    { paraBi->biParaKeepWithNext= rpTo->rp_Keepfollow;	}

	/*  2  */
	rpTo->rp_Keepfollow= paraBi->biParaKeepWithNext;
	}

    return 0;
    }

