/************************************************************************/
/*									*/
/*  Buffer administration for 'ExternalItems' I.E. headers/footers and	*/
/*  foonotes/endnotes.							*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"
#   include	"docEdit.h"

/************************************************************************/
/*									*/
/*  Copy a note from one paragraph to another.				*/
/*									*/
/************************************************************************/

int docCopyNote(		DocumentCopyJob *	dcj,
				DocumentField *		dfTo,
				const DocumentField *	dfFrom )
    {
    EditOperation *		eo= dcj->dcjEditOperation;
    BufferDocument *		bdTo= eo->eoBd;

    DocumentNote *		dnTo;
    DocumentNote *		dnFrom;

    dnFrom= docGetNoteOfField( dfFrom, dcj->dcjBdFrom );

    dfTo->dfNoteIndex= docInsertNote( &dnTo, bdTo, dfTo,
				    dnFrom->dnNoteProperties.npAutoNumber );
    if  ( dfTo->dfNoteIndex < 0 )
	{ LDEB(dfTo->dfNoteIndex); return -1;	}

    /* realloc */
    dnFrom= docGetNoteOfField( dfFrom, dcj->dcjBdFrom );

    if  ( dnFrom->dnDocumentTree.eiRoot )
	{
	SelectionScope	ssRoot;

	docInitSelectionScope( &ssRoot );

	ssRoot.ssInExternalItem= dnFrom->dnNoteProperties.npExternalItemKind;
	ssRoot.ssSectNr= 0;
	ssRoot.ssOwnerSectNr= dfTo->dfSelectionScope.ssSectNr;
	ssRoot.ssOwnerNumber= dfTo->dfFieldNumber;

	if  ( docCopyDocumentTree( dcj, &(dnTo->dnDocumentTree), &ssRoot,
					    dnFrom->dnDocumentTree.eiRoot ) )
	    { XDEB(dnTo->dnDocumentTree.eiRoot); return -1;	}
	}

    dnTo->dnNoteProperties.npExternalItemKind=
				dnFrom->dnNoteProperties.npExternalItemKind;

    switch( dnTo->dnNoteProperties.npExternalItemKind )
	{
	case DOCinFOOTNOTE:
	    if  ( docCheckNoteSeparatorItem( bdTo, DOCinFTNSEP ) )
		{ LDEB(dnTo->dnNoteProperties.npExternalItemKind); return -1; }
	    break;

	case DOCinENDNOTE:
	    if  ( docCheckNoteSeparatorItem( bdTo, DOCinAFTNSEP ) )
		{ LDEB(dnTo->dnNoteProperties.npExternalItemKind); return -1; }
	    break;

	default:
	    LDEB(dnFrom->dnNoteProperties.npExternalItemKind);
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Copy a shape.							*/
/*									*/
/*  1)  Children.							*/
/*  2)  Vertices.							*/
/*  2)  Wrap polygon.							*/
/*  4)  Segment information						*/
/*  5)  Text box content.						*/
/*									*/
/************************************************************************/

DrawingShape * docCopyDrawingShape(
				DocumentCopyJob *	dcj,
				const DrawingShape *	from )
    {
    DrawingShape *	rval= (DrawingShape *)0;
    DrawingShape *	to;
    int			saveNumber;

    to= docClaimDrawingShape( &(dcj->dcjEditOperation->eoBd->bdShapeList) );
    if  ( ! to )
	{ XDEB(to); goto ready;	}

    saveNumber= to->dsShapeNumber;
    *to= *from;
    docInitShapeAllocated( to );
    to->dsShapeNumber= saveNumber;

    /*  1  */
    to->dsChildren= malloc( from->dsChildCount* sizeof(DrawingShape *) );
    if  ( ! to->dsChildren )
	{ LXDEB(from->dsChildCount,to->dsChildren); goto ready;	}

    /*  2  */
    to->dsVertices= malloc( from->dsVertexCount* sizeof(ShapeVertex *) );
    if  ( ! to->dsVertices )
	{ LXDEB(from->dsVertexCount,to->dsVertices); goto ready;	}

    /*  3  */
    to->dsWrapPolygonVertices= malloc(
			from->dsWrapPolygonVertexCount* sizeof(ShapeVertex *) );
    if  ( ! to->dsWrapPolygonVertices )
	{
	LXDEB(from->dsWrapPolygonVertexCount,to->dsWrapPolygonVertices);
	goto ready;
	}

    /*  4  */
    to->dsSegmentInfos= malloc( from->dsSegmentInfoCount* sizeof(int) );
    if  ( ! to->dsSegmentInfos )
	{ LXDEB(from->dsSegmentInfoCount,to->dsSegmentInfos); goto ready; }

    /*  1  */
    while( to->dsChildCount < from->dsChildCount )
	{
	to->dsChildren[to->dsChildCount]= docCopyDrawingShape( dcj,
					from->dsChildren[to->dsChildCount] );
	if  ( ! to->dsChildren[to->dsChildCount] )
	    {
	    LXDEB(to->dsChildCount,to->dsChildren[to->dsChildCount]);
	    goto ready;
	    }
	to->dsChildCount++;
	}

    /*  2  */
    while( to->dsVertexCount < from->dsVertexCount )
	{
	to->dsVertices[to->dsVertexCount]= from->dsVertices[to->dsVertexCount];
	to->dsVertexCount++;
	}

    /*  3  */
    while( to->dsWrapPolygonVertexCount < from->dsWrapPolygonVertexCount )
	{
	to->dsWrapPolygonVertices[to->dsWrapPolygonVertexCount]=
		    from->dsWrapPolygonVertices[to->dsWrapPolygonVertexCount];
	to->dsWrapPolygonVertexCount++;
	}

    /*  4  */
    while( to->dsSegmentInfoCount < from->dsSegmentInfoCount )
	{
	to->dsSegmentInfos[to->dsSegmentInfoCount]=
				from->dsSegmentInfos[to->dsSegmentInfoCount];
	to->dsSegmentInfoCount++;
	}

    /*  5  */
    if  ( from->dsDocumentTree.eiRoot )
	{
	SelectionScope	ssCopy;

	ssCopy= dcj->dcjSelectionScope;
	ssCopy.ssInExternalItem=
	    from->dsDocumentTree.eiRoot->biSectSelectionScope.ssInExternalItem;
	ssCopy.ssOwnerNumber= to->dsShapeNumber;

	if  ( docCopyDocumentTree( dcj, &(to->dsDocumentTree), &ssCopy,
						from->dsDocumentTree.eiRoot ) )
	    { XDEB(to->dsDocumentTree.eiRoot); goto ready;	}
	}

    rval= to; to= (DrawingShape *)0; /* steal */

  ready:

    if  ( to )
	{
	EditOperation *	eo= dcj->dcjEditOperation;

	docDeleteDrawingShape( eo->eoBd, to );
	}

    return rval;
    }

/************************************************************************/

static int docCopySectHdFt(	DocumentTree *		eiTo,
				BufferDocument *	bdTo,
				const BufferItem *	bodySectBi,
				BufferDocument *	bdFrom,
				const DocumentTree *	eiFrom,
				int			inExtIt )
    {
    int			rval= 0;

    EditOperation	eo;
    DocumentCopyJob	dcj;

    docInitDocumentCopyJob( &dcj );
    docInitEditOperation( &eo );

    docCleanExternalItem( bdTo, eiTo );
    docInitExternalItem( eiTo );

    if  ( eiFrom->eiRoot )
	{
	const int	ownerNumber= -1;
	BufferItem *	sectBi;

	sectBi= docMakeExternalSection( bdTo, eiTo,
					    bodySectBi, ownerNumber, inExtIt );
	if  ( ! sectBi )
	    { XDEB(sectBi); rval= -1; goto ready;	}

	eo.eoEi= eiTo;
	eo.eoBd= bdTo;
	eo.eoSelectionScope= sectBi->biSectSelectionScope;

	if  ( bdTo == bdFrom )
	    {
	    if  ( docSet1DocumentCopyJob( &dcj, &eo ) )
		{ LDEB(1); rval= -1; goto ready;	}

	    /*  Not a reorganisation but a copy:	*/
	    dcj.dcjCopyFields= 1;
	    }
	else{
	    if  ( docSet2DocumentCopyJob( &dcj, &eo, bdFrom, (char *)0 ) )
		{ LDEB(1); rval= -1; goto ready;	}
	    }

	if  ( docCopySectChildren( &dcj, sectBi, eiFrom->eiRoot ) )
	    { XDEB(sectBi); rval= -1; goto ready;	}
	}

  ready:

    docCleanDocumentCopyJob( &dcj );

    return rval;
    }

int docCopySectHeadersFooters(	BufferItem *		sectBiTo,
				BufferDocument *	bdTo,
				const BufferItem *	sectBiFrom,
				BufferDocument *	bdFrom )
    {
    if  ( docCopySectHdFt( &(sectBiTo->biSectFirstPageHeader),
		bdTo, sectBiTo, bdFrom,
		&(sectBiFrom->biSectFirstPageHeader), DOCinFIRST_HEADER ) )
	{ LDEB(1); return -1;	}
    if  ( docCopySectHdFt( &(sectBiTo->biSectLeftPageHeader),
		bdTo, sectBiTo, bdFrom,
		&(sectBiFrom->biSectLeftPageHeader), DOCinLEFT_HEADER ) )
	{ LDEB(1); return -1;	}
    if  ( docCopySectHdFt( &(sectBiTo->biSectRightPageHeader),
		bdTo, sectBiTo, bdFrom,
		&(sectBiFrom->biSectRightPageHeader), DOCinRIGHT_HEADER ) )
	{ LDEB(1); return -1;	}

    if  ( docCopySectHdFt( &(sectBiTo->biSectFirstPageFooter),
		bdTo, sectBiTo, bdFrom,
		&(sectBiFrom->biSectFirstPageFooter), DOCinFIRST_FOOTER ) )
	{ LDEB(1); return -1;	}
    if  ( docCopySectHdFt( &(sectBiTo->biSectLeftPageFooter),
		bdTo, sectBiTo, bdFrom,
		&(sectBiFrom->biSectLeftPageFooter), DOCinLEFT_FOOTER ) )
	{ LDEB(1); return -1;	}
    if  ( docCopySectHdFt( &(sectBiTo->biSectRightPageFooter),
		bdTo, sectBiTo, bdFrom,
		&(sectBiFrom->biSectRightPageFooter), DOCinRIGHT_FOOTER ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

