/************************************************************************/
/*									*/
/*  Document Editing.							*/
/*									*/
/************************************************************************/

#   ifndef		DOC_EDIT_H
#   define		DOC_EDIT_H

#   include		"docBuf.h"
#   include		"docEditOperation.h"
#   include		"docDocumentCopyJob.h"

/************************************************************************/
/*									*/
/*  Routine Declarations.						*/
/*									*/
/************************************************************************/

extern int docRollItemChildren(		EditOperation *		eo,
					BufferItem *		parentBi,
					int			from,
					int			to,
					int			by );

extern int docEditDeleteReplacedFields(
			EditOperation *			eo );

extern int docParaReplaceText(
			EditOperation *			eo,
			DocumentPosition *		dpTail,
			int *				pPartTail,
			int				paraNr,
			const DocumentPosition *	dpHead,
			int				partHead,
			unsigned int			stroffTail,
			int				partTail,
			const char *			addedText,
			unsigned int			addedLength,
			int				addedAttributeNumber );

extern int docParaDeleteText(
			EditOperation *			eo,
			DocumentPosition *		dpTail,
			int *				pPartTail,
			int				paraNr,
			const DocumentPosition *	dpHead,
			int				partHead,
			unsigned int			stroffTail,
			int				partTail );

extern int docParaInsertTail(
			DocumentCopyJob *		dcj,
			DocumentPosition *		dpTail,
			int *				pPartTail,
			int				paraNrTo,
			const DocumentPosition *	dpTo,
			int				partTo,
			const DocumentPosition *	dpFrom,
			int				partFrom );

extern int docSplitParaItem(	BufferItem **		pNewParaBi,
				EditOperation *		eo,
				int			splitLevel );

extern int docRemoveSelectionTail(
				EditOperation *			eo );

extern void docDeleteEmptyParents(	EditOperation *		eo,
					int *			pSectsDeleted,
					BufferItem *		bi );

extern void docEditDeleteItems(	EditOperation *		eo,
				int *			pSectionsDeleted,
				int *			pFirstParaDeleted,
				int *			pParagraphsDeleted,
				BufferItem *		bi,
				int			first,
				int			count );

extern TextParticule * docEditParaSpecialParticule(
					EditOperation *		eo,
					int			kind );

extern TextParticule * docParaSpecialParticule(
				EditOperation *			eo,
				int				kind,
				int *				pPartShift,
				int *				pStroffShift );

extern int docReplaceSelection(
			EditOperation *		eo,
			const char *		addedText,
			int			addedLength,
			int			addedAttributeNumber );

extern int docDeleteSelection(
			EditOperation *			eo );

extern int docMergeParagraphsInSelection(	EditOperation *	eo );

extern int docEditMakeParagraphEmpty(	BufferItem *		paraBi,
					EditOperation *		eo );

extern int docChangeParticuleAttributes(PropertyMask *		pTaAllMask,
					BufferDocument *	bd,
					BufferItem *		bi,
					int			part,
					int			partUpto,
					const TextAttribute *	taSet,
					const PropertyMask *	taSetMask );

extern int docCopyDocumentTree(		DocumentCopyJob *	dcj,
					DocumentTree *		eiTo,
					const SelectionScope *	ssRoot,
					const BufferItem *	sectBiFrom );

extern int docCopySectChildren(		DocumentCopyJob *	dcj,
					BufferItem *		sectBiTo,
					const BufferItem *	sectBiFrom );

extern int docCopyParticules(	DocumentCopyJob *	dcj,
				BufferItem *		biTo,
				const BufferItem *	biFrom,
				int			partTo,
				int			partFrom,
				int			countFrom,
				int *			pParticulesInserted,
				int *			pCharactersCopied );

extern int docCopyParticuleAndData(	TextParticule **	pTpTo,
					DocumentCopyJob *	dcj,
					BufferItem *		paraBiTo,
					int			partTo,
					int			stroffTo,
					int			strlenTo,
					const BufferItem *	paraBiFrom,
					const TextParticule *	tpFrom );

extern int docInsertTableRows(	DocumentPosition *	dpFirst,
				EditOperation *		eo,
				BufferItem *		sectBi,
				const BufferItem *	refRowBi,
				const RowProperties *	rp,
				int			textAttributeNumber,
				int			n,
				int			paraNr,
				int			rows );

extern void docFlattenRow(		BufferItem *		bi );

extern int docSplitColumnInRows(	BufferItem **	pNewParaBi,
					EditOperation *	eo,
					BufferItem *	sectBi,
					int		row0,
					int		row,
					int		row1,
					int		col,
					int		after );

extern void docChangeTableLayout(	EditOperation *		eo,
					BufferItem *		sectBi,
					int			row0,
					int			row1,
					int			col0,
					int			col1,
					const PropertyMask *	rpSetMask,
					const PropertyMask *	cpSetMask,
					const RowProperties *	rpSet );

extern int docDeleteColumnsFromRows(	EditOperation *		eo,
					BufferItem *		sectBi,
					int			delRow0,
					int			delRow1,
					int			delCol0,
					int			delCol1 );

extern int docChangeCellSpans(	int *			pRowChanged1,
				BufferItem *		parentBi,
				int			row0,
				int			col0,
				int			rowspan,
				int			colspan );

extern void docEditShiftReferences(	EditOperation *		eo,
					const SelectionScope *	ssRoot,
					int			paraFrom,
					int			stroffFrom,
					int			sectShift,
					int			paraShift,
					int			stroffShift );

extern void docEditAvoidDeletedParagraphs(
					EditOperation *		eo,
					const SelectionScope *	ssRoot,
					int			paraFrom,
					int			paraUpto );

extern int docEditUpdParaProperties(
				EditOperation *			eo,
				PropertyMask *			pPpChgPask,
				BufferItem *			paraBi,
				const PropertyMask *		ppUpdMask,
				const ParagraphProperties *	ppNew,
				const DocumentAttributeMap *	dam );

extern int docEditShiftParticuleOffsets( EditOperation *	eo,
					BufferItem *		paraBi,
					int			paraNr,
					int			partFrom,
					int			partUpto,
					int			stroffFrom,
					int			stroffShift );

extern int docEditCleanParticules(	EditOperation *		eo,
					BufferItem *		paraBi,
					int			partFrom,
					int			partUpto );

extern int docCopyNote(			DocumentCopyJob *	dcj,
					DocumentField *		dfTo,
					const DocumentField *	dfFrom );

extern DrawingShape * docCopyDrawingShape(
					DocumentCopyJob *	dcj,
					const DrawingShape *	from );

extern int docCheckNoBreakAsLast(	EditOperation *		eo,
					BufferItem *		paraBi );

extern void docEditAdaptRowPropertiesToFirstChild(
					EditOperation *		eo,
					const BufferItem *	paraBi );

extern int docEditFixParaBreakKind(	EditOperation *		eo,
					DocumentTree *		ei,
					BufferDocument *	bd,
					int			paraNr );

extern int docIncludeDocument(		DocumentCopyJob *		dcj );

extern int docSectionParagraph( EditOperation *		eo,
			BufferItem **			pParaBi,
			BufferItem *			sectBi,
			int				sectShift,
			const ParagraphProperties *	pp,
			int				textAttributeNumber );

extern int docEditInsertSection(	DocumentPosition *	dpNew,
					EditOperation *		eo );

extern int docCopySectHeadersFooters(	BufferItem *		sectBiTo,
					BufferDocument *	bdTo,
					const BufferItem *	sectBiFrom,
					BufferDocument *	bdFrom );

extern BufferItem * docCopyItem(	DocumentCopyJob *	dcj,
					BufferItem *		parentBiTo,
					int			n,
					const BufferItem *	biFrom );

extern int docEditDeleteFieldsForBlockDelete(
				EditOperation *			eo,
				const DocumentSelection *	ds );

extern int docDeleteFieldsInRange(	EditOperation *		eo,
					int			headPart,
					int			tailPart,
					DocumentSelection *	dsBalanced );

extern BufferItem * docCopyParaItem(	DocumentCopyJob *	dcj,
					const SelectionScope *	ssRoot,
					BufferItem *		biCellTo,
					int			n,
					const BufferItem *	biParaFrom );

#   endif	/*	DOC_EDIT_H	*/
