/************************************************************************/
/*									*/
/*  Pieces of text, physically implemented as a 'Section' thay are	*/
/*  outside the normal flow of text.					*/
/*									*/
/************************************************************************/

#   ifndef	DOC_DOCUMENT_NOTE_H
#   define	DOC_DOCUMENT_NOTE_H

#   include	"docExternalItem.h"
#   include	"docEditPosition.h"
#   include	"docSelectionScope.h"

/************************************************************************/
/*									*/
/*  Forward declarations of structs.					*/
/*									*/
/************************************************************************/

struct BufferDocument;
struct BufferItem;
struct DocumentField;

/************************************************************************/
/*									*/
/*  A footnote/endnote/annotation.					*/
/*									*/
/*  1)  Though the notes are stored with the section, the paragraph	*/
/*	number is relative to the body of the document as a whole.	*/
/*									*/
/************************************************************************/

typedef struct NoteProperties
    {
    MemoryBuffer	npFixedText;
    unsigned char	npExternalItemKind;
    unsigned char	npAutoNumber;
    } NoteProperties;

typedef struct DocumentNote
    {
    DocumentTree	dnDocumentTree;
    short int		dnNoteNumber;
    short int		dnReferringPage;
    short int		dnReferringColumn;
    NoteProperties	dnNoteProperties;
    } DocumentNote;

# define NOTE_IS_DELETED( dn )	((dn)->dnNoteNumber < 0 )

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitNoteProperties(	NoteProperties *	np );
extern void docCleanNoteProperties(	NoteProperties *	np );

extern int docCopyNoteProperties(	NoteProperties *	to,
					const NoteProperties *	from );

extern void docInitNote(		DocumentNote *		dn );

extern int docEqualNoteProperties(	const NoteProperties *	np1,
					const NoteProperties *	np2 );

#   endif
