/************************************************************************/
/*									*/
/*  A list of fields.							*/
/*									*/
/************************************************************************/

#   ifndef DOC_DOCUMENT_FIELD_LIST_H
#   define DOC_DOCUMENT_FIELD_LIST_H

#   include	"docDocumentField.h"
#   include	"utilPagedList.h"

typedef struct DocumentFieldList
    {
    PagedList		dflPagedList;
    } DocumentFieldList;

extern DocumentField * docGetFieldByNumber(
					const DocumentFieldList *	dfl,
					int				n );

extern void docDeleteFieldFromList(	DocumentFieldList *		dfl,
					DocumentField *			df );

extern int docGetFieldKindByNumber(	const DocumentFieldList *	dfl,
					int				n );

extern void docCleanFieldList(		DocumentFieldList *	dfl );
extern void docInitFieldList(		DocumentFieldList *	dfl );

extern void docSetPageOfField(		DocumentFieldList *	dfl,
					int			n,
					int			page );

extern DocumentField * docClaimField(	DocumentFieldList *	dfl );

extern DocumentField *	docClaimFieldCopy(
					DocumentFieldList *	dfl,
					const DocumentField *	dfFrom,
					const SelectionScope *	ss,
					const EditPosition *	epStart );

extern int docGetBookmarkField(	DocumentField **		pDf,
				const DocumentFieldList *	dfl,
				const char *			markName,
				int				markSize );

extern int docMakeBookmarkList(	char ***			pBookmarks,
				int *				pBookmarkCount,
				const DocumentFieldList *	dfl );

#   endif /*  DOC_DOCUMENT_FIELD_LIST_H  */
