/************************************************************************/
/*									*/
/*  Copy part of one document to another (or the same) document.	*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"
#   include	"docDocumentCopyJob.h"

void docInitDocumentCopyJob(	DocumentCopyJob *	dcj )
    {
    dcj->dcjEditOperation= (EditOperation *)0;
    docInitSelectionScope( &(dcj->dcjSelectionScope) );
    dcj->dcjEiTo= (DocumentTree *)0;
    dcj->dcjBdFrom= (BufferDocument *)0;
    dcj->dcjCopyFields= 0;
    dcj->dcjFieldMap= (int *)0;

    docInitDocumentAttributeMap( &(dcj->dcjAttributeMap) );
    dcj->dcjForceAttributeTo= -1;

    dcj->dcjRefFileName= (char *)0;
    dcj->dcjRefFileSize= 0;

    dcj->dcjFieldStack= (FieldCopyStackLevel *)0;

    dcj->dcjInExternalItem= 0;

    dcj->dcjCurrentTextAttributeNumberFrom= -1;
    dcj->dcjCurrentTextAttributeNumberTo= -1;

    dcj->dcjNotesCopied= 0;
    dcj->dcjBulletsCopied= 0;

    return;
    }

void docCleanDocumentCopyJob(	DocumentCopyJob *	dcj )
    {
    if  ( dcj->dcjFieldMap )
	{ free( dcj->dcjFieldMap );	}

    docCleanDocumentAttributeMap( &(dcj->dcjAttributeMap) );

    while( dcj->dcjFieldStack )
	{
	FieldCopyStackLevel *	prev= dcj->dcjFieldStack->fcslPrev;

	free( dcj->dcjFieldStack );

	dcj->dcjFieldStack= prev;
	}

    return;
    }

int docPushFieldOnCopyStack(		DocumentCopyJob *	dcj,
					DocumentField *		df )
    {
    FieldCopyStackLevel *	fcsl;

    fcsl= (FieldCopyStackLevel *)malloc( sizeof(FieldCopyStackLevel) );
    if  ( ! fcsl )
	{ XDEB(fcsl); return -1;	}

    fcsl->fcslPrev= dcj->dcjFieldStack;
    fcsl->fcslField= df;
    dcj->dcjFieldStack= fcsl;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Allocate a mapping for field numbers.				*/
/*									*/
/************************************************************************/

static int * docAllocateFieldMap(	const BufferDocument *	bdFrom )
    {
    int *	fieldMap;
    int		i;
    const int	fieldCount= bdFrom->bdFieldList.dflPagedList.plItemCount;

    fieldMap= malloc( fieldCount* sizeof(int)+ 1 );
    if  ( ! fieldMap )
	{ LXDEB(fieldCount,fieldMap); return (int *)0; }
    for ( i= 0; i < fieldCount; i++ )
	{ fieldMap[i]= -1;	}

    return fieldMap;
    }

/************************************************************************/

static int docSetAttributeMap(	DocumentAttributeMap *		dam,
				BufferDocument *		bdTo,
				BufferDocument *		bdFrom )
    {
    int *		fontmap= (int *)0;
    int *		cmap= (int *)0;
    int *		bmap= (int *)0;
    int *		shadingMap= (int *)0;
    int *		frameMap= (int *)0;
    int *		lsmap= (int *)0;

    if  ( docMergeColorTables( &cmap, bdTo, bdFrom ) )
	{ LDEB(1); return -1;	}

    if  ( docMergeBorderPropertiesLists( &bmap, cmap,
					&(bdTo->bdBorderPropertyList),
					&(bdFrom->bdBorderPropertyList) ) )
	{ LDEB(1); return -1;	}

    if  ( docMergeItemShadingLists( &shadingMap, cmap,
					&(bdTo->bdItemShadingList),
					&(bdFrom->bdItemShadingList) ) )
	{ LDEB(1); return -1;	}

    if  ( docMergeFramePropertyLists( &frameMap,
					&(bdTo->bdFramePropertyList),
					&(bdFrom->bdFramePropertyList) ) )
	{ LDEB(1); return -1;	}

    if  ( docMergeDocumentLists( &fontmap, &lsmap, cmap, bdTo, bdFrom ) )
	{ LDEB(1); return -1;	}

    if  ( dam->damFontMap )
	{ free( dam->damFontMap );	}
    dam->damFontMap= fontmap;

    if  ( dam->damColorMap )
	{ free( dam->damColorMap );	}
    dam->damColorMap= cmap;

    if  ( dam->damBorderMap )
	{ free( dam->damBorderMap );	}
    dam->damBorderMap= bmap;

    if  ( dam->damShadingMap )
	{ free( dam->damShadingMap );	}
    dam->damShadingMap= shadingMap;

    if  ( dam->damFrameMap )
	{ free( dam->damFrameMap );	}
    dam->damFrameMap= frameMap;

    if  ( dam->damListStyleMap )
	{ free( dam->damListStyleMap );	}
    dam->damListStyleMap= lsmap;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Build a copy job for copying within a document.			*/
/*									*/
/************************************************************************/

int docSet1DocumentCopyJob(	DocumentCopyJob *	dcj,
				EditOperation *		eo )
    {
    int *	fieldMap;

    dcj->dcjEditOperation= eo;
    dcj->dcjSelectionScope= eo->eoSelectionScope;
    dcj->dcjEiTo= eo->eoEi;
    dcj->dcjBdFrom= eo->eoBd;
    dcj->dcjCopyFields= 0;

    fieldMap= docAllocateFieldMap( dcj->dcjBdFrom );
    if  ( ! fieldMap )
	{ XDEB(fieldMap); return -1;	}

    if  ( dcj->dcjFieldMap )
	{ free( dcj->dcjFieldMap );	}

    dcj->dcjFieldMap= fieldMap;

    if  ( eo->eoBottomField					&&
	  docPushFieldOnCopyStack( dcj, eo->eoBottomField )	)
	{ LDEB(1); return -1;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Build a copy job for copying from one document to another.		*/
/*									*/
/************************************************************************/

int docSet2DocumentCopyJob(	DocumentCopyJob *	dcj,
				EditOperation *		eo,
				BufferDocument *	bdFrom,
				const char *		refFileName )
    {
    int *		fldmap;

    BufferDocument *	bdTo= eo->eoBd;

    dcj->dcjEditOperation= eo;
    dcj->dcjSelectionScope= eo->eoSelectionScope;
    dcj->dcjEiTo= eo->eoEi;
    dcj->dcjBdFrom= bdFrom;
    dcj->dcjCopyFields= 1;

    fldmap= docAllocateFieldMap( bdFrom );
    if  ( ! fldmap )
	{ XDEB(fldmap); return -1;	}
    if  ( dcj->dcjFieldMap )
	{ free( dcj->dcjFieldMap );	}
    dcj->dcjFieldMap= fldmap;

    if  ( docSetAttributeMap( &(dcj->dcjAttributeMap), bdTo, bdFrom ) )
	{ LDEB(1); return -1;	}

    if  ( refFileName )
	{
	int	l= strlen( refFileName );
	char *	fresh= malloc( l+ 1 );

	if  ( ! fresh )
	    { XDEB(fresh); return -1;	}

	strcpy( fresh, refFileName );

	if  ( dcj->dcjRefFileName )
	    { free( dcj->dcjRefFileName );	}

	dcj->dcjRefFileName= fresh;
	dcj->dcjRefFileSize= l;
	}
    else{
	if  ( dcj->dcjRefFileName )
	    { free( dcj->dcjRefFileName );	}

	dcj->dcjRefFileName= (char *)0;
	dcj->dcjRefFileSize= 0;
	}

    if  ( eo->eoBottomField					&&
	  docPushFieldOnCopyStack( dcj, eo->eoBottomField )	)
	{ LDEB(1); return -1;	}

    return 0;
    }
