#   include	"docBufConfig.h"

#   include	"docBuf.h"
#   include	<stdio.h>
#   include	<appDebugon.h>

void docListFieldParticule(	int			indent,
				const char *		label,
				int			n,
				const BufferItem *	bi,
				const TextParticule *	tp,
				const DocumentField *	df )
    {
    appDebug( "%*s%s %3d: [S %4d..%4d] %s",
		    indent, "", label, n,
		    tp->tpStroff, tp->tpStroff+ tp->tpStrlen,
		    docKindStr( tp->tpKind ) );

    if  ( tp->tpStrlen > 0 )
	{
	appDebug( " \"%.*s\"",
		    (int)tp->tpStrlen,
		    docParaString( bi, tp->tpStroff ) );
	}

    if  ( tp->tpKind == DOCkindOBJECT		||
	  tp->tpKind == DOCkindFIELDSTART	||
	  tp->tpKind == DOCkindFIELDEND		||
	  tp->tpObjectNumber >= 0		)
	{ appDebug( " OBNR=%d", tp->tpObjectNumber );	}

    if  ( df )
	{ appDebug( " FIELD:%s", docFieldKindStr( df->dfKind ) );	}

    appDebug( "\n" );

    return;
    }

static int docCheckFieldHeadParticule(	const TextParticule *	tp,
					int			part,
					int			paraNr,
					const BufferItem *	bi,
					const DocumentField *	df )
    {
    int		wrong= 0;

    if  ( df->dfFieldNumber != tp->tpObjectNumber )
	{
	LLDEB(df->dfFieldNumber,tp->tpObjectNumber);
	docListFieldParticule( 4, "#FN#", part, bi, tp, df );
	wrong= 1;
	}

    if  ( tp->tpKind != DOCkindFIELDSTART )
	{ SLLDEB("####",tp->tpKind,DOCkindFIELDSTART); wrong= 1;	}

    if  ( df->dfHeadPosition.epParaNr != paraNr )
	{
	LLDEB(df->dfHeadPosition.epParaNr,paraNr);
	docListFieldParticule( 4, "#PA#", part, bi, tp, df );
	wrong= 1;
	}
    if  ( df->dfHeadPosition.epStroff != tp->tpStroff )
	{
	LLDEB(df->dfHeadPosition.epStroff,tp->tpStroff);
	docListFieldParticule( 4, "#ST#", part, bi, tp, df );
	wrong= 1;
	}

    return wrong;
    }

static int docCheckFieldTailParticule(	const TextParticule *	tp,
					int			part,
					int			paraNr,
					const BufferItem *	bi,
					const DocumentField *	df )
    {
    int		wrong= 0;

    if  ( df->dfFieldNumber != tp->tpObjectNumber )
	{
	LLDEB(df->dfFieldNumber,tp->tpObjectNumber);
	docListFieldParticule( 4, "#FN#", part, bi, tp, df );
	wrong= 1;
	}

    if  ( tp->tpKind != DOCkindFIELDEND )
	{ SLLDEB("####",tp->tpKind,DOCkindFIELDEND); wrong= 1;	}

    if  ( df->dfTailPosition.epParaNr != paraNr )
	{
	LLDEB(df->dfTailPosition.epParaNr,paraNr);
	docListFieldParticule( 4, "#PA#", part, bi, tp, df );
	wrong= 1;
	}
    if  ( df->dfTailPosition.epStroff != tp->tpStroff )
	{
	LLDEB(df->dfTailPosition.epStroff,tp->tpStroff);
	docListFieldParticule( 4, "#ST#", part, bi, tp, df );
	wrong= 1;
	}

    return wrong;
    }

void docCheckFieldOffsets(	const BufferDocument *	bd,
				const BufferItem *	bi )
    {
    const DocumentFieldList *	dfl= &(bd->bdFieldList);

    switch( bi->biLevel )
	{
	int			i;
	int			part;
	const TextParticule *	tp;
	int			paraNr;
	int			wrong;

	case DOClevBODY:
	case DOClevSECT:
	case DOClevCELL:
	case DOClevROW:
	    for ( i= 0; i < bi->biChildCount; i++ )
		{ docCheckFieldOffsets( bd, bi->biChildren[i] );	}
	    break;

	case DOClevPARA:
	    paraNr= docNumberOfParagraph( bi );
	    tp=  bi->biParaParticules;
	    wrong= 0;
	    for ( part= 0; part < bi->biParaParticuleCount; tp++, part++ )
		{
		const DocumentField *	df;

		if  ( tp->tpKind != DOCkindFIELDEND	&&
		      tp->tpKind != DOCkindFIELDSTART	)
		    { continue;	}

		df= docGetFieldByNumber( dfl, tp->tpObjectNumber );
		if  ( ! df )
		    { SLXDEB("####",tp->tpObjectNumber,df); continue;	}

		if  ( tp->tpKind == DOCkindFIELDSTART )
		    {
		    if  ( docCheckFieldHeadParticule( tp, part,
							paraNr, bi, df ) )
			{ wrong= 1;	}
		    }
		if  ( tp->tpKind == DOCkindFIELDEND )
		    {
		    if  ( docCheckFieldTailParticule( tp, part,
							paraNr, bi, df ) )
			{ wrong= 1;	}
		    }
		}
	    if  ( wrong )
		{ docListItem(0,bi,0);	}
	    break;

	case DOClevOUT:
	default:
	    break;
	}

    return;
    }

typedef struct FieldPosition
    {
    EditPosition	fpPosition;
    int			fpPage;
    int			fpColumn;
    } FieldPosition;

static void docCheckFieldPosition(
				int			indent,
				FieldPosition *		fp,
				const DocumentField *	df,
				const NotesList *	nl )
    {
    const char *		endString= "}";

    if  ( df->dfChildFields.cfChildCount > 0 )
	{ endString= " "; }

    appDebug( "%*s {  %4d:%-4d .. %4d:%-4d %s %d=%s\n",
		indent, "",
		df->dfHeadPosition.epParaNr,
		df->dfHeadPosition.epStroff,
		df->dfTailPosition.epParaNr,
		df->dfTailPosition.epStroff,
		endString,
		df->dfFieldNumber, docFieldKindStr( df->dfKind ) );

    if  ( docCompareEditPositions( &(fp->fpPosition),
					    &(df->dfHeadPosition) ) > 0 )
	{ appDebug( "%*s## START BEFORE PREV or PARENT\n", indent+ 15, "" ); }

    if  ( docCompareEditPositions( &(df->dfHeadPosition),
					&(df->dfTailPosition) ) > 0 )
	{ appDebug( "%*s## START AFTER END\n", indent+ 15, "" ); }

    if  ( df->dfSelectionScope.ssInExternalItem == DOCinBODY	&&
	  df->dfKind == DOCfkCHFTN				&&
	  nl							)
	{
	if  ( df->dfNoteIndex < 0 || df->dfNoteIndex >= nl->nlNoteCount )
	    {
	    appDebug( "%*s## Note %d/%d\n", indent+ 15, "",
				df->dfNoteIndex, nl->nlNoteCount );
	    }
	else{
	    const DocumentNote *	dn= nl->nlNotes+ df->dfNoteIndex;

	    if  ( dn->dnReferringPage < fp->fpPage			||
		  ( dn->dnReferringPage == fp->fpPage		&&
		    dn->dnReferringColumn < fp->fpColumn	)	)
		{
		appDebug( "%*s## NOTE %d:%d BEFORE PREVIOUS %d:%d\n",
			indent+ 15, "",
			dn->dnReferringPage, dn->dnReferringColumn,
			fp->fpPage, fp->fpColumn );
		}

	    fp->fpPage= dn->dnReferringPage;
	    fp->fpColumn= dn->dnReferringColumn;
	    }
	}

    return;
    }

static void docCheckFieldTree(		int			indent,
					const BufferDocument *	bd,
					const DocumentTree *	ei,
					FieldPosition *		fp,
					const DocumentField *	parent,
					const ChildFields *	cf )
    {
    int			i;

    for ( i= 0; i < cf->cfChildCount; i++ )
	{
	const DocumentField *	df= cf->cfChildren[i];

	docCheckFieldPosition( indent, fp, df, &(bd->bdNotesList) );

	if  ( df->dfParent != parent )
	    { appDebug( "%*s## WRONG PARENT\n", indent+ 15, "" ); }
	if  ( df->dfNumberInParent != i )
	    {
	    appDebug( "%*s## WRONG INDEX %d@%d\n", indent+ 15, "",
						df->dfNumberInParent, i );
	    }

	if  ( i > 0 && df == cf->cfChildren[i-1] )
	    { appDebug( "%*s## FIELD APPEARS TWICE\n", indent+ 15, "" ); }

	fp->fpPosition= df->dfHeadPosition;

	if  ( df->dfChildFields.cfChildCount > 0 )
	    {
	    docCheckFieldTree( indent+ 1, bd, ei,
					fp, df, &(df->dfChildFields) );

	    if  ( docCompareEditPositions( &(fp->fpPosition),
					    &(df->dfTailPosition ) ) > 0 )
		{ appDebug( "%*s## CHILD PAST END\n", indent+ 15, "" ); }

	    appDebug( "%*s }  %4d:%-4d\n",
			indent, "",
			df->dfTailPosition.epParaNr,
			df->dfTailPosition.epStroff );

	    if  ( ei )
		{
		DocumentSelection	dsInside;
		DocumentSelection	dsAround;
		int			part0;
		int			part1;
		int			wrong= 0;

		if  ( docDelimitFieldInTree( &dsInside, &dsAround,
						&part0, &part1, bd, ei, df ) )
		    {
		    appDebug( "### Field not found\n" );
		    wrong= 1;
		    }
		else{
		    if  ( docCheckFieldHeadParticule(
				dsInside.dsHead.dpBi->biParaParticules+ part0,
				part0, df->dfHeadPosition.epParaNr,
				dsInside.dsHead.dpBi, df ) )
			{ wrong= 1;	}

		    if  ( docCheckFieldTailParticule(
				dsInside.dsTail.dpBi->biParaParticules+ part1,
				part0, df->dfTailPosition.epParaNr,
				dsInside.dsTail.dpBi, df ) )
			{ wrong= 1;	}
		    }
		}
	    }

	fp->fpPosition= df->dfTailPosition;
	}
    }

void docListFieldTree(	const BufferDocument *	bd,
			const DocumentTree *	ei )
    {
    const ChildFields *	cf= &(ei->eiRootFields);
    DocumentField *	parent= (DocumentField *)0;

    if  ( cf->cfChildCount > 0 )
	{
	FieldPosition	fp;

	fp.fpPosition= cf->cfChildren[0]->dfHeadPosition;
	fp.fpPage= -1;
	fp.fpColumn= 0;

	docCheckFieldTree( 0, bd, ei, &fp, parent, cf );
	}

    return;
    }

void docListFields(	const ChildFields *	cf,
			const NotesList *	nl )
    {
    DocumentField *	df;

    df= docGetFirstField( cf );
    if  ( df )
	{
	FieldPosition	fp;

	fp.fpPosition= df->dfHeadPosition;
	fp.fpPage= -1;
	fp.fpColumn= 0;

	while( df )
	    {
	    const int		indent= 0;
	    DocumentField *	odf= df;

	    docCheckFieldPosition( indent, &fp, df, nl );

	    df= docGetNextField( cf, df );
	    if  ( df == odf )
		{ XXDEB(df,odf); /*abort();*/	}
	    }
	}
    }

static void docScanNotes(	const BufferDocument *	bd,
				int			extItKind )
    {
    DocumentField *	dfNote;
    DocumentNote *	dn;

    dfNote= docGetFirstNoteOfDocument( &dn, bd, extItKind );
    if  ( dfNote )
	{
	FieldPosition	fp;

	fp.fpPosition= dfNote->dfHeadPosition;
	fp.fpPage= -1;
	fp.fpColumn= 0;

	while( dfNote )
	    {
	    const int	indent= 0;

	    docCheckFieldPosition( indent, &fp, dfNote, &(bd->bdNotesList) );

	    dfNote= docGetNextNoteInDocument( &dn, bd, dfNote, extItKind );
	    }
	}
    }

void docScanNotesOfDocument(	const BufferDocument *	bd )
    {
    docScanNotes( bd, DOCinFOOTNOTE );
    docScanNotes( bd, DOCinENDNOTE );
    }

