/************************************************************************/
/*									*/
/*  Text buffer: Diagnostic routines.					*/
/*									*/
/************************************************************************/

#   ifndef	DOC_DEBUG_H
#   define	DOC_DEBUG_H

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern const char * docKindStr(		int			kind );
extern const char * docLevelStr(	int			level );
extern const char * docExternalKindStr(	int			level );
extern const char * docFieldKindStr(	int			kind );
extern const char * docObjectKindStr(	int			kind );
extern const char * docNotesPosStr(	int			pos );
extern const char * docAttributeStr(	const TextAttribute *	ta );
extern const char * docParticuleFlagsStr( int			flags );

extern void docCheckFieldOffsets(	const BufferDocument *	bd,
					const BufferItem *	bi );

extern int docCheckItem(	const BufferItem *	bi,
				int			checkGeometry );
extern int docCheckRootItem(	const BufferItem *	bi,
				int			checkGeometry );

extern void docListFieldParticule(	int			indent,
					const char *		label,
					int			n,
					const BufferItem *	bi,
					const TextParticule *	tp,
					const DocumentField *	df );

extern void docListFieldTree(		const BufferDocument *	bd,
					const DocumentTree *	ei );

extern void docListListNumberNode(	int				indent,
					const ListNumberTreeNode *	lntn );

extern void docScanNotesOfDocument(	const BufferDocument *	bd );

extern void docListFields(		const ChildFields *	cf,
					const NotesList *	nl );

extern void docListFontList(		const DocumentFontList * dfl );

extern void docLogRectangle(	const char *			label,
				const DocumentRectangle *	dr );

extern void docLogRectangles(	const char *			label1,
				const DocumentRectangle *	dr1,
				const char *			label2,
				const DocumentRectangle *	dr2 );

extern void docListItem(	int			indent,
				const BufferItem *	bi,
				int			checkGeometry );

extern void docListRootItem(	int			indent,
				const BufferItem *	bi,
				int			checkGeometry );

extern void docListParticule(	int			indent,
				const char *		label,
				int			n,
				const BufferItem *	bi,
				const TextParticule *	tp );

extern void docListTextLine(	int			indent,
				const char *		label,
				int			n,
				const BufferItem *	bi,
				const TextLine *	tl );

extern void docListObjects(	BufferDocument * 	bd );

extern void docListNotes(	const BufferDocument *	bd );

extern void docListDocumentList(	int			n,
					const DocumentList *	dl );

extern void docListListOverrideLevel(	int				n,
					const ListOverrideLevel *	lol );

extern void docListListOverrideTable(	int				n,
					const ListOverrideTable *	lot );

extern void docListListOverride(	int				n,
					const ListOverride *		lo );

extern void docListDocumentListTable( const DocumentListTable *		dlt );

extern void docListShapes(		BufferDocument *		bd );
extern void docListDocumentObjects(	BufferDocument *		bd );


#   endif
