/************************************************************************/
/*									*/
/*  Buffer administration routines.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docCellProperties.h"

/************************************************************************/
/*									*/
/*  Initialise Cell properties.						*/
/*									*/
/************************************************************************/

void docInitCellProperties(	CellProperties *	cp )
    {
    cp->cpRightBoundaryTwips= 0;

    cp->cpTopBorderNumber= 0;
    cp->cpLeftBorderNumber= 0;
    cp->cpRightBorderNumber= 0;
    cp->cpBottomBorderNumber= 0;

    cp->cpShadingNumber= 0;

    /**/
    cp->cpPreferredWidth= 0;
    cp->cpPreferredWidthUnit= TRautoNONE;

    cp->cpTopPadding= 0;
    cp->cpBottomPadding= 0;
    cp->cpLeftPadding= 0;
    cp->cpRightPadding= 0;

    cp->cpTopPaddingUnit= TRautoNONE;
    cp->cpBottomPaddingUnit= TRautoNONE;
    cp->cpLeftPaddingUnit= TRautoNONE;
    cp->cpRightPaddingUnit= TRautoNONE;

    cp->cpLeftInMergedRow= 0;
    cp->cpMergedWithLeft= 0;
    cp->cpTopInMergedColumn= 0;
    cp->cpMergedWithAbove= 0;
    cp->cpNoWrap= 0;
    cp->cpNoShading= 0;

    cp->cpValign= DOCtvaTOP;
    cp->cpTextFlow= TXflowTXLRTB;
    }

/************************************************************************/
/*									*/
/*  Change cell properties and tell what has been changed.		*/
/*									*/
/************************************************************************/

int docUpdCellProperties(	PropertyMask *			pCpChgPask,
				CellProperties *		cpTo,
				const PropertyMask *		cpUpdMask,
				const CellProperties *		cpFrom,
				const DocumentAttributeMap *	dam )
    {
    PropertyMask		cpChgMask;

    utilPropMaskClear( &cpChgMask );

    if  ( PROPmaskISSET( cpUpdMask, CLpropCELLX ) )
	{
	if  ( cpTo->cpRightBoundaryTwips != cpFrom->cpRightBoundaryTwips )
	    {
	    cpTo->cpRightBoundaryTwips= cpFrom->cpRightBoundaryTwips;
	    PROPmaskADD( &cpChgMask, CLpropCELLX );
	    }
	}

    /**/
    if  ( PROPmaskISSET( cpUpdMask, CLpropTOP_BORDER ) )
	{
	int	fromNumber= cpFrom->cpTopBorderNumber;

	if  ( fromNumber >= 0 && dam && dam->damBorderMap )
	    { fromNumber= dam->damBorderMap[fromNumber];	}

	if  ( cpTo->cpTopBorderNumber != fromNumber )
	    {
	    cpTo->cpTopBorderNumber= fromNumber;
	    PROPmaskADD( &cpChgMask, CLpropTOP_BORDER );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropBOTTOM_BORDER ) )
	{
	int	fromNumber= cpFrom->cpBottomBorderNumber;

	if  ( fromNumber >= 0 && dam && dam->damBorderMap )
	    { fromNumber= dam->damBorderMap[fromNumber];	}

	if  ( cpTo->cpBottomBorderNumber != fromNumber )
	    {
	    cpTo->cpBottomBorderNumber= fromNumber;
	    PROPmaskADD( &cpChgMask, CLpropBOTTOM_BORDER );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropLEFT_BORDER ) )
	{
	int	fromNumber= cpFrom->cpLeftBorderNumber;

	if  ( fromNumber >= 0 && dam && dam->damBorderMap )
	    { fromNumber= dam->damBorderMap[fromNumber];	}

	if  ( cpTo->cpLeftBorderNumber != fromNumber )
	    {
	    cpTo->cpLeftBorderNumber= fromNumber;
	    PROPmaskADD( &cpChgMask, CLpropLEFT_BORDER );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropRIGHT_BORDER ) )
	{
	int	fromNumber= cpFrom->cpRightBorderNumber;

	if  ( fromNumber >= 0 && dam && dam->damBorderMap )
	    { fromNumber= dam->damBorderMap[fromNumber];	}

	if  ( cpTo->cpRightBorderNumber != fromNumber )
	    {
	    cpTo->cpRightBorderNumber= fromNumber;
	    PROPmaskADD( &cpChgMask, CLpropRIGHT_BORDER );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropSHADING ) )
	{
	int	fromNumber= cpFrom->cpShadingNumber;

	if  ( fromNumber >= 0 && dam && dam->damShadingMap )
	    { fromNumber= dam->damShadingMap[fromNumber];	}

	if  ( cpTo->cpShadingNumber != fromNumber )
	    {
	    cpTo->cpShadingNumber= fromNumber;
	    PROPmaskADD( &cpChgMask, CLpropSHADING );
	    }
	}

    /**/
    if  ( PROPmaskISSET( cpUpdMask, CLpropCLW_WIDTH ) )
	{
	if  ( cpTo->cpPreferredWidth != cpFrom->cpPreferredWidth )
	    {
	    cpTo->cpPreferredWidth= cpFrom->cpPreferredWidth;
	    PROPmaskADD( &cpChgMask, CLpropCLW_WIDTH );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropCLFTS_WIDTH ) )
	{
	if  ( cpTo->cpPreferredWidthUnit != cpFrom->cpPreferredWidthUnit )
	    {
	    cpTo->cpPreferredWidthUnit= cpFrom->cpPreferredWidthUnit;
	    PROPmaskADD( &cpChgMask, CLpropCLFTS_WIDTH );
	    }
	}

    /**/
    if  ( PROPmaskISSET( cpUpdMask, CLpropLEFT_IN_MERGED ) )
	{
	if  ( cpTo->cpLeftInMergedRow != cpFrom->cpLeftInMergedRow )
	    {
	    cpTo->cpLeftInMergedRow= cpFrom->cpLeftInMergedRow;
	    PROPmaskADD( &cpChgMask, CLpropLEFT_IN_MERGED );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropMERGED_WITH_LEFT ) )
	{
	if  ( cpTo->cpMergedWithLeft != cpFrom->cpMergedWithLeft )
	    {
	    cpTo->cpMergedWithLeft= cpFrom->cpMergedWithLeft;
	    PROPmaskADD( &cpChgMask, CLpropMERGED_WITH_LEFT );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropTOP_IN_MERGED ) )
	{
	if  ( cpTo->cpTopInMergedColumn != cpFrom->cpTopInMergedColumn )
	    {
	    cpTo->cpTopInMergedColumn= cpFrom->cpTopInMergedColumn;
	    PROPmaskADD( &cpChgMask, CLpropTOP_IN_MERGED );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropMERGED_WITH_ABOVE ) )
	{
	if  ( cpTo->cpMergedWithAbove != cpFrom->cpMergedWithAbove )
	    {
	    cpTo->cpMergedWithAbove= cpFrom->cpMergedWithAbove;
	    PROPmaskADD( &cpChgMask, CLpropMERGED_WITH_ABOVE );
	    }
	}

    /**/
    if  ( PROPmaskISSET( cpUpdMask, CLpropVALIGN ) )
	{
	if  ( cpTo->cpValign != cpFrom->cpValign )
	    {
	    cpTo->cpValign= cpFrom->cpValign;
	    PROPmaskADD( &cpChgMask, CLpropVALIGN );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropTEXT_FLOW ) )
	{
	if  ( cpTo->cpTextFlow != cpFrom->cpTextFlow )
	    {
	    cpTo->cpTextFlow= cpFrom->cpTextFlow;
	    PROPmaskADD( &cpChgMask, CLpropTEXT_FLOW );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropTOP_PADDING ) )
	{
	if  ( cpTo->cpTopPadding != cpFrom->cpTopPadding )
	    {
	    cpTo->cpTopPadding= cpFrom->cpTopPadding;
	    PROPmaskADD( &cpChgMask, CLpropTOP_PADDING );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropBOTTOM_PADDING ) )
	{
	if  ( cpTo->cpBottomPadding != cpFrom->cpBottomPadding )
	    {
	    cpTo->cpBottomPadding= cpFrom->cpBottomPadding;
	    PROPmaskADD( &cpChgMask, CLpropBOTTOM_PADDING );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropLEFT_PADDING ) )
	{
	if  ( cpTo->cpLeftPadding != cpFrom->cpLeftPadding )
	    {
	    cpTo->cpLeftPadding= cpFrom->cpLeftPadding;
	    PROPmaskADD( &cpChgMask, CLpropLEFT_PADDING );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropRIGHT_PADDING ) )
	{
	if  ( cpTo->cpRightPadding != cpFrom->cpRightPadding )
	    {
	    cpTo->cpRightPadding= cpFrom->cpRightPadding;
	    PROPmaskADD( &cpChgMask, CLpropRIGHT_PADDING );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropTOP_PADDING_UNIT ) )
	{
	if  ( cpTo->cpTopPaddingUnit != cpFrom->cpTopPaddingUnit )
	    {
	    cpTo->cpTopPaddingUnit= cpFrom->cpTopPaddingUnit;
	    PROPmaskADD( &cpChgMask, CLpropTOP_PADDING_UNIT );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropBOTTOM_PADDING_UNIT ) )
	{
	if  ( cpTo->cpBottomPaddingUnit != cpFrom->cpBottomPaddingUnit )
	    {
	    cpTo->cpBottomPaddingUnit= cpFrom->cpBottomPaddingUnit;
	    PROPmaskADD( &cpChgMask, CLpropBOTTOM_PADDING_UNIT );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropLEFT_PADDING_UNIT ) )
	{
	if  ( cpTo->cpLeftPaddingUnit != cpFrom->cpLeftPaddingUnit )
	    {
	    cpTo->cpLeftPaddingUnit= cpFrom->cpLeftPaddingUnit;
	    PROPmaskADD( &cpChgMask, CLpropLEFT_PADDING_UNIT );
	    }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropRIGHT_PADDING_UNIT ) )
	{
	if  ( cpTo->cpRightPaddingUnit != cpFrom->cpRightPaddingUnit )
	    {
	    cpTo->cpRightPaddingUnit= cpFrom->cpRightPaddingUnit;
	    PROPmaskADD( &cpChgMask, CLpropRIGHT_PADDING_UNIT );
	    }
	}

    *pCpChgPask= cpChgMask; return 0;
    }

/************************************************************************/
/*									*/
/*  Compare cell properties.						*/
/*									*/
/************************************************************************/

void docCellPropertyDifference(	PropertyMask *			pCpChgPask,
				const CellProperties *		cpTo,
				const CellProperties *		cpFrom,
				const PropertyMask *		cpUpdMask,
				const DocumentAttributeMap *	dam )
    {
    PropertyMask		cpChgMask;

    utilPropMaskClear( &cpChgMask );

    if  ( PROPmaskISSET( cpUpdMask, CLpropCELLX ) )
	{
	if  ( cpTo->cpRightBoundaryTwips != cpFrom->cpRightBoundaryTwips )
	    { PROPmaskADD( &cpChgMask, CLpropCELLX ); }
	}

    /**/
    if  ( PROPmaskISSET( cpUpdMask, CLpropTOP_BORDER ) )
	{
	int	fromNumber= cpFrom->cpTopBorderNumber;

	if  ( fromNumber >= 0 && dam && dam->damBorderMap )
	    { fromNumber= dam->damBorderMap[fromNumber];	}

	if  ( cpTo->cpTopBorderNumber != fromNumber )
	    { PROPmaskADD( &cpChgMask, CLpropTOP_BORDER ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropBOTTOM_BORDER ) )
	{
	int	fromNumber= cpFrom->cpBottomBorderNumber;

	if  ( fromNumber >= 0 && dam && dam->damBorderMap )
	    { fromNumber= dam->damBorderMap[fromNumber];	}

	if  ( cpTo->cpBottomBorderNumber != fromNumber )
	    { PROPmaskADD( &cpChgMask, CLpropBOTTOM_BORDER ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropLEFT_BORDER ) )
	{
	int	fromNumber= cpFrom->cpLeftBorderNumber;

	if  ( fromNumber >= 0 && dam && dam->damBorderMap )
	    { fromNumber= dam->damBorderMap[fromNumber];	}

	if  ( cpTo->cpLeftBorderNumber != fromNumber )
	    { PROPmaskADD( &cpChgMask, CLpropLEFT_BORDER ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropRIGHT_BORDER ) )
	{
	int	fromNumber= cpFrom->cpRightBorderNumber;

	if  ( fromNumber >= 0 && dam && dam->damBorderMap )
	    { fromNumber= dam->damBorderMap[fromNumber];	}

	if  ( cpTo->cpRightBorderNumber != fromNumber )
	    { PROPmaskADD( &cpChgMask, CLpropRIGHT_BORDER ); }
	}

    /**/
    if  ( PROPmaskISSET( cpUpdMask, CLpropSHADING ) )
	{
	int		fromNumber= cpFrom->cpShadingNumber;

	if  ( fromNumber >= 0 && dam && dam->damShadingMap )
	    { fromNumber= dam->damShadingMap[fromNumber];	}

	if  ( cpTo->cpShadingNumber != fromNumber )
	    { PROPmaskADD( &cpChgMask, CLpropSHADING );	}
	}

    /**/
    if  ( PROPmaskISSET( cpUpdMask, CLpropCLW_WIDTH ) )
	{
	if  ( cpTo->cpPreferredWidth != cpFrom->cpPreferredWidth )
	    { PROPmaskADD( &cpChgMask, CLpropCLW_WIDTH );	}
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropCLFTS_WIDTH ) )
	{
	if  ( cpTo->cpPreferredWidthUnit != cpFrom->cpPreferredWidthUnit )
	    { PROPmaskADD( &cpChgMask, CLpropCLFTS_WIDTH );	}
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropLEFT_IN_MERGED ) )
	{
	if  ( cpTo->cpLeftInMergedRow != cpFrom->cpLeftInMergedRow )
	    { PROPmaskADD( &cpChgMask, CLpropLEFT_IN_MERGED ); }
	}

    /**/
    if  ( PROPmaskISSET( cpUpdMask, CLpropMERGED_WITH_LEFT ) )
	{
	if  ( cpTo->cpMergedWithLeft != cpFrom->cpMergedWithLeft )
	    { PROPmaskADD( &cpChgMask, CLpropMERGED_WITH_LEFT ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropTOP_IN_MERGED ) )
	{
	if  ( cpTo->cpTopInMergedColumn != cpFrom->cpTopInMergedColumn )
	    { PROPmaskADD( &cpChgMask, CLpropTOP_IN_MERGED ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropMERGED_WITH_ABOVE ) )
	{
	if  ( cpTo->cpMergedWithAbove != cpFrom->cpMergedWithAbove )
	    {
	    PROPmaskADD( &cpChgMask, CLpropMERGED_WITH_ABOVE );
	    }
	}

    /**/
    if  ( PROPmaskISSET( cpUpdMask, CLpropVALIGN ) )
	{
	if  ( cpTo->cpValign != cpFrom->cpValign )
	    { PROPmaskADD( &cpChgMask, CLpropVALIGN ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropTEXT_FLOW ) )
	{
	if  ( cpTo->cpTextFlow != cpFrom->cpTextFlow )
	    { PROPmaskADD( &cpChgMask, CLpropTEXT_FLOW ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropTOP_PADDING ) )
	{
	if  ( cpTo->cpTopPadding != cpFrom->cpTopPadding )
	    { PROPmaskADD( &cpChgMask, CLpropTOP_PADDING ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropBOTTOM_PADDING ) )
	{
	if  ( cpTo->cpBottomPadding != cpFrom->cpBottomPadding )
	    { PROPmaskADD( &cpChgMask, CLpropBOTTOM_PADDING ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropLEFT_PADDING ) )
	{
	if  ( cpTo->cpLeftPadding != cpFrom->cpLeftPadding )
	    { PROPmaskADD( &cpChgMask, CLpropLEFT_PADDING ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropRIGHT_PADDING ) )
	{
	if  ( cpTo->cpRightPadding != cpFrom->cpRightPadding )
	    { PROPmaskADD( &cpChgMask, CLpropRIGHT_PADDING ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropTOP_PADDING_UNIT ) )
	{
	if  ( cpTo->cpTopPaddingUnit != cpFrom->cpTopPaddingUnit )
	    { PROPmaskADD( &cpChgMask, CLpropTOP_PADDING_UNIT ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropBOTTOM_PADDING_UNIT ) )
	{
	if  ( cpTo->cpBottomPaddingUnit != cpFrom->cpBottomPaddingUnit )
	    { PROPmaskADD( &cpChgMask, CLpropBOTTOM_PADDING_UNIT ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropLEFT_PADDING_UNIT ) )
	{
	if  ( cpTo->cpLeftPaddingUnit != cpFrom->cpLeftPaddingUnit )
	    { PROPmaskADD( &cpChgMask, CLpropLEFT_PADDING_UNIT ); }
	}

    if  ( PROPmaskISSET( cpUpdMask, CLpropRIGHT_PADDING_UNIT ) )
	{
	if  ( cpTo->cpRightPaddingUnit != cpFrom->cpRightPaddingUnit )
	    { PROPmaskADD( &cpChgMask, CLpropRIGHT_PADDING_UNIT ); }
	}

    *pCpChgPask= cpChgMask; return;
    }

void docCopyCellProperties(	CellProperties *		cpTo,
				const CellProperties *		cpFrom,
				const DocumentAttributeMap *	dam )
    {
    PropertyMask		cpDoneMask;
    PropertyMask		cpSetMask;

    utilPropMaskClear( &cpDoneMask );
    utilPropMaskClear( &cpSetMask );

    utilPropMaskFill( &cpSetMask, CLprop_COUNT );

    docUpdCellProperties( &cpDoneMask, cpTo, &cpSetMask, cpFrom, dam );

    return;
    }

int docSetCellProperty(		CellProperties *	cp,
				int			prop,
				int			arg )
    {
    switch( prop )
	{
	case CLpropCELLX:
	    cp->cpRightBoundaryTwips= arg;
	    break;

	case CLpropTOP_BORDER:
	    cp->cpTopBorderNumber= arg;
	    break;
	case CLpropBOTTOM_BORDER:
	    cp->cpBottomBorderNumber= arg;
	    break;
	case CLpropLEFT_BORDER:
	    cp->cpLeftBorderNumber= arg;
	    break;
	case CLpropRIGHT_BORDER:
	    cp->cpRightBorderNumber= arg;
	    break;

	case CLpropSHADING:
	    cp->cpShadingNumber= arg;
	    break;
	case CLpropCLW_WIDTH:
	    cp->cpPreferredWidth= arg;
	    break;
	case CLpropCLFTS_WIDTH:
	    cp->cpPreferredWidthUnit= arg;
	    break;

	case CLpropLEFT_IN_MERGED:
	    cp->cpLeftInMergedRow= ( arg != 0 );
	    break;
	case CLpropMERGED_WITH_LEFT:
	    cp->cpMergedWithLeft= ( arg != 0 );
	    break;
	case CLpropTOP_IN_MERGED:
	    cp->cpTopInMergedColumn= ( arg != 0 );
	    break;
	case CLpropMERGED_WITH_ABOVE:
	    cp->cpMergedWithAbove= ( arg != 0 );
	    break;
	case CLpropNO_WRAP:
	    cp->cpNoWrap= ( arg != 0 );
	    break;

	case CLpropVALIGN:
	    cp->cpValign= arg;
	    break;
	case CLpropTEXT_FLOW:
	    cp->cpTextFlow= arg;
	    break;

	case CLpropTOP_PADDING:
	    cp->cpTopPadding= arg;
	    break;
	case CLpropBOTTOM_PADDING:
	    cp->cpBottomPadding= arg;
	    break;
	case CLpropLEFT_PADDING:
	    cp->cpLeftPadding= arg;
	    break;
	case CLpropRIGHT_PADDING:
	    cp->cpRightPadding= arg;
	    break;

	case CLpropTOP_PADDING_UNIT:
	    cp->cpTopPaddingUnit= arg;
	    break;
	case CLpropBOTTOM_PADDING_UNIT:
	    cp->cpBottomPaddingUnit= arg;
	    break;
	case CLpropLEFT_PADDING_UNIT:
	    cp->cpLeftPaddingUnit= arg;
	    break;
	case CLpropRIGHT_PADDING_UNIT:
	    cp->cpRightPaddingUnit= arg;
	    break;

	case CLpropNO_SHADING:
	    cp->cpNoShading= ( arg != 0 );
	    break;

	default:
	    LDEB(prop); return -1;
	}

    return 0;
    }

int docGetCellProperty(		const CellProperties *	cp,
				int			prop )
    {
    switch( prop )
	{
	case CLpropCELLX:
	    return cp->cpRightBoundaryTwips;
	    break;

	case CLpropTOP_BORDER:
	    return cp->cpTopBorderNumber;
	case CLpropBOTTOM_BORDER:
	    return cp->cpBottomBorderNumber;
	case CLpropLEFT_BORDER:
	    return cp->cpLeftBorderNumber;
	case CLpropRIGHT_BORDER:
	    return cp->cpRightBorderNumber;

	case CLpropSHADING:
	    return cp->cpShadingNumber;
	case CLpropCLW_WIDTH:
	    return cp->cpPreferredWidth;
	case CLpropCLFTS_WIDTH:
	    return cp->cpPreferredWidthUnit;

	case CLpropLEFT_IN_MERGED:
	    return cp->cpLeftInMergedRow;
	case CLpropMERGED_WITH_LEFT:
	    return cp->cpMergedWithLeft;
	case CLpropTOP_IN_MERGED:
	    return cp->cpTopInMergedColumn;
	case CLpropMERGED_WITH_ABOVE:
	    return cp->cpMergedWithAbove;
	case CLpropNO_WRAP:
	    return cp->cpNoWrap;

	case CLpropVALIGN:
	    return cp->cpValign;
	case CLpropTEXT_FLOW:
	    return cp->cpTextFlow;

	case CLpropTOP_PADDING:
	    return cp->cpTopPadding;
	case CLpropBOTTOM_PADDING:
	    return cp->cpBottomPadding;
	case CLpropLEFT_PADDING:
	    return cp->cpLeftPadding;
	case CLpropRIGHT_PADDING:
	    return cp->cpRightPadding;

	case CLpropTOP_PADDING_UNIT:
	    return cp->cpTopPaddingUnit;
	case CLpropBOTTOM_PADDING_UNIT:
	    return cp->cpBottomPaddingUnit;
	case CLpropLEFT_PADDING_UNIT:
	    return cp->cpLeftPaddingUnit;
	case CLpropRIGHT_PADDING_UNIT:
	    return cp->cpRightPaddingUnit;

	case CLpropNO_SHADING:
	    return cp->cpNoShading;

	default:
	    LDEB(prop); return -1;
	}
    }
