/************************************************************************/
/*									*/
/*  Text Editor Buffer structure of a (table) cell.			*/
/*									*/
/************************************************************************/

#   ifndef	DOC_CELL_ITEM_H
#   define	DOC_CELL_ITEM_H

#   include	"docLayoutPosition.h"

/************************************************************************/
/*									*/
/*  A Cell.								*/
/*									*/
/************************************************************************/

typedef struct CellItem
    {
    int				bcTopInset;
    int				bcIsMergedWithBelow;
    int				bcMergedCellTopRow;
    int				bcMergedCellTopCol;
    } CellItem;

/************************************************************************/
/*									*/
/*  Shortcut defines through the BufferItem union.			*/
/*									*/
/************************************************************************/

#	define biCellTopInset		BIU.biuCell.bcTopInset
				/****************************************/
				/*  Used for the vertical alignment of	*/
				/*  table cells: The first line of the	*/
				/*  first paragraph is shifted by this	*/
				/*  amount.				*/
				/****************************************/

#	define	biCellIsMergedWithBelow	BIU.biuCell.bcIsMergedWithBelow
#	define	biCellMergedCellTopRow	BIU.biuCell.bcMergedCellTopRow
#	define	biCellMergedCellTopCol	BIU.biuCell.bcMergedCellTopCol
/*
#	define	biCellBelowAllPosition	BIU.biuCell.bcBelowAllPosition
*/

#   endif
