#   include	"bitmapConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	"bmintern.h"
#   include	<utilEndian.h>
#   include	<appDebugon.h>

typedef unsigned long CARD32;
typedef unsigned short CARD16;
typedef unsigned char CARD8;

# define B32 /*nothing*/
# define B16 /*nothing*/
# define B8 /*nothing*/

#define StaticGray		0
#define GrayScale		1
#define StaticColor		2
#define PseudoColor		3
#define TrueColor		4
#define DirectColor		5

#define LSBFirst		0
#define MSBFirst		1

#   include	"XWDFile.h"

/************************************************************************/
/*  Implementing routines.						*/
/************************************************************************/
static int bmReadX11wd(	FILE *			f,
			XWDFileHeader *		xh,
			unsigned char **	pBuf,
			BitmapDescription *	bd );

/************************************************************************/
/*  Read an XWD file.							*/
/************************************************************************/
int bmReadXwdFile(	const char *		filename,
			unsigned char **	pBuf,
			BitmapDescription *	bd,
			int *			pPrivateFormat )
    {
    FILE *		f;
    int			rval= 0;
    int			privateFormat= -1;

    XWDFileHeader	x11Header;

    f= fopen( filename, "rb" );
    if  ( ! f )
	{ SXDEB(filename,f); return -1;	}

    /***************/
    x11Header.header_size= utilGetBeInt32( f );
    x11Header.file_version= utilGetBeInt32( f );
    x11Header.pixmap_format= utilGetBeInt32( f );
    x11Header.pixmap_depth= utilGetBeInt32( f );
    x11Header.pixmap_width= utilGetBeInt32( f );
    x11Header.pixmap_height= utilGetBeInt32( f );
    x11Header.xoffset= utilGetBeInt32( f );
    x11Header.byte_order= utilGetBeInt32( f );
    x11Header.bitmap_unit= utilGetBeInt32( f );
    x11Header.bitmap_bit_order= utilGetBeInt32( f );
    x11Header.bitmap_pad= utilGetBeInt32( f );
    x11Header.bits_per_pixel= utilGetBeInt32( f );
    x11Header.bytes_per_line= utilGetBeInt32( f );
    x11Header.visual_class= utilGetBeInt32( f );
    x11Header.red_mask= utilGetBeInt32( f );
    x11Header.green_mask= utilGetBeInt32( f );
    x11Header.blue_mask= utilGetBeInt32( f );
    x11Header.bits_per_rgb= utilGetBeInt32( f );
    x11Header.colormap_entries= utilGetBeInt32( f );
    x11Header.ncolors= utilGetBeInt32( f );
    x11Header.window_width= utilGetBeInt32( f );
    x11Header.window_height= utilGetBeInt32( f );
    x11Header.window_x= utilGetBeInt32( f );
    x11Header.window_y= utilGetBeInt32( f );
    x11Header.window_bdrwidth= utilGetBeInt32( f );
    /***************/

    switch( x11Header.file_version )
	{
	case XWD_FILE_VERSION:
	    privateFormat= 11;
	    rval= bmReadX11wd( f, &x11Header, pBuf, bd );
	    break;
	case XWD_FILE_VERSION << 24:
	    XDEB(x11Header.file_version); fclose( f ); return -1;
	default:
	    XDEB(x11Header.file_version); fclose( f ); return -1;
	}

    fclose( f );

    if  ( ! rval )
	{ *pPrivateFormat= privateFormat;	}

    return rval;
    }

/************************************************************************/
/*									*/
/*  Read an X11 window dump file.					*/
/*									*/
/************************************************************************/

static int bmReadX11wd(	FILE *			f,
			XWDFileHeader *		xh,
			unsigned char **	pBuf,
			BitmapDescription *	bd )
    {
    int			rval= 0;

    int			row;
    int			col;

    unsigned char *	buf= (unsigned char *)0;
    unsigned char *	to;

    unsigned long	rm= 0, gm= 0, bm= 0;
    int			rs= 0, gs= 0, bs= 0;
    XWDColor *		colors= (XWDColor *)0;
    RGB8Color *		pal= (RGB8Color *)0;

    /*  skip name */
    if  ( xh->header_size > (unsigned long)ftell( f ) )
	{ fseek( f, (long)(xh->header_size - ftell( f ) ), SEEK_CUR ); }

    if  ( xh->ncolors > 0 )
	{
	unsigned int	cp;

	colors= (XWDColor *)malloc( xh->ncolors* sizeof(XWDColor) );
	if  ( ! colors )
	    { LXDEB(xh->ncolors,colors); rval= -1; goto ready;	}

	for ( cp= 0; cp < xh->ncolors; cp++ )
	    {
	    colors[cp].pixel= utilGetBeInt32( f );
	    colors[cp].red= utilGetBeInt16( f );
	    colors[cp].green= utilGetBeInt16( f );
	    colors[cp].blue= utilGetBeInt16( f );
	    colors[cp].flags= getc( f );
	    colors[cp].pad= getc( f );
	    }
	}

    bd->bdPixelsWide= xh->pixmap_width;
    bd->bdPixelsHigh= xh->pixmap_height;

    bd->bdUnit= BMunPIXEL;
    bd->bdXResolution= 1;
    bd->bdYResolution= 1;

    switch( xh->visual_class )
	{
	int	cp;

	case StaticGray:
	case GrayScale:
	    if  ( xh->bits_per_pixel == 1 )
		{ bd->bdColorEncoding= BMcoBLACKWHITE;	}
	    else{ bd->bdColorEncoding= BMcoWHITEBLACK;	}

	    bd->bdSamplesPerPixel= 1;

	    bd->bdUnit= BMunPIXEL;
	    bd->bdXResolution= 1;
	    bd->bdYResolution= 1;

	    break;

	case StaticColor:
	case PseudoColor:
	    bd->bdColorEncoding= BMcoRGB8PALETTE;
	    bd->bdBitsPerSample= 8;
	    bd->bdSamplesPerPixel= 3;
	    bd->bdColorCount= xh->ncolors;

	    pal= (RGB8Color *)malloc( xh->ncolors* sizeof(RGB8Color) );
	    if  ( ! pal )
		{ LLDEB(xh->ncolors,pal); rval= -1; goto ready;	}

	    for ( cp= 0; cp < xh->ncolors; cp++ )
		{
		pal[cp].rgb8Red= colors[cp].red/256;
		pal[cp].rgb8Green= colors[cp].green/256;
		pal[cp].rgb8Blue= colors[cp].blue/256;
		pal[cp].rgb8Alpha= 255;
		}

	    break;

	case TrueColor:
	case DirectColor:
	    bd->bdColorEncoding= BMcoRGB;
	    bd->bdBitsPerSample= xh->bits_per_rgb;
	    bd->bdSamplesPerPixel= 3;

	    rm= xh->red_mask;
	    if  ( rm == 0 )
		{ LDEB(rm); rval= -1; goto ready;	}
	    else{
		while( ! ( rm & 1 ) )
		    { rm >>= 1; rs++; }
		}

	    gm= xh->green_mask;
	    if  ( gm == 0 )
		{ LDEB(gm); rval= -1; goto ready;	}
	    else{
		while( ! ( gm & 1 ) )
		    { gm >>= 1; gs++; }
		}

	    bm= xh->blue_mask;
	    if  ( bm == 0 )
		{ LDEB(bm); rval= -1; goto ready;	}
	    else{
		while( ! ( bm & 1 ) )
		    { bm >>= 1; bs++; }
		}

	    if  ( xh->ncolors > 0			&&
	    	  ( xh->ncolors < rm+ 1		||
		    xh->ncolors < gm+ 1		||
		    xh->ncolors < bm+ 1		)	)
		{ LLLLDEB(xh->ncolors,rm,gm,bm); rval= -1; goto ready;	}
	    break;
	}

    switch( xh->bits_per_pixel )
	{
	case 1:
	    if  ( bd->bdColorEncoding != BMcoBLACKWHITE )
		{ LDEB(bd->bdColorEncoding); rval= -1; goto ready;	}

	    bd->bdBufferLength= xh->bytes_per_line* xh->pixmap_height;
	    bd->bdBitsPerSample= 1;
	    bd->bdBytesPerRow= xh->bytes_per_line;
	    bd->bdBitsPerPixel= xh->bits_per_pixel;

	    buf= (unsigned char *)malloc( bd->bdBufferLength );
	    if  ( ! buf )
		{ LLDEB(bd->bdBufferLength,buf); rval= -1; goto ready; }

	    if  ( fread( buf, 1, bd->bdBufferLength, f ) !=
							bd->bdBufferLength )
		{ LDEB(bd->bdBufferLength); rval= -1; goto ready; }
	    break;

	case	8:
	    if  ( bd->bdColorEncoding != BMcoRGB8PALETTE	&&
		  bd->bdColorEncoding != BMcoWHITEBLACK		)
		{ LDEB(bd->bdColorEncoding); rval= -1; goto ready;	}

	    bd->bdBufferLength= xh->bytes_per_line* xh->pixmap_height;
	    bd->bdBytesPerRow= xh->bytes_per_line;
	    bd->bdBitsPerPixel= xh->bits_per_pixel;

	    buf= (unsigned char *)malloc( bd->bdBufferLength );
	    if  ( ! buf )
		{ LLDEB(bd->bdBufferLength,buf); rval= -1; }
	    else{
		if  ( fread( buf, 1, bd->bdBufferLength, f ) !=
							bd->bdBufferLength )
		    { LDEB(bd->bdBufferLength); rval= -1; goto ready; }
		}

	    if  ( bd->bdColorEncoding == BMcoRGB8PALETTE )
		{ bd->bdRGB8Palette= pal; pal= (RGB8Color *)0; /* steal */ }
	    else{
		if  ( xh->ncolors > 0 )
		    {
		    if  ( xh->ncolors != 256 )
			{ LDEB(xh->ncolors); rval= -1; goto ready;	}

		    to= buf;
		    for ( col= 0; col < bd->bdBufferLength; col++ )
			{ *to= colors[*to].green/256; to++;	}
		    }
		}
	    break;

	case	16:
	    if  ( bd->bdColorEncoding != BMcoRGB )
		{ LDEB(bd->bdColorEncoding); rval= -1; goto ready;	}

	    bd->bdBitsPerSample= 8;
	    bd->bdSamplesPerPixel= 3;

	    bmCalculateSizes( bd );

	    to= buf= (unsigned char *)malloc( bd->bdBufferLength );
	    if  ( ! buf )
		{ LLDEB(bd->bdBufferLength,buf); rval= -1; }

	    for ( row= 0; row < bd->bdPixelsHigh; row++ )
		{
		int	got= 0;

		for ( col= 0; col < xh->xoffset; col++ )
		    { getc( f );	}
		got += xh->xoffset;

		for ( col= 0; col < bd->bdPixelsWide; col++ )
		    {
		    unsigned long	pix;
		    int			r, g, b;

		    if  ( xh->byte_order == LSBFirst )
			{ pix= utilGetLeInt16( f );	}
		    else{ pix= utilGetBeInt16( f );	}

		    r= ( pix >> rs ) & rm;
		    g= ( pix >> gs ) & gm;
		    b= ( pix >> bs ) & bm;

		    if  ( xh->ncolors > 0 )
			{
			*(to++)= colors[r].red/ 256;
			*(to++)= colors[g].green/ 256;
			*(to++)= colors[b].blue/ 256;
			}
		    else{
			*(to++)= ( 256* r )/ rm;
			*(to++)= ( 256* g )/ gm;
			*(to++)= ( 256* b )/ bm;
			}

		    got += 2;
		    }

		while( got < xh->bytes_per_line )
		    { getc( f ); got++;	}
		}

	    break;

	case	32:
	    if  ( bd->bdColorEncoding != BMcoRGB )
		{ LDEB(bd->bdColorEncoding); rval= -1; goto ready;	}

	    bd->bdBitsPerSample= 8;
	    bd->bdSamplesPerPixel= 3;

	    bmCalculateSizes( bd );

	    to= buf= (unsigned char *)malloc( bd->bdBufferLength );
	    if  ( ! buf )
		{ LLDEB(bd->bdBufferLength,buf); rval= -1; }

	    for ( row= 0; row < bd->bdPixelsHigh; row++ )
		{
		int	got= 0;

		for ( col= 0; col < xh->xoffset; col++ )
		    { getc( f );	}
		got += xh->xoffset;

		for ( col= 0; col < bd->bdPixelsWide; col++ )
		    {
		    unsigned long	pix;
		    int			r, g, b;

		    if  ( xh->byte_order == LSBFirst )
			{ pix= utilGetLeInt32( f );	}
		    else{ pix= utilGetBeInt32( f );	}

		    r= ( pix >> rs ) & rm;
		    g= ( pix >> gs ) & gm;
		    b= ( pix >> bs ) & bm;

		    if  ( xh->ncolors > 0 )
			{
			*(to++)= colors[r].red/ 256;
			*(to++)= colors[g].green/ 256;
			*(to++)= colors[b].blue/ 256;
			}
		    else{
			*(to++)= ( 256* r )/ rm;
			*(to++)= ( 256* g )/ gm;
			*(to++)= ( 256* b )/ bm;
			}

		    got += 4;
		    }

		while( got < xh->bytes_per_line )
		    { getc( f ); got++;	}
		}

	    break;

	default:
	    LLLDEB(xh->bits_per_pixel,xh->bitmap_unit,xh->bits_per_rgb);
	    rval= -1; goto ready;
	}

    *pBuf= buf; buf= (unsigned char *)0; /* steal */

  ready:

    if  ( buf )
	{ free( buf );	}

    if  ( pal )
	{ free( pal );	}

    if  ( colors )
	{ free( colors );	}

    return rval;
    }

/************************************************************************/
/*									*/
/*  Write an XWD file.							*/
/*									*/
/************************************************************************/

int bmWriteXwdFile(	const char *			filename,
			const unsigned char *		buffer,
			const BitmapDescription *	bd,
			int				privateFormat )
    { LDEB(-1); return -1; }
