/************************************************************************/
/*									*/
/*  Convert text from/to UTF-8 using iconv.				*/
/*									*/
/************************************************************************/

#   ifndef	UTIL_TEXT_CONVERTER_H
#   define	UTIL_TEXT_CONVERTER_H

#   include	<iconv.h>

typedef struct TextConverter
    {
    char *		tcNativeEncodingName;
    iconv_t		tcIconvToUtf8;
    iconv_t		tcIconvFrUtf8;
    } TextConverter;

/************************************************************************/
/*									*/
/*  Convert bytes.. Return the size of the result.			*/
/*									*/
/************************************************************************/

typedef int (*TextConverterProduce)(	void *			through,
					int			produced,
					const char *		bytes,
					int			count );

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void utilTextConverterSetNativeEncodingName(
					TextConverter *	tc,
					const char *	encodingName );

extern void utilInitTextConverter(	TextConverter *	tc );
extern void utilCleanTextConverter(	TextConverter *	tc );

extern int utilTextConverterConvertToUtf8(
					TextConverter *		tc,
					void *			through,
					TextConverterProduce	produce,
					int *			pConsumed,
					int			produced,
					const char *		text,
					int			len );

extern int utilTextConverterConvertFromUtf8(
					TextConverter *		tc,
					void *			through,
					TextConverterProduce	produce,
					int *			pConsumed,
					int			produced,
					const char *		text,
					int			len );

#   endif
