/************************************************************************/
/*									*/
/*  Manage a lookup to keep track of text attributes.			*/
/*									*/
/************************************************************************/

#   ifndef	UTIL_TEXT_ATTRIBUTE_ADMIN_H
#   define	UTIL_TEXT_ATTRIBUTE_ADMIN_H

#   include	<utilTextAttribute.h>
#   include	<utilIntegerValueNode.h>
#   include	<utilNumberedPropertiesAdmin.h>

typedef void (*TextAttributeFunction)(	const TextAttribute *	ta,
					int			n,
					void *			through );

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void utilInitTextAttributeList(	NumberedPropertiesList *	tal );

extern int utilTextAttributeNumber(	NumberedPropertiesList *	tal,
					const TextAttribute *		ta );

extern void utilGetTextAttributeByNumber(
					TextAttribute *			ta,
					const NumberedPropertiesList *	tal,
					int				n );

extern void utilForAllTextAttributes(
				const NumberedPropertiesList *	tal,
				TextAttributeFunction		f,
				void *				through );

#   endif	/*  UTIL_TEXT_ATTRIBUTE_ADMIN_H	*/
