/************************************************************************/
/*									*/
/*  An array of bytes and its (maximum) size.				*/
/*									*/
/************************************************************************/

#   ifndef	UTIL_MEMORY_H
#   define	UTIL_MEMORY_H

typedef struct MemoryBuffer
    {
    int			mbSize;
    unsigned char *	mbBytes;
    } MemoryBuffer;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void utilInitMemoryBuffer(	MemoryBuffer *	mb );
extern void utilEmptyMemoryBuffer(	MemoryBuffer *	mb );
extern void utilCleanMemoryBuffer(	MemoryBuffer *	mb );

extern int utilSizeMemoryBuffer(	MemoryBuffer *	mb,
					int		size );

extern int utilSetMemoryBuffer(	MemoryBuffer *		mb,
				const unsigned char *	bytes,
				int			size );

extern int utilAddToMemoryBuffer(	MemoryBuffer *		mb,
					const unsigned char *	bytes,
					int			size );

extern int utilCopyMemoryBuffer(	MemoryBuffer *		mbTo,
					const MemoryBuffer *	mbFrom );

extern const unsigned char * utilMemoryBufferGetBytes(
					int *			pSize,
					const MemoryBuffer *	mbFrom );

extern int utilMemoryCompareBuffers(	const MemoryBuffer *	mb1,
					const MemoryBuffer *	mb2 );

# define utilEqualMemoryBuffer( mb1, mb2 ) \
			    ( utilMemoryCompareBuffers( (mb1), (mb2) ) == 0 )

extern int utilMemoryAppendBuffer(	MemoryBuffer *		to,
					const MemoryBuffer *	from );

extern int utilMemoryBufferReplaceBytes( int *			pSizeShift,
					MemoryBuffer *		mb,
					int			offBegin,
					int			offEnd,
					const unsigned char *	addedBytes,
					int			addedCount );

extern int utilMemoryBufferGetRange(	MemoryBuffer *		mbTo,
					const MemoryBuffer *	mbFrom,
					int			offFrom,
					int			lenFrom );

#   endif	/*  UTIL_MEMORY_H	*/
