/************************************************************************/
/*									*/
/*  Map Unicode values to glyph numbers.				*/
/*									*/
/************************************************************************/

#   include	"appUtilConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<string.h>

#   include	"utilIndexMapping.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Bookkeeping.							*/
/*									*/
/************************************************************************/

void utilInitIndexMapping(	IndexMapping *	im )
    {
    im->tgmPages= (int **)0;
    im->tgmPageCount= 0;
    }

void utilCleanIndexMapping(	IndexMapping *	im )
    {
    int		i;

    for ( i= 0; i < im->tgmPageCount; i++ )
	{
	if  ( im->tgmPages[i] )
	    { free( im->tgmPages[i] );	}
	}

    if  ( im->tgmPages )
	{ free( im->tgmPages );	}
    }

/************************************************************************/
/*									*/
/*  Map a unicode value to a glyph index.				*/
/*									*/
/************************************************************************/

int  utilIndexMappingPut(	IndexMapping *	im,
			int			from,
			int			to )
    {
    int		page;
    int		idx;

    if  ( from < 0 || to < 0 || from >= 256* 256 || to >= 256* 256 )
	{ XLDEB(from,to); return -1;	}

    page= from/ TGM_PSZ;
    idx=  from% TGM_PSZ;

    if  ( page >= im->tgmPageCount )
	{
	int **		pages;

	pages= realloc( im->tgmPages, (page+ 1)* sizeof(int *) );
	if  ( ! pages )
	    { LXDEB(page,pages); return -1;	}
	im->tgmPages= pages;

	while( im->tgmPageCount <= page )
	    { im->tgmPages[im->tgmPageCount++]= (int *)0; }
	}

    if  ( ! im->tgmPages[page] )
	{
	int		i;
	int *		fresh;

	fresh= malloc( TGM_PSZ* sizeof(int) );
	if  ( ! fresh )
	    { XDEB(fresh); return -1;	}

	for ( i= 0; i < TGM_PSZ; i++ )
	    { fresh[i]= -1;	}

	im->tgmPages[page]= fresh;
	}

    im->tgmPages[page][idx]= to;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Construct a backward mapping for an array of unicode code points.	*/
/*									*/
/************************************************************************/

int utilIndexMappingBuildBackward(	IndexMapping *		im,
					const int *		forward,
					int			forwardCount )
    {
    int		g;

    for ( g= 0; g < forwardCount; g++ )
	{
	if  ( forward[g] >= 0				&&
	      utilIndexMappingPut( im, forward[g], g )	)
	    { LLDEB(g,forward[g]);	}
	}

    return 0;
    }
