#   include	"appUtilConfig.h"

#   include	<utilColor.h>
#   include	<string.h>
#   include	<stdlib.h>

#   include	<math.h>

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Initialize an RGB8Color.						*/
/*									*/
/************************************************************************/

void bmInitRGB8Color(	RGB8Color *	rgb8 )
    {
    rgb8->rgb8Red= 0;
    rgb8->rgb8Green= 0;
    rgb8->rgb8Blue= 0;
    rgb8->rgb8Alpha= 255;

    return;
    }

/************************************************************************/
/*									*/
/*  RGB -> IHS conversion.						*/
/*									*/
/************************************************************************/

#   define	F_R	77
#   define	F_G	150
#   define	F_B	29

int bmRgbIntensity(	const RGB8Color *	rgb8 )
    {
    return ( F_R* rgb8->rgb8Red+ F_G* rgb8->rgb8Green+ F_B* rgb8->rgb8Blue )/ 
							    ( F_R+ F_G+ F_B );
    }

int bmRgbSaturation(	const RGB8Color *	rgb8 )
    {
    int		i;
    int		mi= 256;

    i= ( rgb8->rgb8Red+ rgb8->rgb8Green+ rgb8->rgb8Blue )/ 3;

    if  ( mi > rgb8->rgb8Red )
	{ mi=  rgb8->rgb8Red;	}
    if  ( mi > rgb8->rgb8Green )
	{ mi=  rgb8->rgb8Green;	}
    if  ( mi > rgb8->rgb8Blue )
	{ mi=  rgb8->rgb8Blue;	}

    return 255- mi/i;
    }

int bmRgbHue(	const RGB8Color *	rgb8 )
    {
    int		RmG= rgb8->rgb8Red- rgb8->rgb8Green;
    int		RmB= rgb8->rgb8Red- rgb8->rgb8Blue;
    int		GmB= rgb8->rgb8Green- rgb8->rgb8Blue;

    double	above;
    double	below;
    double	res;

    if  ( RmG == 0 && RmB == 0 )
	{ return 0;	}

    above= RmG+ RmB;
    below=  2.0* sqrt( RmG* RmG+ RmB* GmB );
    res= ( 255.0* acos( above/ below ) )/ ( 2* M_PI );

    if  ( below == 0 )
	{ FFDEB(above,below); return 0; }

    return res;
    }

int bmRgb8GetComponent(	const RGB8Color *	rgb8,
			int			prop )
    {
    switch( prop )
	{
	case RGBAcompRED:
	    return rgb8->rgb8Red;
	case RGBAcompGREEN:
	    return rgb8->rgb8Green;
	case RGBAcompBLUE:
	    return rgb8->rgb8Blue;
	case RGBAcompALPHA:
	    return rgb8->rgb8Alpha;

	default:
	    LDEB(prop); return -1;
	}
    }
