#   include	"appUtilConfig.h"

#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<string.h>

#   include	"utilCharacterKinds.h"
#   include	<charnames.h>

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Remember the character classification information for a particular	*/
/*  character set encoding.						*/
/*									*/
/************************************************************************/

void utilSetLatin1CharacterKinds(	unsigned char	charKinds[256],
					unsigned char	charShifts[256] )
    {
    int		i;

    for ( i= 0; i < 256; i++ )
	{
	if  ( ISO1_islower( i ) )
	    {
	    charKinds[i] |= CHARisLOWER;
	    if  ( ! ISO1_isupper( i ) )
		{ charShifts[i]= ISO1_toupper( i );	}
	    }

	if  ( ISO1_isupper( i ) )
	    {
	    charKinds[i] |= CHARisUPPER;
	    if  ( ! ISO1_islower( i ) )
		{ charShifts[i]= ISO1_tolower( i );	}
	    }

	if  ( ISO1_isdigit( i ) )
	    { charKinds[i] |= CHARisDIGIT;	}
	}

    return;
    }

void utilSetLatin15CharacterKinds(	unsigned char	charKinds[256],
					unsigned char	charShifts[256] )
    {
    int		i;

    for ( i= 0; i < 256; i++ )
	{
	if  ( ISO15_islower( i ) )
	    {
	    charKinds[i] |= CHARisLOWER;
	    if  ( ! ISO15_isupper( i ) )
		{ charShifts[i]= ISO15_toupper( i );	}
	    }

	if  ( ISO15_isupper( i ) )
	    {
	    charKinds[i] |= CHARisUPPER;
	    if  ( ! ISO15_islower( i ) )
		{ charShifts[i]= ISO15_tolower( i );	}
	    }

	if  ( ISO15_isdigit( i ) )
	    { charKinds[i] |= CHARisDIGIT;	}
	}

    return;
    }

void utilSetLatin2CharacterKinds(	unsigned char	charKinds[256],
					unsigned char	charShifts[256] )
    {
    int		i;

    for ( i= 0; i < 256; i++ )
	{
	if  ( ISO2_islower( i ) )
	    {
	    charKinds[i] |= CHARisLOWER;
	    if  ( ! ISO2_isupper( i ) )
		{ charShifts[i]= ISO2_toupper( i );	}
	    }

	if  ( ISO2_isupper( i ) )
	    {
	    charKinds[i] |= CHARisUPPER;
	    if  ( ! ISO2_islower( i ) )
		{ charShifts[i]= ISO2_tolower( i );	}
	    }

	if  ( ISO2_isdigit( i ) )
	    { charKinds[i] |= CHARisDIGIT;	}
	}

    return;
    }

void utilSetLatin5CharacterKinds(	unsigned char	charKinds[256],
					unsigned char	charShifts[256] )
    {
    int		i;

    for ( i= 0; i < 256; i++ )
	{
	if  ( ISO5_islower( i ) )
	    {
	    charKinds[i] |= CHARisLOWER;
	    if  ( ! ISO5_isupper( i ) )
		{ charShifts[i]= ISO5_toupper( i );	}
	    }

	if  ( ISO5_isupper( i ) )
	    {
	    charKinds[i] |= CHARisUPPER;
	    if  ( ! ISO5_islower( i ) )
		{ charShifts[i]= ISO5_tolower( i );	}
	    }

	if  ( ISO5_isdigit( i ) )
	    { charKinds[i] |= CHARisDIGIT;	}
	}

    return;
    }

void utilSetLatin7CharacterKinds(	unsigned char	charKinds[256],
					unsigned char	charShifts[256] )
    {
    int		i;

    for ( i= 0; i < 256; i++ )
	{
	if  ( ISO7_islower( i ) )
	    {
	    charKinds[i] |= CHARisLOWER;
	    if  ( ! ISO7_isupper( i ) )
		{ charShifts[i]= ISO7_toupper( i );	}
	    }

	if  ( ISO7_isupper( i ) )
	    {
	    charKinds[i] |= CHARisUPPER;
	    if  ( ! ISO7_islower( i ) )
		{ charShifts[i]= ISO7_tolower( i );	}
	    }

	if  ( ISO7_isdigit( i ) )
	    { charKinds[i] |= CHARisDIGIT;	}
	}

    return;
    }

void utilSetLatin9CharacterKinds(	unsigned char	charKinds[256],
					unsigned char	charShifts[256] )
    {
    int		i;

    for ( i= 0; i < 256; i++ )
	{
	if  ( ISO9_islower( i ) )
	    {
	    charKinds[i] |= CHARisLOWER;
	    if  ( ! ISO9_isupper( i ) )
		{ charShifts[i]= ISO9_toupper( i );	}
	    }

	if  ( ISO9_isupper( i ) )
	    {
	    charKinds[i] |= CHARisUPPER;
	    if  ( ! ISO9_islower( i ) )
		{ charShifts[i]= ISO9_tolower( i );	}
	    }

	if  ( ISO9_isdigit( i ) )
	    { charKinds[i] |= CHARisDIGIT;	}
	}

    return;
    }

void utilSetLatin13CharacterKinds(	unsigned char	charKinds[256],
					unsigned char	charShifts[256] )
    {
    int		i;

    for ( i= 0; i < 256; i++ )
	{
	if  ( ISO13_islower( i ) )
	    {
	    charKinds[i] |= CHARisLOWER;
	    if  ( ! ISO13_isupper( i ) )
		{ charShifts[i]= ISO13_toupper( i );	}
	    }

	if  ( ISO13_isupper( i ) )
	    {
	    charKinds[i] |= CHARisUPPER;
	    if  ( ! ISO13_islower( i ) )
		{ charShifts[i]= ISO13_tolower( i );	}
	    }

	if  ( ISO13_isdigit( i ) )
	    { charKinds[i] |= CHARisDIGIT;	}
	}

    return;
    }

void utilSetKoi8rCharacterKinds(	unsigned char	charKinds[256],
					unsigned char	charShifts[256] )
    {
    int		i;

    for ( i= 0; i < 256; i++ )
	{
	if  ( KOI8R_islower( i ) )
	    {
	    charKinds[i] |= CHARisLOWER;
	    if  ( ! KOI8R_isupper( i ) )
		{ charShifts[i]= KOI8R_toupper( i );	}
	    }

	if  ( KOI8R_isupper( i ) )
	    {
	    charKinds[i] |= CHARisUPPER;
	    if  ( ! KOI8R_islower( i ) )
		{ charShifts[i]= KOI8R_tolower( i );	}
	    }

	if  ( KOI8R_isdigit( i ) )
	    { charKinds[i] |= CHARisDIGIT;	}
	}

    return;
    }

void utilSetSymbolCharacterKinds(	unsigned char	charKinds[256],
					unsigned char	charShifts[256] )
    {
    int		i;

    for ( i= 0; i < 256; i++ )
	{
	if  ( PSSYM_islower( i ) )
	    {
	    charKinds[i] |= CHARisLOWER;
	    if  ( ! PSSYM_isupper( i ) )
		{ charShifts[i]= PSSYM_toupper( i );	}
	    }

	if  ( PSSYM_isupper( i ) )
	    {
	    charKinds[i] |= CHARisUPPER;
	    if  ( ! PSSYM_islower( i ) )
		{ charShifts[i]= PSSYM_tolower( i );	}
	    }

	if  ( PSSYM_isdigit( i ) )
	    { charKinds[i] |= CHARisDIGIT;	}
	}

    return;
    }

