#####################################################################
##
##   Look for zlib
##
#####################################################################

AC_DEFUN(AC_PATH_ZLIB,
[
    echo Checking for zlib...

    ZLIB_CFLAGS=
    ZLIB_LIBS=
    ZLIB_STATIC_REF=
    ZLIB_SHARED_REF=

    ZLIB_FOUND=0

    ac_zlib_includes=${ac_zlib_includes:-NO}
    ac_zlib_libraries=${ac_zlib_libraries:-NO}
    ac_zlib_static_lib=NO
    ac_zlib_shared_lib=NO

    if  test $ac_zlib_includes = "NO"
    then
	# Includes
	for ac_dir in		\
	    /usr/include		\
	    /usr/local/include	\
	    /usr/pkg/include	\
	    /usr/local/include/zlib	\
	    /usr/apps/include	\
	    ../zlib
	do
	if  test -r "$ac_dir/zlib.h"
	    then
		ac_zlib_includes=$ac_dir
		break
	    fi
	done
    fi

    if  test $ac_zlib_libraries = "NO"
    then
	# Libraries
	for ac_dir in		\
	    /usr/lib		\
	    /usr/local/lib		\
	    /usr/pkg/lib		\
	    /usr/local/lib/zlib	\
	    /usr/apps/lib		\
	    ../zlib
	do
	found=no

	if  test -r "$ac_dir/libz.a"
	    then
		ac_zlib_libraries=$ac_dir
		ac_zlib_static_lib=$ac_dir/libz.a
		found=yes
		break
	    fi

	if  test -r "$ac_dir/libz.so"
	    then
		ac_zlib_libraries=$ac_dir
		ac_zlib_shared_lib=$ac_dir/libz.so
		found=yes
		break
	    fi

	if  test -r "$ac_dir/libz.dylib"
	    then
		ac_zlib_libraries=$ac_dir
		ac_zlib_shared_lib=$ac_dir/libz.dylib
		found=yes
		break
	    fi

	if  test $found = yes
	    then
		break
	    fi

	done
    fi

    #echo Includes : $ac_zlib_includes
    #echo Libraries: $ac_zlib_libraries

    if  test $ac_zlib_includes = NO
    then
	ZLIB_FOUND=0
	AC_DEFINE(ZLIB_FOUND,0)
    else
	ZLIB_FOUND=1
	AC_DEFINE(ZLIB_FOUND,1)
	ZLIB_CFLAGS=-I$ac_zlib_includes

	if  test "$ZLIB_CFLAGS" = "-I/usr/include"
	then
	    ZLIB_CFLAGS=
	fi
    fi

    if  test $ac_zlib_libraries != NO
    then
	ZLIB_LIBS="-L$ac_zlib_libraries"
    fi

    if  test $ac_zlib_static_lib != NO
    then
	ZLIB_STATIC_REF="$ac_zlib_static_lib"
    else
	ZLIB_STATIC_REF="$ZLIB_LIBS -lz"
    fi

    ZLIB_SHARED_REF="$ZLIB_LIBS -lz"

    AC_SUBST(ZLIB_CFLAGS)dnl
    AC_SUBST(ZLIB_LIBS)dnl
    AC_SUBST(ZLIB_STATIC_REF)dnl
    AC_SUBST(ZLIB_SHARED_REF)dnl
    AC_SUBST(ZLIB_FOUND)dnl
])
#####################################################################
##
##   Look for iconv
##
#####################################################################

AC_DEFUN(AC_PATH_ICONV,
[
    echo Checking for iconv...

    ICONV_CFLAGS=
    ICONV_LIBS=
    ICONV_STATIC_REF=
    ICONV_SHARED_REF=

    ICONV_FOUND=0

    ac_iconv_includes=${ac_iconv_includes:-NO}
    ac_iconv_libraries=${ac_iconv_libraries:-NO}
    ac_iconv_static_lib=NO
    ac_iconv_shared_lib=NO

    if  test $ac_iconv_includes = "NO"
    then
	# Includes
	for ac_dir in			\
	    /usr/include		\
	    /usr/local/include		\
	    /usr/pkg/include		\
	    /usr/local/include/iconv	\
	    /usr/apps/include		\
	    ../iconv
	do
	if  test -r "$ac_dir/iconv.h"
	    then
		ac_iconv_includes=$ac_dir
		break
	    fi
	done
    fi

    if  test $ac_iconv_libraries = "NO"
    then
	# Libraries
	for ac_dir in			\
	    /usr/lib			\
	    /usr/local/lib		\
	    /usr/pkg/lib		\
	    /usr/local/lib/iconv	\
	    /usr/apps/lib		\
	    ../iconv
	do
	found=no

	if  test -r "$ac_dir/iconv.a"
	    then
		ac_iconv_libraries=$ac_dir
		ac_iconv_static_lib=$ac_dir/iconv.a
		found=yes
		break
	    fi

	if  test -r "$ac_dir/iconv.so"
	    then
		ac_iconv_libraries=$ac_dir
		ac_iconv_shared_lib=$ac_dir/iconv.so
		found=yes
		break
	    fi

	if  test -r "$ac_dir/iconv.dylib"
	    then
		ac_iconv_libraries=$ac_dir
		ac_iconv_shared_lib=$ac_dir/iconv.dylib
		found=yes
		break
	    fi

	if  test $found = yes
	    then
		break
	    fi

	done
    fi

    #echo Includes : $ac_iconv_includes
    #echo Libraries: $ac_iconv_libraries

    if  test $ac_iconv_includes = NO
    then
	ICONV_FOUND=0
	AC_DEFINE(HAVE_ICONV,0)
    else
	ICONV_FOUND=1
	AC_DEFINE(HAVE_ICONV,1)
	ICONV_CFLAGS=-I$ac_iconv_includes

	if  test "$ICONV_CFLAGS" = "-I/usr/include"
	then
	    ICONV_CFLAGS=
	fi
    fi

    if  test $ac_iconv_libraries != NO
    then
	ICONV_LIBS="-L$ac_iconv_libraries"

	if  test $ac_iconv_static_lib != NO
	then
	    ICONV_STATIC_REF="$ac_iconv_static_lib"
	else
	    ICONV_STATIC_REF="$ICONV_LIBS -liconv"
	fi

    ICONV_SHARED_REF="$ICONV_LIBS -liconv"

    fi

    AC_SUBST(ICONV_CFLAGS)dnl
    AC_SUBST(ICONV_LIBS)dnl
    AC_SUBST(ICONV_STATIC_REF)dnl
    AC_SUBST(ICONV_SHARED_REF)dnl
    AC_SUBST(ICONV_FOUND)dnl
])
#####################################################################
##
##   Look for pcre
##
#####################################################################

AC_DEFUN(AC_PATH_PCRE,
[
    echo Checking for pcre...

    PCRE_CFLAGS=
    PCRE_LIBS=
    PCRE_STATIC_REF=
    PCRE_SHARED_REF=

    PCRE_FOUND=0

    ac_pcre_includes=${ac_pcre_includes:-NO}
    ac_pcre_libraries=${ac_pcre_libraries:-NO}
    ac_pcre_static_lib=NO
    ac_pcre_shared_lib=NO

    if  test $ac_pcre_includes = "NO"
    then
	# Includes
	for ac_dir in			\
	    /usr/include		\
	    /usr/local/include		\
	    /usr/pkg/include		\
	    /usr/include/pcre		\
	    /usr/local/include/pcre	\
	    /usr/apps/include		\
	    ../pcre
	do
	if  test -r "$ac_dir/pcre.h"
	    then
		ac_pcre_includes=$ac_dir
		break
	    fi
	done
    fi

    if  test $ac_pcre_libraries = "NO"
    then
	# Libraries
	for ac_dir in			\
	    /usr/lib			\
	    /usr/local/lib		\
	    /usr/pkg/lib		\
	    /usr/lib/pcre		\
	    /usr/local/lib/pcre		\
	    /usr/apps/lib		\
	    ../pcre
	do
	found=no

	if  test -r "$ac_dir/pcre.a"
	    then
		ac_pcre_libraries=$ac_dir
		ac_pcre_static_lib=$ac_dir/pcre.a
		found=yes
		break
	    fi

	if  test -r "$ac_dir/pcre.so"
	    then
		ac_pcre_libraries=$ac_dir
		ac_pcre_shared_lib=$ac_dir/pcre.so
		found=yes
		break
	    fi

	if  test -r "$ac_dir/pcre.dylib"
	    then
		ac_pcre_libraries=$ac_dir
		ac_pcre_shared_lib=$ac_dir/pcre.dylib
		found=yes
		break
	    fi

	if  test $found = yes
	    then
		break
	    fi

	done
    fi

    #echo Includes : $ac_pcre_includes
    #echo Libraries: $ac_pcre_libraries

    if  test $ac_pcre_includes = NO
    then
	PCRE_FOUND=0
	AC_DEFINE(HAVE_PCRE,0)
    else
	PCRE_FOUND=1
	AC_DEFINE(HAVE_PCRE,1)
	PCRE_CFLAGS=-I$ac_pcre_includes

	if  test "$PCRE_CFLAGS" = "-I/usr/include"
	then
	    PCRE_CFLAGS=
	fi
    fi

    if  test $ac_pcre_libraries != NO
    then
	PCRE_LIBS="-L$ac_pcre_libraries"
    fi

    if  test $ac_pcre_static_lib != NO
    then
	PCRE_STATIC_REF="$ac_pcre_static_lib"
    else
	PCRE_STATIC_REF="$PCRE_LIBS -lpcre"
    fi

    PCRE_SHARED_REF="$PCRE_LIBS -lpcre"

    AC_SUBST(PCRE_CFLAGS)dnl
    AC_SUBST(PCRE_LIBS)dnl
    AC_SUBST(PCRE_STATIC_REF)dnl
    AC_SUBST(PCRE_SHARED_REF)dnl
    AC_SUBST(PCRE_FOUND)dnl
])
#####################################################################
##
##   Find out whether there is a domain name in the struct utsname.
##   An what is is called
##
#####################################################################

AC_DEFUN(AC_STRUCT_UTSNAME_DOMAINNAME,
[
    dnl Is the domain in the utsname struct? What is it same..

    AC_TRY_LINK(
	[#include <sys/utsname.h>],
	[struct utsname u; return u.domainname;],
	AC_DEFINE(UTSNAME_DOMAIN,domainname),)
    AC_TRY_LINK(
	[#include <sys/utsname.h>],
	[struct utsname u; return u.__domainname;],
	AC_DEFINE(UTSNAME_DOMAIN,__domainname),)
])
