/************************************************************************/
/*									*/
/*  A widget in the screen GUI. (Motif Implementation)			*/
/*									*/
/************************************************************************/

#   include <appFrameConfig.h>

#   include <math.h>

#   include <guiWidgetScreen.h>
#   include <guiWidgetImpl.h>
#   include <appDraw.h>
#   include <appDebugon.h>

#   ifdef 		USE_GTK

ScreenWidget guiScreenWidgetForNativeWidget(	APP_WIDGET	widget,
						AppColors *	ac )
    {
    ScreenWidget	sw= malloc(sizeof(struct ScreenWidget));

    if  ( ! sw )
	{ PDEB(sw); return sw;	}

    sw->swNativeWidget= widget;
    sw->swColors= ac;

    return sw;
    }

void guiFreeScreenWidget(			ScreenWidget	sw )
    {
    /* swNativeWidget is owned by the native GUI */
    /* swColors is owned by the legacy implementation */
    free( sw );
    }

int guiScreenWidgetPixelsPerMeter(		ScreenWidget	sw )
    {
    double	horPixPerM;
    double	verPixPerM;

    horPixPerM= ( 1000* gdk_screen_width() )/ (double)gdk_screen_width_mm();
    verPixPerM= ( 1000* gdk_screen_height() )/ (double)gdk_screen_height_mm();

    return sqrt( horPixPerM* verPixPerM )+ 0.4999;
    }

#   endif	/*	USE_GTK	*/
