/************************************************************************/
/*									*/
/*  A pixmap in the screen GUI. (Implementation)			*/
/*									*/
/************************************************************************/

#   include <drawDrawingSurface.h>
#   include <appDraw.h>

struct DrawingSurface
    {
    AppColors *			dsColors;
    AffineTransform2D		dsTransform;
    AffineTransform2D		dsReverseTransform;

#   ifdef USE_MOTIF
    GC				dsGc;
    Drawable			dsDrawable;
    Display *			dsDisplay;
    int				dsScreen;
    Atom			dsCurrentFID;
#   endif

#   ifdef USE_GTK
    GdkGC *			dsGc;
    GdkWindow *			dsDrawable;
#   endif

#   ifdef USE_XFT
    XftDraw *			dsXftDrawable;
    /*
    AppXftColorList		dsXftColorList;
    */
    AppXftColor			dsXftCurrentColor;
				/****************************************/
				/*  Is either null, or a copy of a	*/
				/*  color in the list. never allocate	*/
				/*  or free!				*/
				/****************************************/
#   endif
    };

/************************************************************************/
/*									*/
/*  Utility functions.							*/
/*									*/
/************************************************************************/

void drawSetRectanglePoints(	APP_POINT			points[5],
				DrawingSurface			ds,
				const DocumentRectangle *	drLogical );
