/************************************************************************/
/*									*/
/*  Drawing surface implementation implementation.			*/
/*									*/
/************************************************************************/

#   include <appFrameConfig.h>

#   include <guiWidgetDrawingSurface.h>
#   include <drawDrawingSurfaceImpl.h>
#   include <guiWidgetImpl.h>
#   include <appDraw.h>
#   include <appDebugon.h>

#   ifdef USE_GTK

/************************************************************************/
/*									*/
/*  Make a drawing surface for a screen widget.				*/
/*									*/
/************************************************************************/

DrawingSurface guiMakeDrawingSurfaceForWidget(
					ScreenWidget		sw )
    {
    DrawingSurface	ds= malloc(sizeof(struct DrawingSurface));

    if  ( ! ds )
	{ PDEB(ds); return ds;	}

    ds->dsColors= sw->swColors;
    ds->dsDrawable= sw->swNativeWidget->window;

    geoIdentityAffineTransform2D( &(ds->dsTransform) );
    geoIdentityAffineTransform2D( &(ds->dsReverseTransform) );

    appInitAppXftColor( &(ds->dsXftCurrentColor) );

    ds->dsGc= gdk_gc_new( ds->dsDrawable );

    return ds;
    }

/************************************************************************/
/*									*/
/*  Cause subsequent drawing to be done in a certain color.		*/
/*									*/
/************************************************************************/

int drawSetForegroundColor(	DrawingSurface		ds,
				const RGB8Color *	rgb8 )
    {
    APP_COLOR_RGB		xc;

    if  ( appColorRgb( &xc, ds->dsColors,
				    rgb8->rgb8Red,
				    rgb8->rgb8Green,
				    rgb8->rgb8Blue ) )
	{ LDEB(1); return -1;	}

    gdk_gc_set_foreground( ds->dsGc, &xc );

#   ifdef USE_XFT
    appSolidXftColor( &(ds->dsXftCurrentColor), &xc );
#   endif

    return 0;
    }

/************************************************************************/
/*									*/
/*  Destroy a drawing surface. Only free resources allocated by the	*/
/*  DrawingSurface itself.						*/
/*									*/
/************************************************************************/

void drawFreeDrawingSurface(	DrawingSurface		ds )
    {
    if  ( ds->dsGc )
	{ gdk_gc_unref( ds->dsGc );	}

    free( ds );
    }

/************************************************************************/
/*									*/
/*  Fill a rectangle.							*/
/*  Realize that the result of the transform might NOT be rectangular.	*/
/*									*/
/************************************************************************/

void drawFillRectangle(	DrawingSurface			ds,
			const DocumentRectangle *	drLogical )
    {
    APP_POINT	points[5];

    drawSetRectanglePoints( points, ds, drLogical );

    gdk_draw_polygon( ds->dsDrawable, ds->dsGc, TRUE, points, 4 );
    }

#   endif
