#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>

#   include	<appWinMetaImpl.h>
#   include	<bmEmfIo.h>
#   include	<sioEndian.h>
#   include	<uniUtf8.h>

#   include	<appDebugon.h>

# if 0
#    define	WMFDEB(x)	(x)
# else
#    define	WMFDEB(x)	/*nothing*/
# endif

int appWinMetaReadUtf16Text(	DeviceContext *		dc,
				int			expectChars,
				SimpleInputStream *	sis )
    {
    int		nchars;
    int		nbytes;
    int		done= 0;

    utilEmptyMemoryBuffer( &(dc->dcCollectedText) );

    nbytes= 0;
    for ( nchars= 0; nchars < expectChars; nchars++ )
	{
	int		step;
	unsigned char	scratch[6+1];
	int		c= sioEndianGetLeUint16( sis ); done += 2;

	if  ( c == 0 )
	    { nchars++; break;	}

	step= uniPutUtf8( scratch, c );
	if  ( step < 1 || step > 3 )
	    { XLDEB(c,step); break;	}

	if  ( utilAddToMemoryBuffer( &(dc->dcCollectedText), scratch, step ) )
	    { LDEB(step); return -1;	}

	nbytes += step;
	}

    while( nchars < expectChars )
	{ sioEndianGetLeInt16( sis ); done += 2; nchars++;	}

    return done;
    }

static int appWinMetaProduceUtf8(	void *		voiddc,
					int		produced,
					const char *	bytes,
					int		count )
    {
    DeviceContext *	dc= (DeviceContext *)voiddc;

    if  ( utilAddToMemoryBuffer( &(dc->dcCollectedText), (unsigned char *)bytes, count ) )
	{ LDEB(count); return -1;	}

    return count;
    }

int appWinMetaReadLegacyText(	DeviceContext *		dc,
				int			count,
				int			expectBytes,
				SimpleInputStream *	sis )
    {
    int				rval= 0;
    int				nbytes;
    int				done= 0;
    const OfficeCharset *	oc;
    char *			buf= (char *)0;
    int				idx;

    utilEmptyMemoryBuffer( &(dc->dcCollectedText) );

    oc= utilGetOfficeCharsetByCharset( &idx, dc->dcFont.lfCharSet );

    if  ( ! oc || ! oc->ocEncodingName )
	{
	if  ( dc->dcFont.lfCharSet != FONTcharsetDEFAULT )
	    { LPDEB(dc->dcFont.lfCharSet,oc);	}

	for ( nbytes= 0; nbytes < count; nbytes++ )
	    {
	    int			step;
	    unsigned char	scratch[6+1];
	    int			c= sioInGetByte( sis ); done += 1;

	    if  ( c == 0 )
		{ nbytes++; break;	}

	    step= uniPutUtf8( scratch, c );
	    if  ( step < 1 || step > 3 )
		{ XLDEB(c,step); break;	}

	    if  ( utilAddToMemoryBuffer( &(dc->dcCollectedText),
							scratch, step ) )
		{ LDEB(step); rval= -1; goto ready;	}
	    }
	}
    else{
	int	consumed= 0;
	int	produced= 0;

	utilTextConverterSetNativeEncodingName( &(dc->dcTextConverter),
							oc->ocEncodingName );
	buf= malloc( count+ 1 );
	if  ( ! buf )
	    { LPDEB(count,buf); rval= -1; goto ready;	}

	if  ( sioInReadBytes( sis, (unsigned char *)buf, count ) != count )
	    { LDEB(count); rval= -1; goto ready;	}
	nbytes= count; done += count;
	buf[count]= '\0';

	utilTextConverterConvertToUtf8( &(dc->dcTextConverter), (void *)dc,
					appWinMetaProduceUtf8,
					&consumed, produced, buf, count );
	}

    while( nbytes < expectBytes )
	{ sioInGetByte( sis ); done += 1; nbytes++;	}

    rval= done;

  ready:

    if  ( buf )
	{ free( buf );	}

    return rval;
    }

