/************************************************************************/
/*									*/
/*  Document window application independent scrolling functionality.	*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<string.h>

#   include	<appSystem.h>
#   include	"appFrame.h"
#   include	"appGuiKeys.h"

#   include	<appDebugon.h>

#   define	WHEEL_STEP	10
#   define	BAR_STEP	20

/************************************************************************/
/*									*/
/*  Callbacks for the scrollbars, and the size admin  of a document.	*/
/*									*/
/************************************************************************/

static void appDocScrollVertically(	EditDocument *		ed,
					int			scrolledY )
    {
    EditApplication *		ea= ed->edApplication;
    AppDrawingData *		add= &(ed->edDocumentWidget.dwDrawingData);

    int				ox;
    int				oy;
    int				high;
    int				wide;

    DocumentRectangle		drClip;
    DocumentRectangle		drScreen;

    appDrawNoClipping( add );

    drClip= add->addBackRect;

    high= ed->edVisibleRect.drY1- ed->edVisibleRect.drY0+ 1;
    wide= ed->edVisibleRect.drX1- ed->edVisibleRect.drX0+ 1;

    if  ( scrolledY > 0 )
	{
	if  ( high > scrolledY )
	    {
	    appDrawMoveArea( add, 0, scrolledY, wide, high- scrolledY, 0, 0 );

	    drClip.drY0= ed->edVisibleRect.drY1- scrolledY;
	    drClip.drY1= ed->edVisibleRect.drY1;
	    }
	else{
	    drClip.drY0= ed->edVisibleRect.drY0;
	    drClip.drY1= ed->edVisibleRect.drY1;
	    }
	}
    else{
	if  ( high+ scrolledY > 0 )
	    {
	    appDrawMoveArea( add, 0, 0, wide, high+ scrolledY, 0, -scrolledY );

	    drClip.drY0= ed->edVisibleRect.drY0;
	    drClip.drY1= ed->edVisibleRect.drY0- scrolledY;
	    }
	else{
	    drClip.drY0= ed->edVisibleRect.drY0;
	    drClip.drY1= ed->edVisibleRect.drY1;
	    }
	}

    ox= ed->edVisibleRect.drX0;
    oy= ed->edVisibleRect.drY0;

    drScreen.drX0= drClip.drX0- ox;
    drScreen.drY0= drClip.drY0- oy;
    drScreen.drX1= drClip.drX1- ox;
    drScreen.drY1= drClip.drY1- oy;

#   if 1
    appDrawSetClipRect( add, &drScreen );
    (*ea->eaDrawRectangle)( ed, &drClip, ox, oy );
#   else
    appExposeRectangle( add, &drScreen );
#   endif

    if  ( ed->edLeftRuler && ea->eaScrollLeftRuler )
	{
	(*ea->eaScrollLeftRuler)
			( ed->edLeftRuler, ed->edLeftRulerWidget, scrolledY );
	}

    if  ( ed->edRightRuler && ea->eaScrollRightRuler )
	{
	(*ea->eaScrollRightRuler)
			( ed->edRightRuler, ed->edRightRulerWidget, scrolledY );
	}

    return;
    }

static void appDocScrollHorizontally(	EditDocument *		ed,
					int			scrolledX )
    {
    EditApplication *		ea= ed->edApplication;
    AppDrawingData *		add= &(ed->edDocumentWidget.dwDrawingData);

    int				ox;
    int				oy;
    int				high;
    int				wide;

    DocumentRectangle		drClip;
    DocumentRectangle		drScreen;

    appDrawNoClipping( add );

    drClip= add->addBackRect;

    high= ed->edVisibleRect.drY1- ed->edVisibleRect.drY0+ 1;
    wide= ed->edVisibleRect.drX1- ed->edVisibleRect.drX0+ 1;

    if  ( scrolledX > 0 )
	{
	if  ( wide > scrolledX )
	    {
	    appDrawMoveArea( add, scrolledX, 0, wide- scrolledX, high, 0, 0 );

	    drClip.drX0= ed->edVisibleRect.drX1- scrolledX;
	    drClip.drX1= ed->edVisibleRect.drX1;
	    }
	else{
	    drClip.drX0= ed->edVisibleRect.drX0;
	    drClip.drX1= ed->edVisibleRect.drX1;
	    }
	}
    else{
	if  ( wide+ scrolledX > 0 )
	    {
	    appDrawMoveArea( add, 0, 0, wide+ scrolledX, high, -scrolledX, 0 );

	    drClip.drX0= ed->edVisibleRect.drX0;
	    drClip.drX1= ed->edVisibleRect.drX0- scrolledX;
	    }
	else{
	    drClip.drX0= ed->edVisibleRect.drX0;
	    drClip.drX1= ed->edVisibleRect.drX1;
	    }
	}

    ox= ed->edVisibleRect.drX0;
    oy= ed->edVisibleRect.drY0;

    drScreen.drX0= drClip.drX0- ox;
    drScreen.drY0= drClip.drY0- oy;
    drScreen.drX1= drClip.drX1- ox;
    drScreen.drY1= drClip.drY1- oy;

#   if 1
    appDrawSetClipRect( add, &drScreen );
    (*ea->eaDrawRectangle)( ed, &drClip, ox, oy );
#   else
    appExposeRectangle( add, &drScreen );
#   endif

    if  ( ed->edTopRuler && ea->eaScrollTopRuler )
	{
	(*ea->eaScrollTopRuler)
			( ed->edTopRuler, ed->edTopRulerWidget, scrolledX );
	}

    if  ( ed->edBottomRuler && ea->eaScrollBottomRuler )
	{
	(*ea->eaScrollBottomRuler)
		    ( ed->edBottomRuler, ed->edBottomRulerWidget, scrolledX );
	}

    return;
    }

void appDocScrollToY(	EditDocument *		ed,
			int			y )
    {
    int		scrolledY= y- ed->edVisibleRect.drY0;

    if  ( scrolledY == 0 )
	{ return;	}

    ed->edVisibleRect.drY0 += scrolledY;
    ed->edVisibleRect.drY1 += scrolledY;

    appDocScrollVertically( ed, scrolledY );

    return;
    }

void appDocScrollToX(	EditDocument *		ed,
			int			x )
    {
    int		scrolledX= x- ed->edVisibleRect.drX0;

    if  ( scrolledX == 0 )
	{ return;	}

    ed->edVisibleRect.drX0 += scrolledX;
    ed->edVisibleRect.drX1 += scrolledX;

    appDocScrollHorizontally( ed, scrolledX );

    return;
    }

APP_SCROLLBAR_CALLBACK_H( appDocVerticalScrollbarCallback, w, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;
    int			y= appGuiGetScrollbarValueFromCallback( w, e );

    appDocScrollToY( ed, y );
    }

APP_SCROLLBAR_CALLBACK_H( appDocHorizontalScrollbarCallback, w, voided, e )
    {
    EditDocument *	ed= (EditDocument *)voided;
    int			x= appGuiGetScrollbarValueFromCallback( w, e );

    appDocScrollToX( ed, x );
    }

/************************************************************************/
/*									*/
/*  Scroll the selection into view.					*/
/*									*/
/*  NOTE: sliderSize is passed to XmScrollBarSetValues() because of a	*/
/*	bug in lesstif Release 0.87.0. (Jan 1999).			*/
/*									*/
/************************************************************************/

void appScrollToRectangle(	EditDocument *		ed,
				int			x0,
				int			y0,
				int			x1,
				int			y1,
				int *			pScrolledX,
				int *			pScrolledY )
    {
    const AppDrawingData *	add= &(ed->edDocumentWidget.dwDrawingData);

    int				sliderSize;
	
    int				oox= ed->edVisibleRect.drX0;
    int				ooy= ed->edVisibleRect.drY0;
    int				nox;
    int				noy;

    int				set;
    int				changed= 0;

    nox= oox;
    noy= ooy;

    appGuiGetScrollbarValues( &noy, &sliderSize, ed->edVerticalScrollbar );

    if  ( y1 > noy+ sliderSize )
	{
	set= y1- sliderSize;

	if  ( noy != set )
	    {
	    appGuiSetScrollbarValues( ed->edVerticalScrollbar,
							set, sliderSize );
	    noy= set; changed= 1;
	    }
	}

    if  ( y0 < noy )
	{
	set= y0;

	if  ( noy != set )
	    {
	    appGuiSetScrollbarValues( ed->edVerticalScrollbar,
							set, sliderSize );
	    noy= set; changed= 1;
	    }
	}

    if  ( noy+ sliderSize > add->addBackRect.drY1 )
	{
	set= add->addBackRect.drY1- sliderSize+ 1;
	if  ( set < 0 )
	    { set= 0;	}

	if  ( noy != set )
	    {
	    appGuiSetScrollbarValues( ed->edVerticalScrollbar,
							set, sliderSize );
	    noy= set; changed= 1;
	    }
	}

    appGuiGetScrollbarValues( &nox, &sliderSize, ed->edHorizontalScrollbar );

    if  ( x1 > nox+ sliderSize )
	{
	set= x1- sliderSize;
	if  ( nox != set )
	    {
	    appGuiSetScrollbarValues( ed->edHorizontalScrollbar,
							set, sliderSize );
	    nox= set; changed= 1;
	    }
	}

    if  ( x0 < nox )
	{
	set= x0;
	if  ( nox != set )
	    {
	    appGuiSetScrollbarValues( ed->edHorizontalScrollbar,
							set, sliderSize );
	    nox= set; changed= 1;
	    }
	}

    if  ( nox+ sliderSize > add->addBackRect.drX1 )
	{
	set= add->addBackRect.drX1- sliderSize+ 1;
	if  ( set < 0 )
	    { set= 0;	}

	if  ( nox != set )
	    {
	    appGuiSetScrollbarValues( ed->edHorizontalScrollbar,
							set, sliderSize );
	    nox= set; changed= 1;
	    }
	}

    *pScrolledX= nox- oox;
    *pScrolledY= noy- ooy;

    ed->edVisibleRect.drX0 += *pScrolledX;
    ed->edVisibleRect.drY0 += *pScrolledY;
    ed->edVisibleRect.drX1 += *pScrolledX;
    ed->edVisibleRect.drY1 += *pScrolledY;

    if  ( *pScrolledX != 0 )
	{ appDocScrollHorizontally( ed, *pScrolledX );	}
    if  ( *pScrolledY != 0 )
	{ appDocScrollVertically( ed, *pScrolledY );	}

#   ifdef USE_GTK
    if  ( changed )
	{ appExposeDrawingData( add );	}
#   endif

    return;
    }

/************************************************************************/
/*									*/
/*  Prevent the Shell that contains a document from being resized	*/
/*  beyond normal limits.						*/
/*									*/
/************************************************************************/

static void appFileAdaptHorizontalRulerRange(	EditDocument *	ed,
						int		width )
    {
    EditApplication *		ea= ed->edApplication;

    int				leftRulerWide= 0;
    int				leftRulerHigh= 0;

    if  ( ed->edLeftRulerWidget )
	{
	appDrawGetSizeOfWidget( &leftRulerWide, &leftRulerHigh,
						    ed->edLeftRulerWidget );
	}


    if  ( ed->edTopRuler && ea->eaSetTopRulerRange )
	{
	(*ea->eaSetTopRulerRange)( ed->edTopRuler,
					ed->edTopRulerWidget,
					ed->edVisibleRect.drX0,
					ed->edVisibleRect.drX1,
					width+ leftRulerWide );
	}

    if  ( ed->edBottomRuler && ea->eaSetBottomRulerRange )
	{
	(*ea->eaSetBottomRulerRange)( ed->edBottomRuler,
					ed->edBottomRulerWidget,
					ed->edVisibleRect.drX0,
					ed->edVisibleRect.drX1,
					width+ leftRulerWide );
	}

    return;
    }

static void appFileAdaptVerticalRulerRange(	EditDocument *	ed,
						int		height )
    {
    EditApplication *		ea= ed->edApplication;

    if  ( ed->edLeftRuler && ea->eaSetLeftRulerRange )
	{
	(*ea->eaSetLeftRulerRange)( ed->edLeftRuler,
					ed->edLeftRulerWidget,
					ed->edVisibleRect.drY0,
					ed->edVisibleRect.drY1,
					height );
	}

    if  ( ed->edRightRuler && ea->eaSetRightRulerRange )
	{
	(*ea->eaSetRightRulerRange)( ed->edRightRuler,
					ed->edRightRulerWidget,
					ed->edVisibleRect.drY0,
					ed->edVisibleRect.drY1,
					height );
	}

    return;
    }

void appAdaptToDocumentSize(	EditDocument *	ed,
				int		width,
				int		height )
    {
    AppDrawingData *	add= &(ed->edDocumentWidget.dwDrawingData);
    int			changed= 0;
    int			d;

    if  ( ed->edVisibleRect.drY1 != ed->edVisibleRect.drY0+ height- 1 )
	{
	ed->edVisibleRect.drY1= ed->edVisibleRect.drY0+ height- 1;
	changed= 1;

	if  ( ed->edVisibleRect.drY1 > add->addBackRect.drY1 )
	    {
	    d= ed->edVisibleRect.drY1- add->addBackRect.drY1;

	    if  ( d > ed->edVisibleRect.drY0 )
		{ d= ed->edVisibleRect.drY0;	}

	    ed->edVisibleRect.drY0 -= d;
	    ed->edVisibleRect.drY1 -= d;
	    }

	appFileAdaptVerticalRulerRange( ed, height );

	appExposeDrawingData( add );
	}

    if  ( ed->edVisibleRect.drX1 != ed->edVisibleRect.drX0+ width+ 1 )
	{
	ed->edVisibleRect.drX1= ed->edVisibleRect.drX0+ width+ 1;
	changed= 1;

	if  ( ed->edVisibleRect.drX1 > add->addBackRect.drX1 )
	    {
	    d= ed->edVisibleRect.drX1- add->addBackRect.drX1;

	    if  ( d > ed->edVisibleRect.drX0 )
		{ d= ed->edVisibleRect.drX0;	}

	    ed->edVisibleRect.drX0 -= d;
	    ed->edVisibleRect.drX1 -= d;
	    }

	appFileAdaptHorizontalRulerRange( ed, width );

	appExposeDrawingData( add );
	}

    if  ( changed )
	{ appDocSetScrollbarValues( ed );	}

    return;
    }

void appDocumentRulerWidth(	EditApplication *	ea,
				EditDocument *		ed )
    {
    int			mult;

    double		horPixPerMM;
    double		verPixPerMM;
    double		xfac;
    double		yfac;

    appGetFactors( ea, &horPixPerMM, &verPixPerMM, &xfac, &yfac );

    /*  1  */
    ed->edLeftRulerWidePixels=
			(int)( ea->eaLeftRulerWidthMM* horPixPerMM );
    ed->edTopRulerHighPixels=
			(int)( ea->eaTopRulerHeightMM* verPixPerMM );
    ed->edRightRulerWidePixels=
			(int)( ea->eaRightRulerWidthMM * horPixPerMM );
    ed->edBottomRulerHighPixels=
			(int)( ea->eaBottomRulerHeightMM* verPixPerMM );

    mult= ea->eaLeftRulerWidthMultiple;
    if  ( mult )
	{
	ed->edLeftRulerWidePixels=
		    mult* ( ( ed->edLeftRulerWidePixels+ mult- 1 )/ mult );
	}

    mult= ea->eaTopRulerHeightMultiple;
    if  ( mult )
	{
	ed->edTopRulerHighPixels=
		    mult* ( ( ed->edTopRulerHighPixels+ mult- 1 )/ mult );
	}

    mult= ea->eaRightRulerWidthMultiple;
    if  ( mult )
	{
	ed->edRightRulerWidePixels=
		    mult* ( ( ed->edRightRulerWidePixels+ mult- 1 )/ mult );
	}

    mult= ea->eaBottomRulerHeightMultiple;
    if  ( mult )
	{
	ed->edBottomRulerHighPixels=
		    mult* ( ( ed->edBottomRulerHighPixels+ mult- 1 )/ mult );
	}

    return;
    }

void appDocumentCalculateExtraSize(	EditDocument *	ed )
    {
    int	shellWide;
    int	shellHigh;

    int	docWide;
    int	docHigh;

    appDrawGetSizeOfWidget( &shellWide, &shellHigh,
					    ed->edToplevel.atTopWidget );

    appDrawGetSizeOfWidget( &docWide, &docHigh,
					    ed->edDocumentWidget.dwWidget );

    ed->edShellExtraWidth= shellWide- docWide;
    ed->edShellExtraHeight= shellHigh- docHigh;

    appSetShellConstraints( ed );

    appAdaptToDocumentSize( ed, docWide, docHigh );
    }

APP_EVENT_HANDLER_H( appDocConfigure, w, voided, event )
    {
    EditDocument *	ed= (EditDocument *)voided;

    int			wide;
    int			high;

    if  ( appDrawGetSizeFromConfigureEvent( &wide, &high, w, event ) )
	{ return;	}

    appAdaptToDocumentSize( ed, wide, high );

    return;
    }

void appMouseWheelDown(		EditDocument *	ed )
    {
    AppDrawingData *	add= &(ed->edDocumentWidget.dwDrawingData);

    int			ooy= ed->edVisibleRect.drY0;
    int			noy= ed->edVisibleRect.drY0;
    int			scrolledY;

    int			sliderSize;

    sliderSize= ed->edVisibleRect.drY1- ed->edVisibleRect.drY0+ 1;
    noy += ( sliderSize+ WHEEL_STEP- 1 )/ WHEEL_STEP;

    if  ( noy > add->addBackRect.drY1- sliderSize )
	{ noy=  add->addBackRect.drY1- sliderSize;	}

    scrolledY= noy- ooy;

    if  ( scrolledY == 0 )
	{ return;	}

    ed->edVisibleRect.drY0 += scrolledY;
    ed->edVisibleRect.drY1 += scrolledY;

    appDocScrollVertically( ed, scrolledY );

    appGuiSetScrollbarValues( ed->edVerticalScrollbar, noy, sliderSize );
    }

void appMouseWheelUp(		EditDocument *	ed )
    {
    int			ooy= ed->edVisibleRect.drY0;
    int			noy= ed->edVisibleRect.drY0;
    int			scrolledY;

    int			sliderSize;

    sliderSize= ed->edVisibleRect.drY1- ed->edVisibleRect.drY0+ 1;
    noy -= ( sliderSize+ WHEEL_STEP- 1 )/ WHEEL_STEP;

    if  ( noy < 0 )
	{ noy=  0;	}

    scrolledY= noy- ooy;

    if  ( scrolledY == 0 )
	{ return;	}

    ed->edVisibleRect.drY0 += scrolledY;
    ed->edVisibleRect.drY1 += scrolledY;

    appDocScrollVertically( ed, scrolledY );

    appGuiSetScrollbarValues( ed->edVerticalScrollbar, noy, sliderSize );
    }

APP_EVENT_HANDLER_H( appScrollEventHandler, w, voided, scrollEvent )
    {
    EditDocument *	ed= (EditDocument *)voided;
    int			direction= SCROLL_DIRECTION_FROM_EVENT( scrollEvent );

    switch( direction )
	{
#	ifdef USE_MOTIF
	case Button1:
	case Button2:
	case Button3:
	    break;
#	endif

	case SCROLL_UP:
	    appMouseWheelUp( ed );
	    break;

	case SCROLL_DOWN:
	    appMouseWheelDown( ed );
	    break;

	default:
	    LDEB(direction);
	    break;
	}

    return;
    }


void appDocSetScrollbarValues(	EditDocument *	ed )
    {
    AppDrawingData *	add= &(ed->edDocumentWidget.dwDrawingData);

    int			sliderSize;
    int			maximum;
    int			minimum;
    int			value;

    sliderSize= ed->edVisibleRect.drY1- ed->edVisibleRect.drY0+ 1;
    minimum= add->addBackRect.drY0;
    value= ed->edVisibleRect.drY0;

    if  ( sliderSize >= add->addBackRect.drY1+ 1 )
	{ maximum= ed->edVisibleRect.drY1+ 1;	}
    else{ maximum= add->addBackRect.drY1+ 1;	}

    if  ( value+ sliderSize > maximum )
	{ value= maximum- sliderSize; }

#   ifdef USE_MOTIF
    XtVaSetValues( ed->edVerticalScrollbar,
		XmNminimum,		minimum,
		XmNmaximum,		maximum,
		XmNvalue,		value,
		XmNsliderSize,		sliderSize,
		XmNpageIncrement,	( 9* sliderSize+ 9 )/10,
		XmNincrement,		( sliderSize+ BAR_STEP- 1 )/ BAR_STEP,
		NULL );
#   endif

#   ifdef USE_GTK
    ed->edVerticalAdjustment->lower= minimum;
    ed->edVerticalAdjustment->upper= maximum;
    ed->edVerticalAdjustment->value= value;
    ed->edVerticalAdjustment->page_size= sliderSize;
    ed->edVerticalAdjustment->page_increment= ( 9* sliderSize+ 9 )/10;
    ed->edVerticalAdjustment->step_increment=
				    ( sliderSize+ BAR_STEP- 1 )/ BAR_STEP;

    gtk_adjustment_changed( ed->edVerticalAdjustment );
#   endif

    sliderSize= ed->edVisibleRect.drX1- ed->edVisibleRect.drX0+ 1;
    minimum= add->addBackRect.drX0;
    value= ed->edVisibleRect.drX0;

    if  ( sliderSize >= add->addBackRect.drX1+ 1 )
	{ maximum= ed->edVisibleRect.drX1+ 1;	}
    else{ maximum= add->addBackRect.drX1+ 1;	}

#   ifdef USE_MOTIF
    XtVaSetValues( ed->edHorizontalScrollbar,
			XmNminimum,	minimum,
			XmNmaximum,	maximum,
			XmNvalue,	value,
			XmNsliderSize,	sliderSize,
			NULL );
#   endif

#   ifdef USE_GTK
    ed->edHorizontalAdjustment->lower= minimum;
    ed->edHorizontalAdjustment->upper= maximum;
    ed->edHorizontalAdjustment->value= value;
    ed->edHorizontalAdjustment->page_size= sliderSize;

    gtk_adjustment_changed( ed->edHorizontalAdjustment );
#   endif

    return;
    }

