/************************************************************************/
/*									*/
/*  Basic screen font management.					*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>

#   include	<geo2DInteger.h>
#   include	<psFontMetrics.h>
#   include	"appDraw.h"
#   include	"appScreenFont.h"
#   include	"drawScreenFontAdmin.h"
#   include	"appMatchFont.h"

#   include	<appDebugon.h>

void appDrawUnderlineGeometry(		int *			pThick,
					int *			pY,
					const AppDrawingData *	add,
					int			screenFont,
					int			baselinePixels )
    {
    const NumberedPropertiesList *	npl= &(add->addScreenFontAdmin);
    const DrawScreenFont *		dsf;

    dsf= drawGetScreenFontByNumber( npl, screenFont );
    if  ( ! dsf )
	{  LXDEB(screenFont,dsf); return;	}

    *pThick= dsf->apfUnderlineThicknessPixels;
    *pY= baselinePixels+ dsf->apfUnderlinePositionPixels;
    return;
    }

void appDrawStrikethroughGeometry(	int *			pThick,
					int *			pY,
					const AppDrawingData *	add,
					int			screenFont,
					int			baselinePixels )
    {
    const NumberedPropertiesList *	npl= &(add->addScreenFontAdmin);
    const DrawScreenFont *		dsf;

    dsf= drawGetScreenFontByNumber( npl, screenFont );
    if  ( ! dsf )
	{  LXDEB(screenFont,dsf); return;	}

    *pThick= dsf->apfStrikethroughThicknessPixels;
    *pY= baselinePixels+ dsf->apfStrikethroughPositionPixels;
    return;
    }

void appDrawGetSuperBaseline(	int *			pSuperBaseline,
				int			baselinePixels,
				const AppDrawingData *	add,
				int			screenFont )
    {
    const NumberedPropertiesList *	npl= &(add->addScreenFontAdmin);
    const DrawScreenFont *		dsf;

    dsf= drawGetScreenFontByNumber( npl, screenFont );
    if  ( ! dsf )
	{  LXDEB(screenFont,dsf); return;	}

    *pSuperBaseline= baselinePixels+ dsf->apfSuperBaseline;
    return;
    }

void appDrawGetSubBaseline(	int *			pSubBaseline,
				int			baselinePixels,
				const AppDrawingData *	add,
				int			screenFont )
    {
    const NumberedPropertiesList *	npl= &(add->addScreenFontAdmin);
    const DrawScreenFont *		dsf;

    dsf= drawGetScreenFontByNumber( npl, screenFont );
    if  ( ! dsf )
	{  LXDEB(screenFont,dsf); return;	}

    *pSubBaseline= baselinePixels+ dsf->apfSubBaseline;
    return;
    }

void appDrawCleanScreenFontList(	AppDrawingData *	add )
    {
    utilCleanNumberedPropertiesList( &(add->addScreenFontAdmin) );

    return;
    }

void appDrawStartScreenFontList(	AppDrawingData *	add )
    {
    drawStartScreenFontList( &(add->addScreenFontAdmin) );
    return;
    }

/************************************************************************/
/*									*/
/*  Find the slot for a particular font/attribute combination.		*/
/*									*/
/*  1)  Is it an open font? If so return its number.			*/
/*  2)  Claim memory.							*/
/*  3)  Obtain a list of the available fonts.				*/
/*									*/
/************************************************************************/

static int appGetScreenFont(	DrawScreenFont **		pApf,
				int *				pFresh,
				NumberedPropertiesList *	npl,
				const DocumentFont *		df,
				const AfmFontInfo *		afi,
				int				pixelSize )
    {
    int					screenFont;

    DrawScreenFont			dsfTemplate;
    DrawScreenFont *			dsfFound;

    drawInitScreenFont( &dsfTemplate );

    if  ( pixelSize < 2 )
	{
	/* LFLDEB(twipsSize,add->addMagnifiedPixelsPerTwip,sizePixels); */
	pixelSize= 2;
	}

    /*  1  */
    drawInitScreenFont( &dsfTemplate );
    dsfTemplate.apfPsFaceNumber= afi->afiFaceNumber;
    dsfTemplate.dsfSizePixels= pixelSize;

    screenFont= utilGetPropertyNumber( npl, 0, &dsfTemplate );
    if  ( screenFont >= 0 )
	{
	dsfFound= drawGetScreenFontByNumber( npl, screenFont );
	if  ( ! dsfFound )
	    { LXDEB(screenFont,dsfFound); return -1;	}

	*pApf= dsfFound; *pFresh= 0; return screenFont;
	}

    /*  KEY  */
    dsfTemplate.apfPsFaceNumber= afi->afiFaceNumber;
    dsfTemplate.dsfSizePixels= pixelSize;

    /*  DEP  */
    dsfTemplate.apfPsFontInfo= afi;
    dsfTemplate.dsfUnicodesUsed= &(df->dfUnicodesUsed);

    screenFont= utilGetPropertyNumber( npl, 1, &dsfTemplate );
    if  ( screenFont >= 0 )
	{
	dsfFound= drawGetScreenFontByNumber( npl, screenFont );
	if  ( ! dsfFound )
	    { LXDEB(screenFont,dsfFound); return -1;	}

	*pApf= dsfFound; *pFresh= 1; return screenFont;
	}

    LDEB(screenFont); return screenFont;
    }

static int appFontOpenScreenFont( AppDrawingData *		add,
				DrawScreenFont *		dsf )
    {
    int				openFullFont= 1;

    const int			baselinePixels= 0;

    if  ( dsf->apfPsFaceNumber < 0 || ! dsf->apfPsFontInfo )
	{ LXDEB(dsf->apfPsFaceNumber,dsf->apfPsFontInfo); return -1;	}

    /********************************************************************/
    /*  Calculate geometry shortcuts.					*/
    /********************************************************************/
    psStrikethroughGeometry( &(dsf->apfStrikethroughPositionPixels),
				&(dsf->apfStrikethroughThicknessPixels),
				baselinePixels, dsf->dsfSizePixels,
				dsf->apfPsFontInfo );

    psUnderlineGeometry( &(dsf->apfUnderlinePositionPixels),
				&(dsf->apfUnderlineThicknessPixels),
				baselinePixels, dsf->dsfSizePixels,
				dsf->apfPsFontInfo );

    psGetSuperBaseline( &(dsf->apfSuperBaseline),
				baselinePixels, dsf->dsfSizePixels,
				dsf->apfPsFontInfo );
    psGetSubBaseline( &(dsf->apfSubBaseline),
				baselinePixels, dsf->dsfSizePixels,
				dsf->apfPsFontInfo );

    /********************************************************************/
    /*  Open freetype fonts (if configured)				*/
    /********************************************************************/
#   ifdef USE_XFT
    if  ( ! add->addAvoidFontconfig )
	{
	if  ( openFullFont )
	    {
	    dsf->dsfXftFont= appFontOpenXftFont( dsf );
	    if  ( dsf->dsfXftFont )
		{ openFullFont= 0; }
	    }
	}
#   endif

#   ifdef USE_X11_FONTS
    /********************************************************************/
    /*  Open X11 fonts (if freetype is not configured, or it failed)	*/
    /********************************************************************/
    if  ( openFullFont )
	{
	if  ( ! appFontOpenX11Fonts( dsf ) )
	    { openFullFont= 0; }
	}
#   endif

    if  ( openFullFont )
	{
	SLDEB(dsf->apfPsFontInfo->afiFontName,openFullFont);
	return -1;
	}

    return 0;
    }

#   ifdef USE_GTK
#   include	<gdk/gdkx.h>
#   endif

int appGetPixelSize(		AppDrawingData *		add,
				const TextAttribute *		ta )
    {
    int			twipsSize= 10* ta->taFontSizeHalfPoints;

    if  ( ta->taSuperSub == DOCfontSUPERSCRIPT		||
	  ta->taSuperSub == DOCfontSUBSCRIPT		)
	{
	return COORDtoGRID( add->addMagnifiedPixelsPerTwip,
						SUPERSUB_SIZE( twipsSize ) );
	}
    else{
	return COORDtoGRID( add->addMagnifiedPixelsPerTwip, twipsSize );
	}

    }

int appOpenScreenFont(		AppDrawingData *		add,
				DocumentFontList *		dfl,
				const TextAttribute *		ta,
				int				pixelSize )
    {
    NumberedPropertiesList *	npl= &(add->addScreenFontAdmin);
    const PostScriptFontList *	psfl= add->addPostScriptFontList;

    const DocumentFont *	df;
    const AfmFontInfo *		afi;

    DrawScreenFont *		dsf;
    int				fresh;
    int				screenFont;

    df= docFontListGetFontByNumber( dfl, ta->taFontNumber );
    if  ( ! df )
	{ LXDEB(ta->taFontNumber,df); return -1;	}

    afi= appGetFontInfoForAttribute( ta, dfl, psfl );
    if  ( ! afi )
	{ SXDEB(df->dfName,afi); return -1;	}

    screenFont= appGetScreenFont( &dsf, &fresh, npl, df, afi, pixelSize );
    if  ( screenFont < 0 )
	{ LDEB(screenFont); return -1;	}

    if  ( fresh )
	{
#	ifdef USE_MOTIF
	if  ( ! dsf->dsfDisplay )
	    { dsf->dsfDisplay= add->addDisplay;	}
	if  ( ! dsf->dsfDrawable )
	    { dsf->dsfDrawable= add->addDrawable;	}
	if  ( ! dsf->dsfGc )
	    { dsf->dsfGc= add->addGc;	}
#	endif

#	ifdef USE_GTK
	if  ( ! dsf->dsfDisplay )
	    { dsf->dsfDisplay= GDK_DISPLAY();	}
	if  ( ! dsf->dsfDrawable )
	    { dsf->dsfDrawable= add->addDrawable;	}
	if  ( ! dsf->dsfGc )
	    { dsf->dsfGc= add->addGc;	}
#	endif

	if  ( add->addForScreenDrawing && appFontOpenScreenFont( add, dsf ) )
	    { LDEB(1); return -1;	}
	}

    return screenFont;
    }

int appDrawSystemFont(	AppDrawingData *	add,
			APP_FONT *		xfs,
			int			borrowed )
    {
    NumberedPropertiesList *	npl= &(add->addScreenFontAdmin);
    DrawScreenFont *		dsf= (DrawScreenFont *)0;
    int				screenFont;

    /* HACK */
    dsf= utilPagedListClaimItemAtEnd( &screenFont, &(npl->nplPagedList) );
    if  ( ! dsf )
	{ XDEB(dsf); return -1;	}

    dsf->dsfEncodedFonts.esfFonts= malloc( sizeof(EncodedScreenFont) );
    if  ( ! dsf->dsfEncodedFonts.esfFonts )
	{ XDEB(dsf->dsfEncodedFonts.esfFonts); return -1;	}
    drawInitEncodedScreenFont( dsf->dsfEncodedFonts.esfFonts );
    dsf->dsfEncodedFonts.esfFontCount= 1;

    dsf->dsfEncodedFonts.esfFonts[0].esfFontStruct= xfs;
    dsf->dsfEncodedFonts.esfFonts[0].esfFontBorrowed= borrowed;

#   ifdef USE_MOTIF
    dsf->dsfDisplay= add->addDisplay;
    dsf->dsfDrawable= add->addDrawable;
    dsf->dsfGc= add->addGc;
#   endif

#   ifdef USE_GTK
    dsf->dsfDrawable= add->addDrawable;
    dsf->dsfGc= add->addGc;
#   endif

#   ifdef USE_X11_FONTS
    addDrawX11GetFontProperties( dsf->dsfEncodedFonts.esfFonts, dsf );
    strcpy( dsf->apfFontName, dsf->dsfEncodedFonts.esfFonts->esfFontName );
#   endif

    return screenFont;
    }

int appFontImplementationName(	char *			target,
				int			maxlen,
				AppDrawingData *	add,
				int			screenFont )
    {
    const NumberedPropertiesList *	npl= &(add->addScreenFontAdmin);
    const AfmFontInfo *			afi;
    const DrawScreenFont *		dsf;

    dsf= drawGetScreenFontByNumber( npl, screenFont );
    if  ( ! dsf )
	{ LXDEB(screenFont,dsf); return -1;	}
    afi= dsf->apfPsFontInfo;

#   ifdef USE_XFT
    if  ( dsf->dsfXftFont )
	{
	if  ( ! afi->afiFontFileName 			||
	      strlen( afi->afiFontFileName ) >= maxlen	)
	    { return -1;	}

	strcpy( target, afi->afiFontFileName );
	return 0;
	}
#   endif

#   ifdef	USE_X11_FONTS
    if  ( dsf->dsfEncodedFonts.esfFontCount > 0 )
	{
	if  ( maxlen < sizeof(dsf->apfFontName) )
	    { return -1;	}

	strcpy( target, dsf->apfFontName );

	return 0;
	}
#   endif

    return -1;
    }

