/************************************************************************/
/*									*/
/*  Make XImages and/or Pixmaps from a bitmap.				*/
/*									*/
/*  MOTIF/X11 specific code.						*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	"appImage.h"
#   include	"drawUtilImpl.h"

#   include	<appDebugon.h>

#   ifdef USE_MOTIF

int appImgMakeImage(	AppDrawingData *		add,
			APP_IMAGE **			pPimage,
			int				toWide,
			int				toHigh,
			AppColors *			ac,
			const AppBitmapImage *		abi,
			const DocumentRectangle *	drSel )
    {
    return drawUtilMotifMakeImage( add->addDisplay, add->addScreen,
				    pPimage, toWide, toHigh, ac, abi, drSel );
    }

/************************************************************************/
/*									*/
/*  Convert a BitmapDescription to an APP_IMAGE.			*/
/*									*/
/************************************************************************/

int appImgMakePixmap(	AppDrawingData *		add,
			Pixmap *			pPixmap,
			int				toWide,
			int				toHigh,
			AppColors *			ac,
			const AppBitmapImage *		abi,
			const DocumentRectangle *	drSel )
    {
    APP_IMAGE *		xim= (APP_IMAGE *)0;

    Display *		display= add->addDisplay;
    Window		win= add->addDrawable;
    int			screen= DefaultScreen( display );
    int			depth= DefaultDepth( display, screen );

    if  ( appImgMakeImage( add, &xim, toWide, toHigh, ac, abi, drSel ) )
	{ LLDEB(toWide,toHigh); return -1;	}

#   if 0
    /*  Save result to file to be checked  */
    {
    AppBitmapImage	abiDump;

    bmInitBitmapImage( &abiDump );
    if  ( ! appGetImageMotif( &abiDump, xim, display ) )
	{
	const char *	name= "/tmp/xim.png";
	int		format;

	format= bmSuggestFormat( name,
				abiDump.abiFormat, &(abiDump.abiBitmap) );
	if  ( format < 0 )
	    { SLDEB(name,format);	}
	else{
	    if  ( bmWrite( name, abiDump.abiBuffer, &(abiDump.abiBitmap),
						format, abiDump.abiFactor ) )
		{ SDEB(name);	}
	    }
	}
    bmCleanBitmapImage( &abiDump );
    }
#   endif

    /*  5  */
    *pPixmap= XCreatePixmap( display, win, toWide, toHigh, depth );
    if  ( ! *pPixmap )
	{ XDEB(*pPixmap); return -1;	}

    XPutImage( display, *pPixmap, add->addGc, xim, 0, 0, 0, 0, toWide, toHigh );

    XDestroyImage( xim );

    return 0;
    }

#   endif /* USE_MOTIF */
