/************************************************************************/
/*									*/
/*  Make XImages and/or Pixmaps from a bitmap.				*/
/*									*/
/*  GTK specific code.							*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	"appImage.h"
#   include	"drawUtilImpl.h"

#   include	<appDebugon.h>

#   ifdef USE_GTK

/************************************************************************/
/*									*/
/*  Make a pixmap from a picture.					*/
/*									*/
/*  2)  Make sure that at least the 222 colors are available.		*/
/*  2a) Allocate an array of XColors and initialise it.			*/
/*  3)  Fill dither tables.						*/
/*  4)  Fill an XImage, the way depends on the bitmap.			*/
/*  5)  Store it in a Pixmap.						*/
/*									*/
/************************************************************************/

int appImgMakeImage(	AppDrawingData *		add,
			APP_IMAGE **			pPimage,
			int				toWide,
			int				toHigh,
			AppColors *			ac,
			const AppBitmapImage *		abi,
			const DocumentRectangle *	drSrc )
    {
    return drawUtilGtkMakeImage( pPimage, toWide, toHigh, ac, abi, drSrc );
    }

/************************************************************************/
/*									*/
/*  Convert a BitmapDescription to an APP_IMAGE.			*/
/*									*/
/************************************************************************/

int appImgMakePixmap(	AppDrawingData *		add,
			APP_BITMAP_IMAGE *		pPixmap,
			int				toWide,
			int				toHigh,
			AppColors *			ac,
			const AppBitmapImage *		abi,
			const DocumentRectangle *	drSrc )
    {
    APP_IMAGE *		xim;

    GdkWindow *		win= add->addDrawable;
    int			depth= ac->acAllocator.caDepth;

    if  ( appImgMakeImage( add, &xim, toWide, toHigh, ac, abi, drSrc ) )
	{ LLDEB(toWide,toHigh); return -1;	}

    /*  5  */
    *pPixmap= gdk_pixmap_new( win, toWide, toHigh, depth );

    if  ( ! *pPixmap )
	{ XDEB(*pPixmap); return -1;	}

    gdk_draw_image( *pPixmap, add->addGc, xim, 0, 0, 0, 0, toWide, toHigh );

    gdk_image_destroy( xim );

    return 0;
    }

#   endif /* USE_GTK */
