/************************************************************************/
/*									*/
/*  Basic structures for a Gui document manipulator application.	*/
/*									*/
/************************************************************************/

#   ifndef	APP_MATCH_FONT_H
#   define	APP_MATCH_FONT_H

#   include	<stdio.h>

#   include	<appGuiBase.h>
#   include	<appDraw.h>
#   include	<utilDocFontList.h>
#   include	<utilTextAttribute.h>

# ifdef __cplusplus
extern "C"
    {
# endif

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int appFcListFonts(	PostScriptFontList *		psfl );

AfmFontInfo * appFcGetFontInfoForAttribute(
				DocumentFont *			df,
				const TextAttribute *		ta,
				const PostScriptFontList *	psfl );

extern const AfmFontInfo * appGetFontInfoForAttribute(
				const TextAttribute *		ta,
				const DocumentFontList *	dfl,
				const PostScriptFontList *	psfl );

extern int appGetPixelSize(	AppDrawingData *		add,
				const TextAttribute *		ta );

extern int appOpenScreenFont(	AppDrawingData *		add,
				DocumentFontList *		dfl,
				const TextAttribute *		ta,
				int				pixelSize );

extern int appFcGetFontMetrics(	AfmFontInfo *			afi );

extern int appGetDeferredFontMetrics(	AfmFontInfo *		afi );
extern int appGetDeferredFontMetricsForList(
					PostScriptFontList *	psfl );

# ifdef __cplusplus
    }
# endif

#   endif
