/************************************************************************/
/*									*/
/*  Basic font matching.						*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>

#   include	"appDraw.h"
#   include	<appMatchFont.h>
#   include	<utilMatchFont.h>

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Find a PostScript font for a document font.				*/
/*									*/
/************************************************************************/

const AfmFontInfo * appGetFontInfoForAttribute(
				const TextAttribute *		ta,
				const DocumentFontList *	dfl,
				const PostScriptFontList *	psfl )
    {
    DocumentFont *		df;
    AfmFontInfo *		afi= (AfmFontInfo *)0;

    df= docFontListGetFontByNumber( dfl, ta->taFontNumber );
    if  ( ! df )
	{ LXDEB(ta->taFontNumber,df); return (AfmFontInfo *)0;	}

    afi= df->dfPsFontInfo[FACE_INDEX(ta->taFontIsSlanted,ta->taFontIsBold)];
    if  ( ! afi )
	{
#	ifdef USE_FONTCONFIG
	if  ( psfl->psflAvoidFontconfig )
	    { afi= utilGetPsFontInfoForAttribute( df, ta, psfl );	}
	else{ afi= appFcGetFontInfoForAttribute( df, ta, psfl );	}
#	else
	afi= utilGetPsFontInfoForAttribute( df, ta, psfl );
#	endif

	if  ( ! afi )
	    { XDEB(afi); return (AfmFontInfo *)0;	}
	}

    if  ( afi->afiMetricsDeferred		&&
	  appGetDeferredFontMetrics( afi )	)
	{
	SLDEB(afi->afiFullName,afi->afiMetricsDeferred);
	return (AfmFontInfo *)0;
	}

    return afi;
    }

int appGetDeferredFontMetricsForList(	PostScriptFontList *	psfl )
    {
    int		rval= 0;
    int		i;

    for ( i= 0; i < psfl->psflInfoCount; i++ )
	{
	if  ( appGetDeferredFontMetrics( psfl->psflInfos[i] ) )
	    { LDEB(i); rval= -1;	}
	}

    return rval;
    }

int appGetDeferredFontMetrics(		AfmFontInfo *		afi )
    {
#   ifdef USE_FONTCONFIG
    if  ( afi->afiMetricsDeferred && ! afi->afiAfmFileName )
	{
	if  ( appFcGetFontMetrics( afi ) )
	    { SDEB(afi->afiFullName); return -1;	}
	}
#   endif

    if  ( afi->afiMetricsDeferred && afi->afiAfmFileName )
	{
	if  ( psGetDeferredMetrics( afi ) )
	    { SDEB(afi->afiAfmFileName); return -1;	}
	}

    if  ( afi->afiMetricsDeferred )
	{ SLDEB(afi->afiFullName,afi->afiMetricsDeferred); return -1; }

    return 0;
    }

