/************************************************************************/
/*									*/
/*  Drawing primitives for X11/Motif.					*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<limits.h>

#   include	<geo2DInteger.h>
#   include	"appDraw.h"
#   include	"appScreenFont.h"

#   include	<appDebugon.h>

#   ifdef USE_XFT

#   ifdef USE_GTK
#   include	<gdk/gdkx.h>
#   endif

int appDrawDrawStringXft(	AppDrawingData *	add,
				const DrawScreenFont *	dsf,
				XftFont *		font,
				int			x,
				int			y,
				const char *		s,
				int			len )
    {
    if  ( ! add->addXftDrawable || ! font )
	{ return -1;	}

    if  ( ! add->addXftCurrentColor.axcXftColorAllocated )
	{
	appXftAllocateColor( &(add->addXftCurrentColor),
						&(add->addXftColorList) );

	if  ( ! add->addXftCurrentColor.axcXftColorAllocated )
	    { return -1;	}
	}

    XftDrawStringUtf8( add->addXftDrawable,
			&(add->addXftCurrentColor.axcXftColor), font,
			x, y, (FcChar8 *)s, len );
    return 0;
    }

int appDrawFillRectangleXft(	XftDraw *		draw,
				AppXftColor *		axc,
				AppXftColorList *	axcl,
				int			x,
				int			y,
				unsigned int		width,
				unsigned int		height )
    {
    if  ( ! draw )
	{ return -1;	}

    if  ( ! axc->axcXftColorAllocated )
	{
	appXftAllocateColor( axc, axcl );

	if  ( ! axc->axcXftColorAllocated )
	    { return -1;	}
	}

    XftDrawRect( draw, &(axc->axcXftColor), x, y, width, height );
    return 0;
    }

int appDrawTextExtentsXft(	DocumentRectangle *	drText,
				int			x,
				int			y,
				const DrawScreenFont *	hDsf,
				const DrawScreenFont *	vDsf,
				const char *		s,
				int			len )
    {
    XGlyphInfo		glyphInfo;

    if  ( ! hDsf->dsfXftFont || ! vDsf->dsfXftFont )
	{ return -1;	}

    XftTextExtentsUtf8( hDsf->dsfDisplay,
			hDsf->dsfXftFont, (FcChar8 *)s, len, &glyphInfo );

    drText->drX0= x;
    drText->drX1= drText->drX0+ glyphInfo.xOff- 1;
    drText->drY0= y- vDsf->dsfXftFont->ascent;
    drText->drY1= y+ vDsf->dsfXftFont->descent;

    return 0;
    }

void appInitDrawingDataXft(	AppDrawingData *	add )
    {
    add->addXftDrawable= (XftDraw *)0;
    appInitAppXftColorList( &(add->addXftColorList) );
    appInitAppXftColor( &(add->addXftCurrentColor) );
    }

void appCleanDrawingDataXft(	AppDrawingData *	add )
    {
    appCleanAppXftColorList( &(add->addXftColorList) );

#   ifndef USE_GTK_NO_LONGER_RELEVANT
    /*  Older versions of GTK/XFT crash here if the cleaning action is	*/
    /*  called from a destroy callback. MdD Jun 2007.			*/
    if  ( add->addXftDrawable )
	{
	XftDrawDestroy( add->addXftDrawable );
	add->addXftDrawable= (XftDraw *)0;
	}
#   endif

    return;
    }

#   endif

