/************************************************************************/
/*									*/
/*  Primitives for drawing metafiles (WMF,PICT) on X11.			*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>

#   include	<appDraw.h>

#   include	<appDebugon.h>

int appDrawPrepareRoundRect(		APP_ARC			arcs[4],
					APP_SEGMENT		segments[4],
					APP_POINT		points[12],
					const DocumentRectangle * dr,
					int			w,
					int			h )
    {
    DocumentRectangle	drHere;

    geoNormalizeRectangle( &drHere, dr );

    if  ( h < 0 )
	{ h= -h;	}
    if  ( w < 0 )
	{ w= -w;	}

    points[0].x= drHere.drX0;
    points[0].y= drHere.drY0+ h/ 2;

    arcs[0].x= drHere.drX0;
    arcs[0].y= drHere.drY0;
    arcs[0].width= w;
    arcs[0].height= h;
    arcs[0].angle1= 64*  180;
    arcs[0].angle2= 64*  -90;

    points[1].x= drHere.drX0+ w/ 2;
    points[1].y= drHere.drY0+ h/ 2;
    points[2].x= drHere.drX0+ w/ 2;
    points[2].y= drHere.drY0;

    segments[0].x1= drHere.drX0+ w/2;
    segments[0].y1= drHere.drY0;
    segments[0].x2= drHere.drX1- w/2;
    segments[0].y2= drHere.drY0;

    points[3].x= drHere.drX1- w/ 2;
    points[3].y= drHere.drY0;

    arcs[1].x= drHere.drX1- w;
    arcs[1].y= drHere.drY0;
    arcs[1].width= w;
    arcs[1].height= h;
    arcs[1].angle1= 64*   90;
    arcs[1].angle2= 64*  -90;

    points[4].x= drHere.drX1- w/ 2;
    points[4].y= drHere.drY0+ h/ 2;
    points[5].x= drHere.drX1;
    points[5].y= drHere.drY0+ w/ 2;

    segments[1].x1= drHere.drX1;
    segments[1].y1= drHere.drY0+ h/2;
    segments[1].x2= drHere.drX1;
    segments[1].y2= drHere.drY1- h/2;

    points[6].x= drHere.drX1;
    points[6].y= drHere.drY1- w/ 2;

    arcs[2].x= drHere.drX1- w;
    arcs[2].y= drHere.drY1- h;
    arcs[2].width= w;
    arcs[2].height= h;
    arcs[2].angle1= 64*    0;
    arcs[2].angle2= 64*  -90;

    points[7].x= drHere.drX1- w/ 2;
    points[7].y= drHere.drY1- h/ 2;
    points[8].x= drHere.drX1- w/ 2;
    points[8].y= drHere.drY1;

    segments[2].x1= drHere.drX1- w/2;
    segments[2].y1= drHere.drY1;
    segments[2].x2= drHere.drX0+ w/2;
    segments[2].y2= drHere.drY1;

    points[9].x= drHere.drX0+ w/ 2;
    points[9].y= drHere.drY1;

    arcs[3].x= drHere.drX0;
    arcs[3].y= drHere.drY1- h;
    arcs[3].width= w;
    arcs[3].height= h;
    arcs[3].angle1= 64*  -90;
    arcs[3].angle2= 64*  -90;

    points[10].x= drHere.drX0+ w/ 2;
    points[10].y= drHere.drY1- h/ 2;
    points[11].x= drHere.drX0;
    points[11].y= drHere.drY1- h/ 2;

    segments[3].x1= drHere.drX0;
    segments[3].y1= drHere.drY1- h/2;
    segments[3].x2= drHere.drX0;
    segments[3].y2= drHere.drY0+ h/2;

    return 0;
    }

int appDrawFillRoundRectX11(	AppDrawingData *		add,
				const DocumentRectangle *	dr,
				int				w,
				int				h )
    {
    APP_ARC	arcs[4];
    APP_SEGMENT	segments[4];
    APP_POINT	points[12];

    appDrawPrepareRoundRect( arcs, segments, points, dr, w, h );

    appDrawFillArcs( add, arcs, 4 );
    appDrawFillPolygon( add, points, 12 );

    return 0;
    }

int appDrawDrawRoundRectX11(	AppDrawingData *		add,
				const DocumentRectangle *	dr,
				int				w,
				int				h )
    {
    APP_ARC	arcs[4];
    APP_SEGMENT	segments[4];
    APP_POINT	points[12];

    appDrawPrepareRoundRect( arcs, segments, points, dr, w, h );

    appDrawDrawArcs( add, arcs, 4 );
    appDrawDrawSegments( add, segments, 4 );

    return 0;
    }

