#   ifndef	APP_DRAW_H
#   define	APP_DRAW_H

#   include	<appGuiBase.h>

#   include	<utilPropMask.h>
#   include	<utilPagedList.h>

#   include	<geo2DInteger.h>
#   include	<geoGrid.h>
#   include	<bmcolor.h>
#   include	<guiPixmap.h>
#   include	"appXftColorList.h"
#   include	<psPostScriptFontList.h>

#   ifdef USE_FONTCONFIG
#	include	<ft2build.h>
#	include	FT_FREETYPE_H

#	include	<X11/Xft/Xft.h>
#	include	<X11/extensions/Xrender.h>
#   endif

# ifdef __cplusplus
extern "C"
    {
# endif

/************************************************************************/
/*									*/
/*  An attempt to consistently use the same formula to convert from	*/
/*  twips to pixels.							*/
/*									*/
/************************************************************************/

# define X_PIXELS( add, x ) \
	    ( COORDtoGRID( (add)->addMagnifiedPixelsPerTwip, (x) ) )
# define Y_PIXELS( add, page, y ) \
	    ( (add)->addPageStepPixels* (page)+ \
	      COORDtoGRID( (add)->addMagnifiedPixelsPerTwip, (y) ) )

/************************************************************************/
/*									*/
/*  An attempt to define a more or less device independent graphics	*/
/*  interface.								*/
/*									*/
/*  Where appropriate, concepts are borrowed from the PDF file format.	*/
/*									*/
/*  The unit of the coordinates is dependent on the instance. For the	*/
/*  PostScript and PDF instances of the library it is the 'twip': One	*/
/*  twentieth part of a point. For the raw X11 and GTK instances it is	*/
/*  the pixel.								*/
/*  It is upto the user to do the necessary coordinate transforms. The	*/
/*  library tries to provide the necessary commodity functions.		*/
/*									*/
/************************************************************************/

/************************************************************************/
/*									*/
/*  For the administration of the relation between PostScript fonts and	*/
/*  X11 fonts.								*/
/*									*/
/************************************************************************/

struct AppColors;

typedef struct AppDrawingData
    {
    int				addForScreenDrawing;
    struct AppColors *		addColors;

    DocumentRectangle		addBackRect;
    DocumentRectangle		addPaperRect;
    DocumentRectangle		addDocRect;

    int				addBottomMarginPixels;
    int				addPageGapPixels;
    int				addPageStepPixels;

    double			addMagnification;
    double			addMagnifiedPixelsPerTwip;
    double			addScreenPixelsPerMM;

    const PostScriptFontList *	addPostScriptFontList;
    int				addAvoidFontconfig;
    NumberedPropertiesList	addScreenFontAdmin;
    int				addCurrentScreenFontNumber;

    APP_COLOR_RGB		addForeColor;
    APP_COLOR_RGB		addBackColor;
    APP_COLOR_RGB		addTopColor;
    APP_COLOR_RGB		addBottomColor;

#   ifdef USE_MOTIF
    Display *			addDisplay;
    int				addScreen;
    Drawable			addDrawable;
    GC				addGc;
    Atom			addCurrentFID;
#   endif

#   ifdef USE_GTK
    GdkWindow *			addDrawable;
    GdkGC *			addGc;
    GdkColormap *		addColorMap;
#   endif

				/****************************************/
				/*  To allow for an easy fallback to	*/
				/*  plain old X11 drawing always check	*/
				/*  for add->addXftDrawable != NULL.	*/
				/****************************************/
#   ifdef USE_XFT
    XftDraw *			addXftDrawable;
    AppXftColorList		addXftColorList;
    AppXftColor			addXftCurrentColor;
				/****************************************/
				/*  Is either null, or a copy of a	*/
				/*  color in the list. never allocate	*/
				/*  or free!				*/
				/****************************************/
#   endif

    } AppDrawingData;

/************************************************************************/
/*									*/
/*  Administration on colors.						*/
/*									*/
/************************************************************************/

typedef struct AppColors
    {
    ColorAllocator	acAllocator;

#   ifdef		USE_MOTIF
    Display *		acDisplay;
    Colormap		acColormap;
    int			acVisualClass;
#   endif

#   ifdef		USE_GTK
    GdkColormap *	acColormap;
    int			acVisualClass;
#   endif
    } AppColors;

#   ifdef USE_MOTIF

extern const char * const APP_VisualClasses[];

#   endif

#   if defined(USE_GTK) || defined(USE_QT)

typedef struct APP_ARC
    {
    short		x;
    short		y;
    unsigned short	width;
    unsigned short	height;
    short		angle1;
    short		angle2;
    } APP_ARC;

#   endif

#   if  defined(USE_QT)

typedef struct APP_SEGMENT
    {
    int x1, y1, x2, y2;
    } APP_SEGMENT;

#   endif

/************************************************************************/
/*									*/
/*  Procedure declarations.						*/
/*									*/
/************************************************************************/

#   ifdef USE_GTK

extern void appDrawGtkSetXFillRule(	GdkGC *			gc,
					int			rule );

#   endif

extern void appCollectExposures(	DocumentRectangle *	drClip,
					AppDrawingData *	add,
					int			ox,
					int			oy,
					APP_EVENT *		event );

extern void appInitDrawingData(		AppDrawingData *	add );
extern void appCleanDrawingData(	AppDrawingData *	add );


extern void appSetScreenDrawingEnvironment(
			AppDrawingData *		add,
			struct AppColors *		colors,
			double				magnification,
			double				xfac,
			double				screenPixPerMM,
			const PostScriptFontList *	psfl );

extern void appExposeDrawingData(	const AppDrawingData *	add );

extern void appExposeRectangle(	const AppDrawingData *		add,
				const DocumentRectangle *	drExpose );

extern int appDrawBlackColor(		AppDrawingData *	add,
					APP_COLOR_RGB *		xc );
extern int appDrawWhiteColor(		AppDrawingData *	add,
					APP_COLOR_RGB *		xc );

extern void appDrawSetForegroundBlack(	AppDrawingData *	add );
extern void appDrawSetForegroundWhite(	AppDrawingData *	add );
extern void appDrawSetBackgroundWhite(	AppDrawingData *	add );

extern void appDrawSetForegroundColor(	AppDrawingData *	add,
					APP_COLOR_RGB *		xc );

extern void appDrawSetForegroundColorRgb8(
					AppDrawingData *	add,
					const RGB8Color *	rgb8 );

extern void appDrawSetBackgroundColor(	AppDrawingData *	add,
					APP_COLOR_RGB *		xc );

extern void appDrawFillRectangle(	AppDrawingData *	add,
					int			x,
					int			y,
					int			wide,
					int			high );

extern void appDrawDrawRectangle(	AppDrawingData *	add,
					int			x,
					int			y,
					int			wide,
					int			high );

extern int appSetDrawingDataForWidget(	APP_WIDGET		w,
					AppColors *		ac,
					double			magnification,
					AppDrawingData *	add );

extern void appCloneDrawingEnvironment(	AppDrawingData *	add,
					const AppDrawingData *	parent_add,
					double			magnification,
					double			xfac,
					APP_WINDOW		drawable );

extern int appDrawOpenFont(		AppDrawingData *	add,
					const char *		name );

extern void appDrawSetFont(		AppDrawingData *	add,
					int			screenFont );

extern void appDrawDrawString(		AppDrawingData *	add,
					int			x,
					int			y,
					const char *		s,
					int			len );

extern void appDrawDrawSymbol(		AppDrawingData *	add,
					int			x,
					int			y,
					int			symbol );

extern void appDrawDrawLine(		AppDrawingData *	add,
					int			x0,
					int			y0,
					int			x1,
					int			y1 );

extern void appDrawMoveArea(		AppDrawingData *	add,
					int			src_x,
					int			src_y,
					int			wide,
					int			high,
					int			dest_x,
					int			dest_y );

extern void appDrawNoClipping(		AppDrawingData *	add );

extern void appDrawSetClipRect(	AppDrawingData *		add,
				const DocumentRectangle *	drClip );

extern void appDrawSymbolExtents( DocumentRectangle *	drText,
				int			x0,
				int			y0,
				AppDrawingData *	add,
				int			screenFont,
				int			symbol );

extern void appDrawTextExtents(	DocumentRectangle *	drText,
				int			x0,
				int			y0,
				AppDrawingData *	add,
				int			screenFont,
				const char *		s,
				int			l );

extern void appDrawScapsTextExtents(
				DocumentRectangle *	drText,
				int			x0,
				int			y0,
				AppDrawingData *	add,
				int			fullScreenFont,
				int			scapsScreenFont,
				const char *		s,
				int			l );

extern void appDrawFreePixmap(	AppDrawingData *	add,
				APP_BITMAP_IMAGE	pixmap );

extern void appDrawFillPolygon(		AppDrawingData *	add,
					const APP_POINT *	points,
					int			count );

extern void appDrawDrawLines(		AppDrawingData *	add,
					const APP_POINT *	points,
					int			count,
					int			close );

extern int appDrawGetSizeOfWidget(		int *		pWide,
						int *		pHigh,
						APP_WIDGET	w );

extern int appDrawGetSizeFromConfigureEvent(	int *		pWide,
						int *		pHigh,
						APP_WIDGET	w,
						APP_EVENT *	event );

extern void appDrawDrawPixmap(		AppDrawingData *	add,
					const ScreenPixmap	sp,
					int			xSrc,
					int			ySrc,
					int			wide,
					int			high,
					int			xDest,
					int			yDest );

extern int appGetCoordinatesFromMouseButtonEvent(
					int *			pX,
					int *			pY,
					int *			pButton,
					int *			pUpDown,
					int *			pSeq,
					unsigned int *		pKeyState,
					const APP_WIDGET	w,
					const APP_EVENT *	event );

extern int appGetCoordinatesFromMouseMoveEvent( int *		pX,
						int *		pY,
						APP_WIDGET	w,
						APP_EVENT *	event );

extern void appInitColors(	AppColors *		ac );

APP_BITMAP_MASK appMakeBitmap(	AppDrawingData *	add,
				int			wide,
				int			high );

extern int appAllocateColors(	AppDrawingData *	add,
				AppColors *		ac );

extern void appCleanColors(	AppColors *		ac );

extern int appColorRgb(		APP_COLOR_RGB *		xc,
				AppColors *		ac,
				unsigned int		r,
				unsigned int		g,
				unsigned int		b );

extern int appColorFindRgb(	APP_COLOR_RGB *		xc,
				AppColors *		ac,
				unsigned int		r,
				unsigned int		g,
				unsigned int		b );

extern int appColorNamed(	APP_COLOR_RGB *		xc,
				AppColors *		ac,
				const char *		name );

extern void appDrawDrawSegments(	AppDrawingData *	add,
					APP_SEGMENT *		segments,
					int			count );

extern void appDrawDrawArc(	AppDrawingData *	add,
				int			x,
				int			y,
				int			wide,
				int			high,
				int			angle1,
				int			angle2 );
extern void appDrawFillArc(	AppDrawingData *	add,
				int			x,
				int			y,
				int			wide,
				int			high,
				int			angle1,
				int			angle2 );

extern void appDrawDrawArcs(		AppDrawingData *	add,
					const APP_ARC *		arcs,
					int			count );

extern void appDrawFillArcs(		AppDrawingData *	add,
					const APP_ARC *		arcs,
					int			count );

extern void appDrawSetRedrawHandler(	APP_WIDGET		w,
					APP_EVENT_HANDLER_T	handler,
					void *			through );

extern void appDrawSetConfigureHandler(	APP_WIDGET		w,
					APP_EVENT_HANDLER_T	handler,
					void *			through );

extern void appDrawSetButtonPressHandler( APP_WIDGET		w,
					APP_EVENT_HANDLER_T	handler,
					void *			through );

extern void appDrawSetScrollHandler( 	APP_WIDGET		w,
					APP_EVENT_HANDLER_T	handler,
					void *			through );

extern int appDrawGetInoutFromFocusEvent(	int *		pInOut,
						APP_WIDGET	w,
						APP_EVENT *	event );

extern APP_BITMAP_IMAGE appMakePixmap(	AppDrawingData *	add,
					int			wide,
					int			high );

extern int appDrawPrepareRoundRect(
				APP_ARC				arcs[4],
				APP_SEGMENT			segments[4],
				APP_POINT			points[12],
				const DocumentRectangle *	dr,
				int				w,
				int				h );

extern int appDrawFillRoundRectX11(
				AppDrawingData *		add,
				const DocumentRectangle *	dr,
				int				w,
				int				h );

extern int appDrawDrawRoundRectX11(
				AppDrawingData *		add,
				const DocumentRectangle *	dr,
				int				w,
				int				h );

extern int appDrawSetLineAttributes(	AppDrawingData *	add,
					int			lineWidth,
					int			lineStyle,
					int			capStyle,
					int			joinStyle,
					const unsigned char *	dashList,
					int			dashCount );

extern void appDrawUnderlineGeometry(	int *			pThick,
					int *			pY,
					const AppDrawingData *	add,
					int			screenFont,
					int			baselinePixels);

extern void appDrawStrikethroughGeometry( int *			pThick,
					int *			pY,
					const AppDrawingData *	add,
					int			screenFont,
					int			baselinePixels);

extern void appDrawGetSuperBaseline(	int *			pSuperBaseline,
					int			baselinePixels,
					const AppDrawingData *	add,
					int			screenFont );

extern void appDrawGetSubBaseline(	int *			pSubBaseline,
					int			baselinePixels,
					const AppDrawingData *	add,
					int			screenFont );

extern int appFontImplementationName(	char *			target,
					int			maxlen,
					AppDrawingData *	add,
					int			screenFont );

#   ifdef USE_XFT

extern int appDrawFillRectangleXft(	XftDraw *		draw,
					AppXftColor *		axc,
					AppXftColorList *	axcl,
					int			x,
					int			y,
					unsigned int		width,
					unsigned int		height );

extern void appInitDrawingDataXft(	AppDrawingData *	add );
extern void appCleanDrawingDataXft(	AppDrawingData *	add );

extern void appDrawSetPostScriptFontList( AppDrawingData *		add,
					const PostScriptFontList *	psfl );

#   endif

#   ifdef USE_FONTCONFIG

extern const char * appFtErrorStr(	int			e );

#   endif

#   if defined(USE_GTK) && defined(USE_XFT)
    extern void appGtkXftDrawCreate(	AppDrawingData *	add );
#   endif

extern int appFindX11Fonts(		APP_WIDGET			topw,
					PostScriptFontList *		psfl );

# ifdef __cplusplus
    }
# endif

#   endif
